/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.kamelet;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Arrays;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.actions.kamelet.AbstractKameletAction;
import org.citrusframework.yaks.camelk.model.Kamelet;
import org.citrusframework.yaks.camelk.model.KameletList;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletV1Alpha1;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletV1Alpha1List;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;

public class VerifyKameletAction
extends AbstractKameletAction {
    private final String kameletName;

    public VerifyKameletAction(Builder builder) {
        super("verify-kamelet", builder);
        this.kameletName = builder.kameletName;
    }

    public void doExecute(TestContext context) {
        String name = context.replaceDynamicContentInString(this.kameletName);
        if (!this.findKamelet(name, context, this.kameletNamespace(context), this.operatorNamespace(context), this.namespace(context))) {
            throw new ValidationException(String.format("Failed to retrieve Kamelet '%s'", name));
        }
        this.LOG.info("Kamlet validation successful - All values OK!");
    }

    public boolean isDisabled(TestContext context) {
        return YaksSettings.isLocal((YaksClusterType)this.clusterType(context));
    }

    private boolean findKamelet(String name, TestContext context, String ... namespaces) {
        return Arrays.stream(namespaces).distinct().anyMatch(namespace -> {
            this.LOG.info(String.format("Verify Kamlet '%s' exists in namespace '%s'", name, namespace));
            Kamelet kamelet = this.getApiVersion(context).equals("v1alpha1") ? (Kamelet)((Object)((Object)((Resource)((NonNamespaceOperation)this.getKubernetesClient().resources(KameletV1Alpha1.class, KameletV1Alpha1List.class).inNamespace(namespace)).withName(name)).get())) : (Kamelet)((Object)((Object)((Resource)((NonNamespaceOperation)this.getKubernetesClient().resources(Kamelet.class, KameletList.class).inNamespace(namespace)).withName(name)).get()));
            if (this.LOG.isDebugEnabled()) {
                if (kamelet == null) {
                    this.LOG.debug(String.format("Kamelet '%s' is not present in namespace '%s'", name, namespace));
                } else {
                    this.LOG.debug(String.format("Found Kamelet in namespace '%s'", namespace));
                    this.LOG.debug(KubernetesSupport.yaml().dumpAsMap((Object)kamelet));
                }
            }
            return kamelet != null;
        });
    }

    public static final class Builder
    extends AbstractKameletAction.Builder<VerifyKameletAction, Builder> {
        private String kameletName;

        public Builder isAvailable() {
            return this;
        }

        public Builder kameletName(String kameletName) {
            this.kameletName = kameletName;
            return this;
        }

        public VerifyKameletAction build() {
            return new VerifyKameletAction(this);
        }
    }
}

