/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.jbang;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.FileUtils;
import org.citrusframework.yaks.camelk.jbang.CamelJBangSettings;
import org.citrusframework.yaks.camelk.jbang.ProcessAndOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class CamelJBang {
    private static final Logger LOG = LoggerFactory.getLogger(CamelJBang.class);
    private static final boolean IS_OS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    private static final int OK_EXIT_CODE = 0;
    private static Path installDir;
    private static CamelJBang INSTANCE;

    private CamelJBang() {
    }

    public static CamelJBang camel() {
        if (INSTANCE == null) {
            CamelJBang.detectJBang();
            CamelJBang.addTrust();
            INSTANCE = new CamelJBang();
        }
        return INSTANCE;
    }

    public ProcessAndOutput run(String name, Path path, String ... args) {
        return this.run(name, path.toAbsolutePath().toString(), args);
    }

    public ProcessAndOutput run(String name, String file, String ... args) {
        ArrayList<String> runArgs = new ArrayList<String>();
        runArgs.add("run");
        runArgs.add("--name");
        runArgs.add(name);
        if (CamelJBangSettings.getKameletsLocalDir() != null) {
            runArgs.add("--local-kamelet-dir");
            runArgs.add(CamelJBangSettings.getKameletsLocalDir().toString());
        }
        runArgs.addAll(Arrays.asList(args));
        runArgs.add(file);
        if (CamelJBangSettings.isCamelDumpIntegrationOutput()) {
            Path workDir = CamelJBangSettings.getWorkDir();
            File outputFile = workDir.resolve(String.format("i-%s-output.txt", name)).toFile();
            return CamelJBang.executeAsync(CamelJBang.camel((String[])runArgs.toArray(String[]::new)), outputFile);
        }
        return CamelJBang.executeAsync(CamelJBang.camel((String[])runArgs.toArray(String[]::new)));
    }

    public void stop(Long pid) {
        ProcessAndOutput p = CamelJBang.execute(CamelJBang.camel("stop", String.valueOf(pid)));
        if (p.getProcess().exitValue() != 0) {
            throw new CitrusRuntimeException(String.format("Failed to stop Camel K integration - exit code %d", p.getProcess().exitValue()));
        }
    }

    public String ps() {
        ProcessAndOutput p = CamelJBang.execute(CamelJBang.camel("ps"));
        return p.getOutput();
    }

    public String version() {
        ProcessAndOutput p = CamelJBang.execute(CamelJBang.camel("--version"));
        return p.getOutput();
    }

    public Map<String, String> get(Long pid) {
        HashMap<String, String> hashMap;
        HashMap<String, String> properties = new HashMap<String, String>();
        String output = this.ps();
        if (output.isBlank()) {
            return properties;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.getBytes(StandardCharsets.UTF_8))));
        try {
            String line = reader.readLine();
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(line.trim().split("\\s+")));
            while ((line = reader.readLine()) != null) {
                ArrayList<String> values = new ArrayList<String>(Arrays.asList(line.trim().split("\\s+")));
                if (values.isEmpty() || !((String)values.get(0)).equals(String.valueOf(pid))) continue;
                for (int i = 0; i < names.size(); ++i) {
                    if (i < values.size()) {
                        properties.put((String)names.get(i), (String)values.get(i));
                        continue;
                    }
                    properties.put((String)names.get(i), "");
                }
            }
            hashMap = properties;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to get integration details from JBang", (Throwable)e);
            }
        }
        reader.close();
        return hashMap;
    }

    public List<Map<String, String>> getAll() {
        ArrayList<Map<String, String>> arrayList;
        ArrayList<Map<String, String>> integrations = new ArrayList<Map<String, String>>();
        String output = this.ps();
        if (output.isBlank()) {
            return integrations;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.getBytes(StandardCharsets.UTF_8))));
        try {
            String line = reader.readLine();
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(line.trim().split("\\s+")));
            while ((line = reader.readLine()) != null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                ArrayList<String> values = new ArrayList<String>(Arrays.asList(line.trim().split("\\s+")));
                for (int i = 0; i < names.size(); ++i) {
                    if (i < values.size()) {
                        properties.put((String)names.get(i), (String)values.get(i));
                        continue;
                    }
                    properties.put((String)names.get(i), "");
                }
                integrations.add(properties);
            }
            arrayList = integrations;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to list integrations from JBang", (Throwable)e);
            }
        }
        reader.close();
        return arrayList;
    }

    private static void detectJBang() {
        ProcessAndOutput result = CamelJBang.getVersion();
        if (result.getProcess().exitValue() == 0) {
            LOG.info("Found JBang v" + result.getOutput());
        } else {
            LOG.warn("JBang not found. Downloading ...");
            CamelJBang.download();
            result = CamelJBang.getVersion();
            if (result.getProcess().exitValue() == 0) {
                LOG.info("Using JBang v" + result.getOutput());
            }
        }
    }

    private static void download() {
        String homePath = "jbang";
        Path installPath = Paths.get(System.getProperty("user.home"), new String[0]).toAbsolutePath().resolve(".jbang").toAbsolutePath();
        if (installPath.resolve(homePath).toFile().exists()) {
            LOG.info("Using local JBang in " + installPath);
            installDir = installPath.resolve(homePath);
            return;
        }
        LOG.info("Downloading JBang from " + CamelJBangSettings.getJBangDownloadUrl() + " and installing in " + installPath);
        try {
            Files.createDirectories(installPath, new FileAttribute[0]);
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(CamelJBangSettings.getJBangDownloadUrl())).GET().build();
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpResponse<Path> response = client.send(request, HttpResponse.BodyHandlers.ofFileDownload(installPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
            if (response.statusCode() != 200) {
                throw new CitrusRuntimeException(String.format("Failed to download JBang - response code %d", response.statusCode()));
            }
            CamelJBang.unzip(response.body(), installPath);
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new CitrusRuntimeException("Failed to download JBang", (Throwable)e);
        }
        installDir = installPath.resolve(homePath);
    }

    private static ProcessAndOutput getVersion() {
        return CamelJBang.execute(CamelJBang.jBang("version"));
    }

    private static void addTrust() {
        for (String url : CamelJBangSettings.getTrustUrl()) {
            ProcessAndOutput result = CamelJBang.execute(CamelJBang.jBang("trust", "add", url));
            int exitValue = result.getProcess().exitValue();
            if (exitValue == 0 || exitValue == 1) continue;
            throw new CitrusRuntimeException("Error while trusting JBang URLs. Exit code: " + exitValue);
        }
    }

    private static List<String> camel(String ... args) {
        ArrayList<String> jBangArgs = new ArrayList<String>();
        jBangArgs.add(String.format("-Dcamel.jbang.version=%s", CamelJBangSettings.getCamelVersion()));
        if (!CamelJBangSettings.getKameletsVersion().isBlank()) {
            jBangArgs.add(String.format("-Dcamel-kamelets.version=%s", CamelJBangSettings.getKameletsVersion()));
        }
        jBangArgs.add(CamelJBangSettings.getCamelApp());
        jBangArgs.addAll(List.of(args));
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Full Camel JBang command is: %s", String.join((CharSequence)" ", jBangArgs)));
        }
        return CamelJBang.jBang(jBangArgs);
    }

    private static List<String> jBang(String ... args) {
        return CamelJBang.jBang(List.of(args));
    }

    private static List<String> jBang(List<String> args) {
        ArrayList<String> command = new ArrayList<String>();
        if (IS_OS_WINDOWS) {
            command.add("cmd.exe");
            command.add("/c");
        } else {
            command.add("sh");
            command.add("-c");
        }
        String jBangCommand = CamelJBang.getJBangExecutable() + " " + String.join((CharSequence)" ", args);
        command.add(jBangCommand);
        return command;
    }

    private static ProcessAndOutput execute(List<String> command) {
        try {
            Process p = new ProcessBuilder(command).redirectErrorStream(true).start();
            String output = StreamUtils.copyToString((InputStream)p.getInputStream(), (Charset)StandardCharsets.UTF_8);
            p.waitFor();
            if (CamelJBangSettings.isDumpProcessOutput()) {
                Path workDir = CamelJBangSettings.getWorkDir();
                FileUtils.writeToFile((String)output, (File)workDir.resolve(String.format("%s-output.txt", p.pid())).toFile());
            }
            if (LOG.isDebugEnabled() && p.exitValue() != 0) {
                LOG.debug("Command failed: " + String.join((CharSequence)" ", command));
                LOG.debug(output);
            }
            return new ProcessAndOutput(p, output);
        }
        catch (IOException | InterruptedException e) {
            throw new CitrusRuntimeException("Error while executing JBang", (Throwable)e);
        }
    }

    private static ProcessAndOutput executeAsync(List<String> command) {
        try {
            Process p = new ProcessBuilder(command).redirectErrorStream(true).start();
            return new ProcessAndOutput(p);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Error while executing JBang", (Throwable)e);
        }
    }

    private static ProcessAndOutput executeAsync(List<String> command, File outputFile) {
        try {
            Process p = new ProcessBuilder(command).redirectErrorStream(true).redirectOutput(outputFile).start();
            return new ProcessAndOutput(p, outputFile);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Error while executing JBang", (Throwable)e);
        }
    }

    private static String getJBangExecutable() {
        if (installDir != null) {
            if (IS_OS_WINDOWS) {
                return installDir.resolve("bin/jbang.cmd").toString();
            }
            return installDir.resolve("bin/jbang").toString();
        }
        if (IS_OS_WINDOWS) {
            return "jbang.cmd";
        }
        return "jbang";
    }

    private static void unzip(Path downloadZip, Path installPath) throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(downloadZip.toFile()));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            Path filePath = CamelJBang.newFile(installPath, zipEntry);
            File newFile = filePath.toFile();
            if (zipEntry.isDirectory()) {
                if (!newFile.isDirectory() && !newFile.mkdirs()) {
                    throw new IOException("Failed to create directory " + newFile);
                }
            } else {
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + parent);
                }
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    StreamUtils.copy((InputStream)zis, (OutputStream)fos);
                }
                if ("jbang".equals(filePath.getFileName().toString())) {
                    Files.setPosixFilePermissions(filePath, PosixFilePermissions.fromString("rwxr--r--"));
                }
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private static Path newFile(Path destinationDir, ZipEntry zipEntry) throws IOException {
        Path destFile = destinationDir.resolve(zipEntry.getName());
        String destDirPath = destinationDir.toFile().getCanonicalPath();
        String destFilePath = destFile.toFile().getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

