/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.yaks.camelk.CamelKSettings;
import org.citrusframework.yaks.camelk.model.IntegrationSpec;
import org.citrusframework.yaks.camelk.model.IntegrationStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Group(value="camel.apache.org")
@Version(value="v1")
public class Integration
extends CustomResource<IntegrationSpec, IntegrationStatus>
implements Namespaced {
    public Integration() {
        this.spec = new IntegrationSpec();
        this.status = null;
    }

    public String getApiVersion() {
        return "camel.apache.org/" + CamelKSettings.getApiVersion();
    }

    public static class Builder {
        private final Map<String, IntegrationSpec.TraitConfig> traits = new LinkedHashMap<String, IntegrationSpec.TraitConfig>();
        private final List<IntegrationSpec.Resource> resources = new ArrayList<IntegrationSpec.Resource>();
        private final List<String> dependencies = new ArrayList<String>();
        private final List<IntegrationSpec.Configuration> configuration = new ArrayList<IntegrationSpec.Configuration>();
        private String source;
        private String fileName;
        private String name;

        public Builder name(String name) {
            this.name = name;
            if (this.fileName == null) {
                this.fileName = name;
            }
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder source(String fileName, String source) {
            this.source = source;
            this.fileName = fileName;
            return this;
        }

        public Builder openApi(String fileName, String content) {
            this.resources.add(new IntegrationSpec.Resource("openapi", null, fileName, content));
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder traits(Map<String, IntegrationSpec.TraitConfig> traits) {
            this.traits.putAll(traits);
            return this;
        }

        public Builder trait(String name, IntegrationSpec.TraitConfig config) {
            this.traits.put(name, config);
            return this;
        }

        public Builder configuration(List<IntegrationSpec.Configuration> configuration) {
            this.configuration.addAll(configuration);
            return this;
        }

        public Integration build() {
            Integration i = new Integration();
            i.getMetadata().setName(this.sanitizeIntegrationName(this.name));
            ((IntegrationSpec)i.getSpec()).setSources(Collections.singletonList(new IntegrationSpec.Source(this.fileName, this.source)));
            if (!this.dependencies.isEmpty()) {
                ((IntegrationSpec)i.getSpec()).setDependencies(this.dependencies);
            }
            if (!this.traits.isEmpty()) {
                ((IntegrationSpec)i.getSpec()).setTraits(this.traits);
            }
            if (!this.configuration.isEmpty()) {
                ((IntegrationSpec)i.getSpec()).setConfiguration(this.configuration);
            }
            if (!this.resources.isEmpty()) {
                ((IntegrationSpec)i.getSpec()).setResources(this.resources);
            }
            return i;
        }

        private String sanitizeIntegrationName(String name) {
            String sanitized = name.contains(".") ? name.substring(0, name.indexOf(".")) : name;
            sanitized = sanitized.replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase();
            return sanitized.replaceAll("[^a-z0-9-]", "");
        }
    }
}

