/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"replicas", "flows", "sources", "resources", "kit", "dependencies", "profile", "traits", "configuration", "repositories", "serviceAccountName"})
public class IntegrationSpec
implements KubernetesResource {
    @JsonProperty(value="replicas")
    private Integer replicas;
    @JsonProperty(value="flows")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Map<String, Object>> flows;
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Source> sources;
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Resource> resources;
    @JsonProperty(value="kit")
    private String kit;
    @JsonProperty(value="dependencies")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> dependencies;
    @JsonProperty(value="profile")
    private String profile;
    @JsonProperty(value="traits")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, TraitConfig> traits;
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Configuration> configuration;
    @JsonProperty(value="repositories")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> repositories;
    @JsonProperty(value="serviceAccountName")
    private String serviceAccountName;

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public List<Map<String, Object>> getFlows() {
        return this.flows;
    }

    public void setFlows(List<Map<String, Object>> flows) {
        this.flows = flows;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public String getKit() {
        return this.kit;
    }

    public void setKit(String kit) {
        this.kit = kit;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public Map<String, TraitConfig> getTraits() {
        return this.traits;
    }

    public void setTraits(Map<String, TraitConfig> traits) {
        this.traits = traits;
    }

    public List<Configuration> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(List<Configuration> configuration) {
        this.configuration = configuration;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<String> repositories) {
        this.repositories = repositories;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public void setServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    private static class DataSpec {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="content")
        private String content;
        @JsonProperty(value="contentRef")
        private String contentRef;
        @JsonProperty(value="contentType")
        private String contentType;
        @JsonProperty(value="contentKey")
        private String contentKey;
        @JsonProperty(value="compression")
        private String compression;
        @JsonProperty(value="rawContent")
        private String rawContent;

        public DataSpec() {
        }

        public DataSpec(String name, String content) {
            this.content = content;
            this.name = name;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getContentRef() {
            return this.contentRef;
        }

        public void setContentRef(String contentRef) {
            this.contentRef = contentRef;
        }

        public String getContentKey() {
            return this.contentKey;
        }

        public void setContentKey(String contentKey) {
            this.contentKey = contentKey;
        }

        public String getCompression() {
            return this.compression;
        }

        public void setCompression(String compression) {
            this.compression = compression;
        }

        public String getRawContent() {
            return this.rawContent;
        }

        public void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"type", "mountPath", "name", "path", "rawContent", "content", "contentType", "contentRef", "contentKey", "compression"})
    public static class Resource
    extends DataSpec
    implements KubernetesResource {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="mountPath")
        private String mountPath;

        public Resource() {
        }

        public Resource(String type, String mountPath, String name, String content) {
            super(name, content);
            this.mountPath = mountPath;
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getMountPath() {
            return this.mountPath;
        }

        public void setMountPath(String mountPath) {
            this.mountPath = mountPath;
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"language", "loader", "type", "name", "path", "rawContent", "content", "contentType", "contentRef", "contentKey", "compression", "property-names", "interceptors"})
    public static class Source
    extends DataSpec
    implements KubernetesResource {
        @JsonProperty(value="language")
        private String language;
        @JsonProperty(value="loader")
        private String loader;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="interceptors")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private List<String> interceptors;
        @JsonProperty(value="property-names")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private List<String> propertyNames;

        public Source() {
        }

        public Source(String name, String content) {
            super(name, content);
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getLoader() {
            return this.loader;
        }

        public void setLoader(String loader) {
            this.loader = loader;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<String> getInterceptors() {
            return this.interceptors;
        }

        public void setInterceptors(List<String> interceptors) {
            this.interceptors = interceptors;
        }

        public List<String> getPropertyNames() {
            return this.propertyNames;
        }

        public void setPropertyNames(List<String> propertyNames) {
            this.propertyNames = propertyNames;
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"configuration"})
    public static class TraitConfig
    implements KubernetesResource {
        @JsonProperty(value="configuration")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private Map<String, Object> configuration = new HashMap<String, Object>();

        public TraitConfig() {
        }

        public TraitConfig(String key, Object value) {
            this.add(key, value);
        }

        public Map<String, Object> getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(Map<String, Object> configuration) {
            this.configuration = configuration;
        }

        public void add(String key, Object value) {
            this.configuration.put(key, value);
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"type", "value"})
    public static class Configuration
    implements KubernetesResource {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="value")
        private String value;

        public Configuration() {
        }

        public Configuration(String type, String value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String defaultValue) {
            this.value = defaultValue;
        }
    }
}

