/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.yaks.camelk.model.KameletSpec;
import org.citrusframework.yaks.camelk.model.KameletStatus;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Group(value="camel.apache.org")
@Version(value="v1")
public class Kamelet
extends CustomResource<KameletSpec, KameletStatus>
implements Namespaced {
    public Kamelet() {
        this.spec = new KameletSpec();
        this.status = null;
    }

    public static class Builder {
        protected String name;
        private String template;
        private KameletSpec.Definition definition = new KameletSpec.Definition();
        private final Map<String, KameletSpec.DataTypesSpec> dataTypes = new HashMap<String, KameletSpec.DataTypesSpec>();
        private List<String> dependencies = new ArrayList<String>();
        private KameletSpec.Source source;
        private final Map<String, String> labels = new LinkedHashMap<String, String>();
        private final Map<String, String> annotations = new LinkedHashMap<String, String>();

        public Builder name(String name) {
            this.name = name;
            this.definition.setTitle(StringUtils.capitalize((String)name));
            return this;
        }

        public Builder definition(KameletSpec.Definition definition) {
            this.definition = definition;
            return this;
        }

        public Builder source(String name, String language, String content) {
            this.source = new KameletSpec.Source(name + "." + language, content);
            return this;
        }

        public Builder source(String name, String content) {
            this.source = new KameletSpec.Source(name, content);
            return this;
        }

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        @Deprecated
        public Builder flow(String flow) {
            this.template = flow;
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.dependencies = Collections.unmodifiableList(dependencies);
            return this;
        }

        public Builder dataTypes(Map<String, KameletSpec.DataTypesSpec> types) {
            this.dataTypes.putAll(types);
            return this;
        }

        public Builder addDataType(String slot, String scheme, String format) {
            if (this.dataTypes.containsKey(slot)) {
                this.dataTypes.get(slot).getTypes().put(format, new KameletSpec.DataTypeSpec(scheme, format));
            } else {
                this.dataTypes.put(slot, new KameletSpec.DataTypesSpec(format, new KameletSpec.DataTypeSpec(scheme, format)));
            }
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.labels.putAll(labels);
            return this;
        }

        public Builder addLabel(String name, String value) {
            this.labels.put(name, value);
            return this;
        }

        public Builder annotations(Map<String, String> annotations) {
            this.annotations.putAll(annotations);
            return this;
        }

        public Builder addAnnotation(String name, String value) {
            this.annotations.put(name, value);
            return this;
        }

        public Kamelet build() {
            Kamelet kamelet = new Kamelet();
            kamelet.getMetadata().setName(this.name);
            ((KameletSpec)kamelet.getSpec()).setDefinition(this.definition);
            kamelet.getMetadata().getAnnotations().putAll(this.annotations);
            kamelet.getMetadata().getLabels().putAll(this.labels);
            if (this.template != null && !this.template.isEmpty()) {
                ((KameletSpec)kamelet.getSpec()).setTemplate((Map)KubernetesSupport.yaml().load(this.template));
            }
            if (this.source != null) {
                ((KameletSpec)kamelet.getSpec()).setSources(Collections.singletonList(this.source));
            }
            ((KameletSpec)kamelet.getSpec()).setDependencies(this.dependencies);
            ((KameletSpec)kamelet.getSpec()).setDataTypes(this.dataTypes);
            return kamelet;
        }
    }
}

