/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"definition", "dataTypes", "dependencies", "sources", "authorization", "flow", "template"})
public class KameletSpec
implements KubernetesResource {
    @JsonProperty(value="definition")
    private Definition definition;
    @JsonProperty(value="dataTypes")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, DataTypesSpec> dataTypes;
    @JsonProperty(value="dependencies")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> dependencies;
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Source> sources;
    @JsonProperty(value="authorization")
    private AuthorizationSpec authorization;
    @JsonProperty(value="flow")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> flow;
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> template;

    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    public AuthorizationSpec getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(AuthorizationSpec authorization) {
        this.authorization = authorization;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public Map<String, DataTypesSpec> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(Map<String, DataTypesSpec> dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Deprecated
    public Map<String, Object> getFlow() {
        return this.flow;
    }

    @Deprecated
    public void setFlow(Map<String, Object> flow) {
        this.flow = flow;
    }

    public Map<String, Object> getTemplate() {
        return this.template;
    }

    public void setTemplate(Map<String, Object> template) {
        this.template = template;
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"title", "description", "required", "properties", "type"})
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Definition
    implements KubernetesResource {
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="required")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private List<String> required = new ArrayList<String>();
        @JsonProperty(value="properties")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private Map<String, PropertyConfig> properties = new HashMap<String, PropertyConfig>();

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<String> getRequired() {
            return this.required;
        }

        public void setRequired(List<String> required) {
            this.required = required;
        }

        public Map<String, PropertyConfig> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, PropertyConfig> properties) {
            this.properties = properties;
        }

        @JsonDeserialize(using=JsonDeserializer.None.class)
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonPropertyOrder(value={"title", "description", "type", "default", "example"})
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class PropertyConfig
        implements KubernetesResource {
            @JsonProperty(value="title")
            private String title;
            @JsonProperty(value="description")
            private String description;
            @JsonProperty(value="type")
            private String type;
            @JsonProperty(value="default")
            private Object defaultValue;
            @JsonProperty(value="example")
            private Object example;

            public PropertyConfig() {
            }

            public PropertyConfig(String title, String type, Object defaultValue, Object example) {
                this.title = title;
                this.type = type;
                this.defaultValue = defaultValue;
                this.example = example;
            }

            public String getTitle() {
                return this.title;
            }

            public void setTitle(String title) {
                this.title = title;
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public Object getDefault() {
                return this.defaultValue;
            }

            public void setDefault(Object defaultValue) {
                this.defaultValue = defaultValue;
            }

            public Object getExample() {
                return this.example;
            }

            public void setExample(Object example) {
                this.example = example;
            }
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class AuthorizationSpec
    implements KubernetesResource {
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"type", "title", "description", "required", "default"})
    public static class HeaderSpec
    implements KubernetesResource {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="required")
        private boolean required;
        @JsonProperty(value="default")
        private String defaultValue;

        public HeaderSpec() {
        }

        public HeaderSpec(String type, String title, boolean required, String defaultValue) {
            this.type = type;
            this.title = title;
            this.required = required;
            this.defaultValue = defaultValue;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"scheme", "format", "description", "mediaType", "headers", "dependencies", "schema"})
    public static class DataTypeSpec
    implements KubernetesResource {
        @JsonProperty(value="scheme")
        private String scheme;
        @JsonProperty(value="format")
        private String format;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="mediaType")
        private String mediaType;
        @JsonProperty(value="headers")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private Map<String, HeaderSpec> headers;
        @JsonProperty(value="dependencies")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private List<String> dependencies;
        @JsonProperty(value="schema")
        private ObjectSchema schema;

        public DataTypeSpec() {
        }

        public DataTypeSpec(String scheme, String format) {
            this.scheme = scheme;
            this.format = format;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public ObjectSchema getSchema() {
            return this.schema;
        }

        public void setSchema(ObjectSchema schema) {
            this.schema = schema;
        }

        public Map<String, HeaderSpec> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, HeaderSpec> headers) {
            this.headers = headers;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(List<String> dependencies) {
            this.dependencies = dependencies;
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"default", "types", "headers"})
    public static class DataTypesSpec
    implements KubernetesResource {
        @JsonProperty(value="default")
        private String defaultType;
        @JsonProperty(value="types")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private Map<String, DataTypeSpec> types = new HashMap<String, DataTypeSpec>();
        @JsonProperty(value="headers")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private Map<String, HeaderSpec> headers = new HashMap<String, HeaderSpec>();

        public DataTypesSpec() {
        }

        public DataTypesSpec(String defaultType, DataTypeSpec ... types) {
            this.defaultType = defaultType;
            for (DataTypeSpec spec : types) {
                this.types.put(spec.format, spec);
            }
        }

        public Map<String, DataTypeSpec> getTypes() {
            return this.types;
        }

        public void setTypes(Map<String, DataTypeSpec> types) {
            this.types = types;
        }

        public String getDefaultType() {
            return this.defaultType;
        }

        public void setDefaultType(String defaultType) {
            this.defaultType = defaultType;
        }

        public Map<String, HeaderSpec> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, HeaderSpec> headers) {
            this.headers = headers;
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"name", "content"})
    public static class Source
    implements KubernetesResource {
        @JsonProperty(value="content")
        private String content;
        @JsonProperty(value="name")
        private String name;

        public Source() {
        }

        public Source(String name, String content) {
            this.content = content;
            this.name = name;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

