/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.citrusframework.yaks.camelk.model.IntegrationSpec;
import org.citrusframework.yaks.camelk.model.PipeSpec;
import org.citrusframework.yaks.camelk.model.PipeStatus;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Group(value="camel.apache.org")
@Version(value="v1")
public class Pipe
extends CustomResource<PipeSpec, PipeStatus>
implements Namespaced {
    public Pipe() {
        this.spec = new PipeSpec();
        this.status = null;
    }

    public static class Builder {
        protected String name;
        private int replicas;
        private IntegrationSpec integration;
        private PipeSpec.Endpoint source;
        private PipeSpec.Endpoint sink;
        private final List<PipeSpec.Endpoint> steps = new ArrayList<PipeSpec.Endpoint>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder integration(IntegrationSpec integration) {
            this.integration = integration;
            return this;
        }

        public Builder source(PipeSpec.Endpoint source) {
            this.source = source;
            return this;
        }

        public Builder source(String uri) {
            return this.source(new PipeSpec.Endpoint(uri));
        }

        public Builder source(PipeSpec.Endpoint.ObjectReference ref, String properties) {
            Map props = null;
            if (properties != null && !properties.isEmpty()) {
                props = (Map)KubernetesSupport.yaml().load(properties);
            }
            return this.source(new PipeSpec.Endpoint(ref, props));
        }

        public Builder sink(PipeSpec.Endpoint sink) {
            this.sink = sink;
            return this;
        }

        public Builder sink(String uri) {
            return this.sink(new PipeSpec.Endpoint(uri));
        }

        public Builder sink(PipeSpec.Endpoint.ObjectReference ref, String properties) {
            Map props = null;
            if (properties != null && !properties.isEmpty()) {
                props = (Map)KubernetesSupport.yaml().load(properties);
            }
            return this.sink(new PipeSpec.Endpoint(ref, props));
        }

        public Builder steps(PipeSpec.Endpoint ... step) {
            this.steps.addAll(Arrays.asList(step));
            return this;
        }

        public Builder addStep(PipeSpec.Endpoint step) {
            this.steps.add(step);
            return this;
        }

        public Builder addStep(String uri) {
            return this.addStep(new PipeSpec.Endpoint(uri));
        }

        public Builder addStep(PipeSpec.Endpoint.ObjectReference ref, String properties) {
            Map props = null;
            if (properties != null && !properties.isEmpty()) {
                props = (Map)KubernetesSupport.yaml().load(properties);
            }
            return this.addStep(new PipeSpec.Endpoint(ref, props));
        }

        public Builder replicas(int replicas) {
            this.replicas = replicas;
            return this;
        }

        public Pipe build() {
            Pipe pipe = new Pipe();
            pipe.getMetadata().setName(this.name);
            if (this.replicas > 0) {
                ((PipeSpec)pipe.getSpec()).setReplicas(this.replicas);
            }
            if (this.integration != null) {
                ((PipeSpec)pipe.getSpec()).setIntegration(this.integration);
            }
            if (this.source != null) {
                ((PipeSpec)pipe.getSpec()).setSource(this.source);
            }
            if (this.sink != null) {
                ((PipeSpec)pipe.getSpec()).setSink(this.sink);
            }
            if (!this.steps.isEmpty()) {
                ((PipeSpec)pipe.getSpec()).setSteps(this.steps.toArray(new PipeSpec.Endpoint[0]));
            }
            return pipe;
        }
    }
}

