/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.model.v1alpha1;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import org.citrusframework.yaks.camelk.model.IntegrationSpec;
import org.citrusframework.yaks.camelk.model.Pipe;
import org.citrusframework.yaks.camelk.model.PipeSpec;
import org.citrusframework.yaks.camelk.model.PipeStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Group(value="camel.apache.org")
@Version(value="v1alpha1")
public class KameletBinding
extends Pipe {

    public static class Builder
    extends Pipe.Builder {
        Pipe.Builder delegate = new Pipe.Builder();

        @Override
        public Builder name(String name) {
            this.name = name;
            this.delegate.name(name);
            return this;
        }

        @Override
        public Builder integration(IntegrationSpec integration) {
            this.delegate.integration(integration);
            return this;
        }

        @Override
        public Builder source(PipeSpec.Endpoint source) {
            this.delegate.source(source);
            return this;
        }

        @Override
        public Builder source(String uri) {
            this.delegate.source(uri);
            return this;
        }

        @Override
        public Builder source(PipeSpec.Endpoint.ObjectReference ref, String properties) {
            this.delegate.source(ref, properties);
            return this;
        }

        @Override
        public Builder sink(PipeSpec.Endpoint sink) {
            this.delegate.sink(sink);
            return this;
        }

        @Override
        public Builder sink(String uri) {
            this.delegate.sink(uri);
            return this;
        }

        @Override
        public Builder sink(PipeSpec.Endpoint.ObjectReference ref, String properties) {
            this.delegate.sink(ref, properties);
            return this;
        }

        @Override
        public Builder steps(PipeSpec.Endpoint ... step) {
            this.delegate.steps(step);
            return this;
        }

        @Override
        public Builder addStep(PipeSpec.Endpoint step) {
            this.delegate.addStep(step);
            return this;
        }

        @Override
        public Builder addStep(String uri) {
            this.delegate.addStep(new PipeSpec.Endpoint(uri));
            return this;
        }

        @Override
        public Builder addStep(PipeSpec.Endpoint.ObjectReference ref, String properties) {
            this.delegate.addStep(ref, properties);
            return this;
        }

        @Override
        public Builder replicas(int replicas) {
            this.delegate.replicas(replicas);
            return this;
        }

        public Builder from(Pipe pipe) {
            this.delegate.name(pipe.getMetadata().getName());
            this.delegate.source(((PipeSpec)pipe.getSpec()).getSource());
            this.delegate.sink(((PipeSpec)pipe.getSpec()).getSink());
            if (((PipeSpec)pipe.getSpec()).getSteps() != null) {
                this.delegate.steps(((PipeSpec)pipe.getSpec()).getSteps());
            }
            this.delegate.integration(((PipeSpec)pipe.getSpec()).getIntegration());
            if (((PipeSpec)pipe.getSpec()).getReplicas() != null) {
                this.delegate.replicas(((PipeSpec)pipe.getSpec()).getReplicas());
            }
            return this;
        }

        @Override
        public KameletBinding build() {
            Pipe b = this.delegate.build();
            KameletBinding binding = new KameletBinding();
            binding.setMetadata(b.getMetadata());
            binding.setSpec((PipeSpec)b.getSpec());
            binding.setStatus((PipeStatus)b.getStatus());
            return binding;
        }
    }
}

