/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.model.v1alpha1;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.List;
import java.util.Map;
import org.citrusframework.yaks.camelk.model.Kamelet;
import org.citrusframework.yaks.camelk.model.KameletSpec;
import org.citrusframework.yaks.camelk.model.KameletStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Group(value="camel.apache.org")
@Kind(value="Kamelet")
@Version(value="v1alpha1")
public class KameletV1Alpha1
extends Kamelet
implements Namespaced {
    public KameletV1Alpha1() {
        this.spec = new KameletSpec();
        this.status = null;
    }

    public static class Builder
    extends Kamelet.Builder {
        Kamelet.Builder delegate = new Kamelet.Builder();

        @Override
        public Builder name(String name) {
            this.name = name;
            this.delegate.name(name);
            return this;
        }

        @Override
        public Builder definition(KameletSpec.Definition definition) {
            this.delegate.definition(definition);
            return this;
        }

        @Override
        public Builder source(String name, String language, String content) {
            this.delegate.source(name, language, content);
            return this;
        }

        @Override
        public Builder source(String name, String content) {
            this.delegate.source(name, content);
            return this;
        }

        @Override
        public Builder template(String template) {
            this.delegate.template(template);
            return this;
        }

        @Override
        @Deprecated
        public Builder flow(String flow) {
            this.delegate.flow(flow);
            return this;
        }

        @Override
        public Builder dependencies(List<String> dependencies) {
            this.delegate.dependencies(dependencies);
            return this;
        }

        @Override
        public Builder dataTypes(Map<String, KameletSpec.DataTypesSpec> types) {
            this.delegate.dataTypes(types);
            return this;
        }

        @Override
        public Builder addDataType(String slot, String scheme, String format) {
            this.delegate.addDataType(slot, scheme, format);
            return this;
        }

        public Builder from(Kamelet kamelet) {
            this.delegate.name(kamelet.getMetadata().getName());
            this.delegate.annotations(kamelet.getMetadata().getAnnotations());
            this.delegate.labels(kamelet.getMetadata().getLabels());
            if (kamelet.getSpec() != null) {
                if (((KameletSpec)kamelet.getSpec()).getDefinition() != null) {
                    this.delegate.definition(((KameletSpec)kamelet.getSpec()).getDefinition());
                }
                if (((KameletSpec)kamelet.getSpec()).getSources() != null && !((KameletSpec)kamelet.getSpec()).getSources().isEmpty()) {
                    KameletSpec.Source source = ((KameletSpec)kamelet.getSpec()).getSources().get(0);
                    this.delegate.source(source.getName(), source.getContent());
                }
                if (((KameletSpec)kamelet.getSpec()).getDependencies() != null) {
                    this.delegate.dependencies(((KameletSpec)kamelet.getSpec()).getDependencies());
                }
                if (((KameletSpec)kamelet.getSpec()).getDataTypes() != null) {
                    this.delegate.dataTypes(((KameletSpec)kamelet.getSpec()).getDataTypes());
                }
            }
            return this;
        }

        @Override
        public KameletV1Alpha1 build() {
            Kamelet k = this.delegate.build();
            KameletV1Alpha1 kamelet = new KameletV1Alpha1();
            kamelet.setMetadata(k.getMetadata());
            kamelet.setSpec((KameletSpec)k.getSpec());
            kamelet.setStatus((KameletStatus)k.getStatus());
            return kamelet;
        }
    }
}

