/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.actions.CreateVariablesAction;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.Assert;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ActionTimeoutException;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.yaks.camelk.CamelKSettings;
import org.citrusframework.yaks.camelk.VariableNames;
import org.citrusframework.yaks.camelk.actions.CamelKActionBuilder;
import org.citrusframework.yaks.camelk.actions.integration.CreateIntegrationAction;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.citrusframework.yaks.util.ResourceUtils;

public class CamelKSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusResource
    private TestContext context;
    @CitrusFramework
    private Citrus citrus;
    private KubernetesClient k8sClient;
    private boolean autoRemoveResources = CamelKSettings.isAutoRemoveResources();
    private int maxAttempts = CamelKSettings.getMaxAttempts();
    private long delayBetweenAttempts = CamelKSettings.getDelayBetweenAttempts();
    private List<String> propertyFiles;
    private Map<String, String> properties;
    private List<String> buildPropertyFiles;
    private Map<String, String> buildProperties;
    private List<String> envVarFiles;
    private Map<String, String> envVars;
    private boolean supportVariablesInSources = CamelKSettings.isSupportVariablesInSources();
    private boolean stopOnErrorStatus = CamelKSettings.isStopOnErrorStatus();

    @Before
    public void before(Scenario scenario) {
        if (this.k8sClient == null) {
            this.k8sClient = KubernetesSupport.getKubernetesClient((Citrus)this.citrus);
        }
        this.propertyFiles = new ArrayList<String>();
        this.properties = new LinkedHashMap<String, String>();
        this.buildPropertyFiles = new ArrayList<String>();
        this.buildProperties = new LinkedHashMap<String, String>();
        this.envVarFiles = new ArrayList<String>();
        this.envVars = new LinkedHashMap<String, String>();
        if (!this.context.getVariables().containsKey(VariableNames.OPERATOR_NAMESPACE.value())) {
            this.context.setVariable(VariableNames.OPERATOR_NAMESPACE.value(), (Object)CamelKSettings.getOperatorNamespace());
        }
    }

    @Given(value="^Disable auto removal of Camel K resources$")
    public void disableAutoRemove() {
        this.autoRemoveResources = false;
    }

    @Given(value="^Enable auto removal of Camel K resources$")
    public void enableAutoRemove() {
        this.autoRemoveResources = true;
    }

    @Given(value="^Disable variable support in Camel K sources$")
    public void disableVariableSupport() {
        this.supportVariablesInSources = false;
    }

    @Given(value="^Enable variable support in Camel K sources$")
    public void enableVariableSupport() {
        this.supportVariablesInSources = true;
    }

    @Given(value="^Disable stop on error status$")
    public void disableStopOnErrorStatus() {
        this.stopOnErrorStatus = false;
    }

    @Given(value="^Enable stop on error status$")
    public void enableStopOnErrorStatus() {
        this.stopOnErrorStatus = true;
    }

    @Given(value="^Camel K resource polling configuration$")
    public void configureResourcePolling(Map<String, Object> configuration) {
        this.maxAttempts = Integer.parseInt(configuration.getOrDefault("maxAttempts", this.maxAttempts).toString());
        this.delayBetweenAttempts = Long.parseLong(configuration.getOrDefault("delayBetweenAttempts", this.delayBetweenAttempts).toString());
    }

    @Given(value="^Camel K namespace ([^\\s]+)$")
    public void setNamespace(String namespace) {
        this.runner.run((TestActionBuilder)CreateVariablesAction.Builder.createVariable((String)VariableNames.CAMELK_NAMESPACE.value(), (String)namespace));
    }

    @Given(value="^Camel K operator namespace ([^\\s]+)$")
    public void setOperatorNamespace(String namespace) {
        this.runner.run((TestActionBuilder)CreateVariablesAction.Builder.createVariable((String)VariableNames.OPERATOR_NAMESPACE.value(), (String)namespace));
    }

    @Given(value="^Camel K integration property file ([^\\s]+)$")
    public void addPropertyFile(String filePath) {
        this.propertyFiles.add(filePath);
    }

    @Given.Givens(value={@Given(value="^Camel K integration property ([^\\s]+)=\"([^\"]*)\"$"), @Given(value="^Camel K integration property ([^\\s]+) (?:is|=) \"([^\"]*)\"$")})
    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @Given(value="^Camel K integration properties$")
    public void addProperties(DataTable propertyTable) {
        this.properties.putAll(propertyTable.asMap(String.class, String.class));
    }

    @Given(value="^Camel K integration build property file ([^\\s]+)$")
    public void addBuildPropertyFile(String filePath) {
        this.buildPropertyFiles.add(filePath);
    }

    @Given.Givens(value={@Given(value="^Camel K integration build property ([^\\s]+)=\"([^\"]*)\"$"), @Given(value="^Camel K integration build property ([^\\s]+) (?:is|=) \"([^\"]*)\"$")})
    public void addBuildProperty(String name, String value) {
        this.buildProperties.put(name, value);
    }

    @Given(value="^Camel K integration build properties$")
    public void addBuildProperties(DataTable propertyTable) {
        this.buildProperties.putAll(propertyTable.asMap(String.class, String.class));
    }

    @Given(value="^Camel K integration environment variable file ([^\\s]+)$")
    public void addEnVarFile(String filePath) {
        this.envVarFiles.add(filePath);
    }

    @Given.Givens(value={@Given(value="^Camel K integration environment variable ([^\\s]+)=\"([^\"]*)\"$"), @Given(value="^Camel K integration environment variable ([^\\s]+) (?:is|=) \"([^\"]*)\"$")})
    public void addEnVar(String name, String value) {
        this.envVars.put(name, value);
    }

    @Given(value="^Camel K integration environment variables$")
    public void addEnvVars(DataTable propertyTable) {
        this.envVars.putAll(propertyTable.asMap(String.class, String.class));
    }

    @Given(value="^(?:create|new) Camel K integration ([a-z0-9][a-z0-9-\\.]+[a-z0-9])\\.([a-z0-9-]+) with configuration:?$")
    public void createIntegration(String name, String language, Map<String, String> configuration) {
        if (configuration.get("source") == null) {
            throw new IllegalStateException("Specify 'source' parameter");
        }
        this.createIntegration(name, language, configuration.get("source"), configuration);
    }

    @Given(value="^load Camel K integration ([a-zA-Z0-9][a-zA-Z0-9-\\.]+[a-zA-Z0-9])\\.([a-z0-9-]+)$")
    public void loadIntegrationFromFile(String name, String language) {
        try {
            this.createIntegration(name, language, FileUtils.readToString((Resource)ResourceUtils.resolve((String)(name + "." + language), (TestContext)this.context)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to load Camel K integration from resource %s", name + "." + language), (Throwable)e);
        }
    }

    @Given(value="^load Camel K integration ([a-zA-Z0-9][a-zA-Z0-9-\\.]+[a-zA-Z0-9])\\.([a-z0-9-]+) with configuration:?$")
    public void loadIntegrationFromFile(String name, String language, Map<String, String> configuration) {
        try {
            this.createIntegration(name, language, FileUtils.readToString((Resource)ResourceUtils.resolve((String)(name + "." + language), (TestContext)this.context)), configuration);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to load Camel K integration from resource %s", name + "." + language), (Throwable)e);
        }
    }

    @Given(value="^(?:create|new) Camel K integration ([a-z0-9][a-z0-9-\\.]+[a-z0-9])\\.([a-z0-9-]+)$")
    public void createIntegration(String name, String language, String source) {
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).createIntegration(name).properties(this.properties).propertyFiles(this.propertyFiles).buildProperties(this.buildProperties).buildPropertyFiles(this.buildPropertyFiles).envVars(this.envVars).envVarFiles(this.envVarFiles).supportVariables(this.supportVariablesInSources).source(name + "." + language, source));
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deleteIntegration(name)}));
        }
    }

    @Given(value="^delete Camel K integration ([a-z0-9-]+)$")
    public void deleteIntegration(String name) {
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).deleteIntegration(name));
    }

    @Given.Givens(value={@Given(value="^wait for Camel K integration ([a-z0-9-]+)$"), @Given(value="^Camel K integration ([a-z0-9-]+) is running$")})
    @Then(value="^Camel K integration ([a-z0-9-]+) should be running$")
    public void integrationShouldBeRunning(String name) {
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).verifyIntegration(name).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts).isRunning());
    }

    @Given(value="^Camel K integration ([a-z0-9-]+) is stopped")
    @Then(value="^Camel K integration ([a-z0-9-]+) should be stopped")
    public void integrationShouldBeStopped(String name) {
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).verifyIntegration(name).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts).isStopped());
    }

    @Then(value="^Camel K integration ([a-z0-9-]+) should print (.*)$")
    public void integrationShouldPrint(String name, String message) {
        this.integrationShouldPrintMultiline(name, message);
    }

    @Then(value="^Camel K integration ([a-z0-9-]+) should print$")
    public void integrationShouldPrintMultiline(String name, String message) {
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).verifyIntegration(name).printLogs(CamelKSettings.isPrintPodLogs()).stopOnErrorStatus(this.stopOnErrorStatus).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts).waitForLogMessage(message));
    }

    @Then(value="^Camel K integration ([a-z0-9-]+) should not print (.*)$")
    public void integrationShouldNotPrint(String name, String message) {
        this.integrationShouldNotPrintMultiline(name, message);
    }

    @Then(value="^Camel K integration ([a-z0-9-]+) should not print$")
    public void integrationShouldNotPrintMultiline(String name, String message) {
        this.runner.run((TestActionBuilder)Assert.Builder.assertException().exception(ActionTimeoutException.class).when(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).verifyIntegration(name).printLogs(CamelKSettings.isPrintPodLogs()).stopOnErrorStatus(this.stopOnErrorStatus).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts).waitForLogMessage(message)}));
    }

    private void createIntegration(String name, String language, String source, Map<String, String> configuration) {
        CreateIntegrationAction.Builder create = CamelKActionBuilder.camelk().client(this.k8sClient).createIntegration(configuration.getOrDefault("name", name)).source(name + "." + language, source).dependencies(configuration.getOrDefault("dependencies", "").trim()).buildProperties(configuration.getOrDefault("build-properties", "").trim()).buildProperties(this.buildProperties).buildPropertyFiles(this.buildPropertyFiles).envVars(this.envVars).envVarFiles(this.envVarFiles).properties(configuration.getOrDefault("properties", "").trim()).properties(this.properties).propertyFiles(this.propertyFiles).supportVariables(Boolean.parseBoolean(configuration.getOrDefault("supportVariables", String.valueOf(this.supportVariablesInSources)))).traits(configuration.getOrDefault("traits", "").trim());
        String openApiSpec = configuration.getOrDefault("openapi", "");
        if (!openApiSpec.isEmpty()) {
            create.openApi(openApiSpec);
        }
        this.runner.run((TestActionBuilder)create);
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deleteIntegration(configuration.getOrDefault("name", name))}));
        }
    }
}

