/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk;

import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.v1alpha1.KameletBindingBuilder;
import org.apache.camel.v1alpha1.KameletBindingFluent;
import org.apache.camel.v1alpha1.kameletbindingspec.SinkBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.SourceBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.source.Ref;
import org.apache.camel.v1alpha1.kameletbindingspec.source.RefBuilder;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.spi.Resource;
import org.citrusframework.yaks.camelk.CamelKSettings;
import org.citrusframework.yaks.camelk.KameletSettings;
import org.citrusframework.yaks.camelk.VariableNames;
import org.citrusframework.yaks.camelk.actions.CamelKActionBuilder;
import org.citrusframework.yaks.kafka.KafkaSettings;
import org.citrusframework.yaks.knative.KnativeSettings;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.citrusframework.yaks.util.ResourceUtils;

public class KameletBindingSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestContext context;
    private KubernetesClient k8sClient;
    private SourceBuilder source;
    private SinkBuilder sink;
    private Map<String, Object> sourceProperties;
    private Map<String, Object> sinkProperties;

    @Before
    public void before(Scenario scenario) {
        if (this.k8sClient == null) {
            this.k8sClient = KubernetesSupport.getKubernetesClient((Citrus)this.citrus);
        }
        this.initializeKameletBindingBuilder();
    }

    @Given(value="^KameletBinding source properties$")
    public void setKameletBindingSourceProperties(Map<String, Object> properties) {
        this.sourceProperties.putAll(properties);
    }

    @Given(value="^KameletBinding sink properties$")
    public void setKameletBindingSinkProperties(Map<String, Object> properties) {
        this.sinkProperties.putAll(properties);
    }

    @Given(value="^KameletBinding event source Kamelet ([a-z0-9-]+)$")
    public void setKameletEventSource(String kameletName) {
        Ref kameletRef = ((RefBuilder)((RefBuilder)((RefBuilder)((RefBuilder)new RefBuilder().withName(kameletName)).withApiVersion("camel.apache.org/" + this.getKameletApiVersion())).withKind("Kamelet")).withNamespace(this.getNamespace())).build();
        this.source = (SourceBuilder)new SourceBuilder().withRef(kameletRef);
    }

    @Given(value="^KameletBinding event sink uri ([^\\s]+)$")
    public void setEventSinkUri(String uri) {
        this.sink = (SinkBuilder)new SinkBuilder().withUri(uri);
    }

    @Given(value="^KameletBinding event sink Kafka topic ([^\\s]+)$")
    public void setEventSinkKafkaTopic(String topic) {
        org.apache.camel.v1alpha1.kameletbindingspec.sink.Ref sinkRef = ((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)new org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder().withName(topic)).withApiVersion("kafka.strimzi.io/" + KafkaSettings.getApiVersion())).withKind("KafkaTopic")).withNamespace(KafkaSettings.getNamespace())).build();
        this.sink = (SinkBuilder)new SinkBuilder().withRef(sinkRef);
    }

    @Given(value="^KameletBinding event sink Knative channel ([^\\s]+)$")
    public void setEventSinkKnativeChannel(String channel) {
        this.setEventSinkKnativeChannel(channel, "InMemoryChannel");
    }

    @Given(value="^KameletBinding event sink Knative channel ([^\\s]+) of kind ([^\\s]+)$")
    public void setEventSinkKnativeChannel(String channel, String channelKind) {
        org.apache.camel.v1alpha1.kameletbindingspec.sink.Ref sinkRef = ((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)new org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder().withName(channel)).withApiVersion("messaging.knative.dev/" + KnativeSettings.getApiVersion())).withKind(channelKind)).withNamespace(KnativeSettings.getNamespace())).build();
        this.sink = (SinkBuilder)new SinkBuilder().withRef(sinkRef);
    }

    @Given(value="^KameletBinding event sink Knative broker ([^\\s]+)$")
    public void setEventSinkKnativeBroker(String broker) {
        org.apache.camel.v1alpha1.kameletbindingspec.sink.Ref sinkRef = ((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)((org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder)new org.apache.camel.v1alpha1.kameletbindingspec.sink.RefBuilder().withName(broker)).withApiVersion("eventing.knative.dev/" + KnativeSettings.getApiVersion())).withKind("Broker")).withNamespace(KnativeSettings.getNamespace())).build();
        this.sink = (SinkBuilder)new SinkBuilder().withRef(sinkRef);
    }

    @Given(value="^load KameletBinding ([a-z0-9-]+).yaml$")
    public void loadKameletBindingFromFile(String fileName) {
        Resource resource = ResourceUtils.resolve((String)(fileName + ".yaml"), (TestContext)this.context);
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).createKameletBinding(fileName).resource(resource));
        if (this.isAutoRemoveResources()) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deleteKameletBinding(fileName)}));
        }
    }

    @Given(value="^(?:create|new) KameletBinding ([a-z0-9-]+)$")
    public void createNewKameletBinding(String name) {
        KameletBindingBuilder builder = new KameletBindingBuilder();
        ((KameletBindingFluent.MetadataNested)builder.withNewMetadata().withName(name)).endMetadata();
        this.source.editOrNewProperties().addToAdditionalProperties(this.sourceProperties);
        this.sink.editOrNewProperties().addToAdditionalProperties(this.sinkProperties);
        ((KameletBindingFluent.SpecNested)((KameletBindingFluent.SpecNested)builder.withNewSpec().withSource(this.source.build())).withSink(this.sink.build())).endSpec();
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).createKameletBinding(name).fromBuilder(builder));
        this.initializeKameletBindingBuilder();
        if (this.isAutoRemoveResources()) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deleteKameletBinding(name)}));
        }
    }

    @Given(value="^delete KameletBinding ([a-z0-9-]+)$")
    public void deleteKameletBinding(String name) {
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).deleteKameletBinding(name));
    }

    @Given(value="^KameletBinding ([a-z0-9-]+) is available$")
    @Then(value="^KameletBinding ([a-z0-9-]+) should be available$")
    public void bindingShouldBeAvailable(String name) {
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).verifyKameletBinding(name).isAvailable());
    }

    private void initializeKameletBindingBuilder() {
        this.source = null;
        this.sink = null;
        this.sourceProperties = new HashMap<String, Object>();
        this.sinkProperties = new HashMap<String, Object>();
    }

    private String getKameletApiVersion() {
        if (this.context.getVariables().containsKey(VariableNames.KAMELET_API_VERSION.value())) {
            return this.context.getVariable(VariableNames.KAMELET_API_VERSION.value());
        }
        return KameletSettings.getKameletApiVersion();
    }

    private String getNamespace() {
        if (this.context.getVariables().containsKey(VariableNames.KAMELET_NAMESPACE.value())) {
            return this.context.getVariable(VariableNames.KAMELET_NAMESPACE.value());
        }
        return KameletSettings.getNamespace();
    }

    private boolean isAutoRemoveResources() {
        if (this.context.getVariables().containsKey(VariableNames.AUTO_REMOVE_RESOURCES.value())) {
            return (Boolean)this.context.getVariable(VariableNames.AUTO_REMOVE_RESOURCES.value(), Boolean.class);
        }
        return CamelKSettings.isAutoRemoveResources();
    }
}

