/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk;

import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.fabric8.kubernetes.api.model.AnyTypeBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.v1.KameletBuilder;
import org.apache.camel.v1.KameletFluent;
import org.apache.camel.v1.KameletSpecBuilder;
import org.apache.camel.v1.kameletspec.DataTypes;
import org.apache.camel.v1.kameletspec.DefinitionBuilder;
import org.apache.camel.v1.kameletspec.Sources;
import org.apache.camel.v1.kameletspec.SourcesBuilder;
import org.apache.camel.v1.kameletspec.datatypes.TypesBuilder;
import org.apache.camel.v1.kameletspec.definition.Properties;
import org.apache.camel.v1.kameletspec.definition.PropertiesBuilder;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.actions.CreateVariablesAction;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.yaks.camelk.CamelKSettings;
import org.citrusframework.yaks.camelk.KameletSettings;
import org.citrusframework.yaks.camelk.VariableNames;
import org.citrusframework.yaks.camelk.actions.CamelKActionBuilder;
import org.citrusframework.yaks.camelk.actions.kamelet.CreateKameletAction;
import org.citrusframework.yaks.camelk.actions.kamelet.VerifyKameletAction;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.citrusframework.yaks.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class KameletSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestContext context;
    private KubernetesClient k8sClient;
    private String kameletApiVersion = KameletSettings.getKameletApiVersion();
    private KameletBuilder kamelet;
    private KameletSpecBuilder kameletSpecBuilder;
    private Map<String, DataTypes> dataTypes;
    private DefinitionBuilder definition;
    private String kameletTemplate;
    private String namespace = KameletSettings.getNamespace();
    private boolean autoRemoveResources = CamelKSettings.isAutoRemoveResources();
    private boolean supportVariablesInSources = CamelKSettings.isSupportVariablesInSources();

    @Before
    public void before(Scenario scenario) {
        if (this.k8sClient == null) {
            this.k8sClient = KubernetesSupport.getKubernetesClient((Citrus)this.citrus);
        }
        this.initializeKameletBuilder();
    }

    @Given(value="^Disable auto removal of Kamelet resources$")
    public void disableAutoRemove() {
        this.autoRemoveResources = false;
        this.runner.run((TestActionBuilder)CreateVariablesAction.Builder.createVariable((String)VariableNames.AUTO_REMOVE_RESOURCES.value(), (String)"false"));
    }

    @Given(value="^Enable auto removal of Kamelet resources$")
    public void enableAutoRemove() {
        this.autoRemoveResources = true;
        this.runner.run((TestActionBuilder)CreateVariablesAction.Builder.createVariable((String)VariableNames.AUTO_REMOVE_RESOURCES.value(), (String)"true"));
    }

    @Given(value="^Disable variable support in Kamelet sources$")
    public void disableVariableSupport() {
        this.supportVariablesInSources = false;
    }

    @Given(value="^Enable variable support in Kamelet sources$")
    public void enableVariableSupport() {
        this.supportVariablesInSources = true;
    }

    @Given(value="^Kamelet API version (v1|v1alpha1)$")
    public void setKameletApiVersion(String apiVersion) {
        this.kameletApiVersion = apiVersion;
        this.runner.run((TestActionBuilder)CreateVariablesAction.Builder.createVariable((String)VariableNames.KAMELET_API_VERSION.value(), (String)apiVersion));
    }

    @Given(value="^Kamelet namespace ([^\\s]+)$")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
        this.runner.run((TestActionBuilder)CreateVariablesAction.Builder.createVariable((String)VariableNames.KAMELET_NAMESPACE.value(), (String)namespace));
    }

    @Given(value="^Kamelet dataType (in|out|error)(?:=| is )\"(.+)\"$")
    public void addType(String slot, String format) {
        DataTypes dt;
        if (this.dataTypes.containsKey(slot)) {
            dt = this.dataTypes.get(slot);
        } else {
            dt = new DataTypes();
            this.dataTypes.put(slot, dt);
        }
        if (dt.getTypes() == null) {
            dt.setTypes(new HashMap());
        }
        if (format.contains(":")) {
            String[] schemeAndFormat = format.split(":");
            dt.getTypes().put(schemeAndFormat[1], ((TypesBuilder)((TypesBuilder)new TypesBuilder().withScheme(schemeAndFormat[0])).withFormat(schemeAndFormat[1])).build());
        } else {
            dt.getTypes().put(format, ((TypesBuilder)((TypesBuilder)new TypesBuilder().withScheme("camel")).withFormat(format)).build());
        }
    }

    @Given(value="^Kamelet title \"(.+)\"$")
    public void setTitle(String title) {
        this.definition.withTitle(title);
    }

    @Given(value="^Kamelet source ([a-z0-9-]+).([a-z0-9-]+)$")
    public void setSource(String name, String language, String content) {
        this.kameletSpecBuilder.withSources(new Sources[]{((SourcesBuilder)((SourcesBuilder)((SourcesBuilder)new SourcesBuilder().withName(name)).withLanguage(language)).withContent(content)).build()});
    }

    @Given(value="^Kamelet template")
    public void setFlow(String template) {
        this.kameletTemplate = template;
    }

    @Given(value="^Kamelet property definition$")
    public void addPropertyDefinition(Map<String, Object> propertyConfiguration) {
        if (!propertyConfiguration.containsKey("name")) {
            throw new CitrusRuntimeException("Missing property name in configuration. Please add the property name to the property definition");
        }
        this.addPropertyDefinition(propertyConfiguration.get("name").toString(), propertyConfiguration);
    }

    @Given(value="^Kamelet property definition ([^\\s]+)$")
    public void addPropertyDefinition(String propertyName, Map<String, Object> propertyConfiguration) {
        String type = propertyConfiguration.getOrDefault("type", "string").toString();
        String title = propertyConfiguration.getOrDefault("title", StringUtils.capitalize((String)propertyName)).toString();
        Object defaultValue = propertyConfiguration.get("default");
        Object example = propertyConfiguration.get("example");
        String required = propertyConfiguration.getOrDefault("required", Boolean.FALSE).toString();
        if (Boolean.parseBoolean(required)) {
            this.definition.addToRequired(new String[]{propertyName});
        }
        Properties property = ((PropertiesBuilder)((PropertiesBuilder)new PropertiesBuilder().withTitle(title)).withType(type)).build();
        if (example != null) {
            property.setExample(((AnyTypeBuilder)new AnyTypeBuilder().withValue(example)).build());
        }
        if (defaultValue != null) {
            property.set_default(((AnyTypeBuilder)new AnyTypeBuilder().withValue(defaultValue)).build());
        }
        this.definition.addToProperties(propertyName, property);
    }

    @Given(value="^load Kamelet ([a-z0-9-]+).kamelet.yaml$")
    public void loadKameletFromFile(String fileName) {
        Resource resource = ResourceUtils.resolve((String)(fileName + ".kamelet.yaml"), (TestContext)this.context);
        this.runner.run((TestActionBuilder)((CreateKameletAction.Builder)((Object)((CreateKameletAction.Builder)((Object)CamelKActionBuilder.camelk().client(this.k8sClient).createKamelet(fileName).namespace(this.namespace))).apiVersion(this.kameletApiVersion))).supportVariables(this.supportVariablesInSources).resource(resource));
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deleteKamelet(fileName).apiVersion(this.kameletApiVersion)}));
        }
    }

    @Given(value="^(?:create|new) Kamelet ([a-z0-9-]+)$")
    public void createNewKamelet(String name) {
        ((KameletFluent.MetadataNested)this.kamelet.withNewMetadata().withName(name)).endMetadata();
        if (this.definition.getTitle() == null || this.definition.getTitle().isEmpty()) {
            this.definition.withTitle(StringUtils.capitalize((String)name));
        }
        this.kameletSpecBuilder.withDefinition(this.definition.build());
        this.kameletSpecBuilder.withDataTypes(this.dataTypes);
        this.kamelet.withSpec(this.kameletSpecBuilder.build());
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).createKamelet(name).supportVariables(this.supportVariablesInSources).template(this.kameletTemplate).fromBuilder(this.kamelet));
        this.initializeKameletBuilder();
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deleteKamelet(name).apiVersion(this.kameletApiVersion)}));
        }
    }

    @Deprecated
    @Given(value="^(?:create|new) Kamelet ([a-z0-9-]+) with flow")
    public void createNewKameletWithFlow(String name, String flow) {
        this.createNewKameletWithTemplate(name, flow);
    }

    @Given(value="^(?:create|new) Kamelet ([a-z0-9-]+) with template")
    public void createNewKameletWithTemplate(String name, String template) {
        this.kameletTemplate = template;
        this.createNewKamelet(name);
    }

    @Given(value="^delete Kamelet ([a-z0-9-]+)$")
    public void deleteKamelet(String name) {
        this.runner.run(CamelKActionBuilder.camelk().client(this.k8sClient).deleteKamelet(name).apiVersion(this.kameletApiVersion));
    }

    @Given(value="^Kamelet ([a-z0-9-]+) is available$")
    @Then(value="^Kamelet ([a-z0-9-]+) should be available$")
    public void kameletShouldBeAvailable(String name) {
        this.runner.run((TestActionBuilder)((VerifyKameletAction.Builder)((Object)CamelKActionBuilder.camelk().client(this.k8sClient).verifyKamelet(name).apiVersion(this.kameletApiVersion))).isAvailable());
    }

    @Given(value="^Kamelet ([a-z0-9-]+) is available in namespace ([a-z0-9-]+)$")
    @Then(value="^Kamelet ([a-z0-9-]+) should be available in namespace ([a-z0-9-]+)$")
    public void kameletShouldBeAvailable(String name, String namespace) {
        this.runner.run((TestActionBuilder)((VerifyKameletAction.Builder)((Object)((VerifyKameletAction.Builder)((Object)CamelKActionBuilder.camelk().client(this.k8sClient).verifyKamelet(name).apiVersion(this.kameletApiVersion))).namespace(namespace))).isAvailable());
    }

    private void initializeKameletBuilder() {
        this.kamelet = new KameletBuilder();
        this.definition = new DefinitionBuilder();
        this.kameletSpecBuilder = new KameletSpecBuilder();
        this.dataTypes = new HashMap<String, DataTypes>();
        this.kameletTemplate = null;
    }
}

