/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk;

import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.v1.PipeBuilder;
import org.apache.camel.v1.PipeFluent;
import org.apache.camel.v1.pipespec.SinkBuilder;
import org.apache.camel.v1.pipespec.SourceBuilder;
import org.apache.camel.v1.pipespec.sink.Ref;
import org.apache.camel.v1.pipespec.source.RefBuilder;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.spi.Resource;
import org.citrusframework.yaks.camelk.CamelKSettings;
import org.citrusframework.yaks.camelk.KameletSettings;
import org.citrusframework.yaks.camelk.VariableNames;
import org.citrusframework.yaks.camelk.actions.CamelKActionBuilder;
import org.citrusframework.yaks.kafka.KafkaSettings;
import org.citrusframework.yaks.knative.KnativeSettings;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.citrusframework.yaks.util.ResourceUtils;

public class PipeSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestContext context;
    private KubernetesClient k8sClient;
    private SourceBuilder source;
    private SinkBuilder sink;
    private Map<String, Object> sourceProperties;
    private Map<String, Object> sinkProperties;

    @Before
    public void before(Scenario scenario) {
        if (this.k8sClient == null) {
            this.k8sClient = KubernetesSupport.getKubernetesClient((Citrus)this.citrus);
        }
        this.initializePipeBuilder();
    }

    @Given(value="^Pipe source properties$")
    public void setPipeSourceProperties(Map<String, Object> properties) {
        this.sourceProperties.putAll(properties);
    }

    @Given(value="^Pipe sink properties$")
    public void setPipeSinkProperties(Map<String, Object> properties) {
        this.sinkProperties.putAll(properties);
    }

    @Given(value="^Pipe event source Kamelet ([a-z0-9-]+)$")
    public void setKameletEventSource(String kameletName) {
        org.apache.camel.v1.pipespec.source.Ref kameletRef = ((RefBuilder)((RefBuilder)((RefBuilder)((RefBuilder)new RefBuilder().withName(kameletName)).withApiVersion("camel.apache.org/" + this.getKameletApiVersion())).withKind("Kamelet")).withNamespace(this.getNamespace())).build();
        this.source = (SourceBuilder)new SourceBuilder().withRef(kameletRef);
    }

    @Given(value="^Pipe event sink uri ([^\\s]+)$")
    public void setEventSinkUri(String uri) {
        this.sink = (SinkBuilder)new SinkBuilder().withUri(uri);
    }

    @Given(value="^Pipe event sink Kafka topic ([^\\s]+)$")
    public void setEventSinkKafkaTopic(String topic) {
        Ref sinkRef = ((org.apache.camel.v1.pipespec.sink.RefBuilder)((org.apache.camel.v1.pipespec.sink.RefBuilder)((org.apache.camel.v1.pipespec.sink.RefBuilder)((org.apache.camel.v1.pipespec.sink.RefBuilder)new org.apache.camel.v1.pipespec.sink.RefBuilder().withName(topic)).withApiVersion("kafka.strimzi.io/" + KafkaSettings.getApiVersion())).withKind("KafkaTopic")).withNamespace(KafkaSettings.getNamespace())).build();
        this.sink = (SinkBuilder)new SinkBuilder().withRef(sinkRef);
    }

    @Given(value="^Pipe event sink Knative channel ([^\\s]+)$")
    public void setEventSinkKnativeChannel(String channel) {
        this.setEventSinkKnativeChannel(channel, "InMemoryChannel");
    }

    @Given(value="^Pipe event sink Knative channel ([^\\s]+) of kind ([^\\s]+)$")
    public void setEventSinkKnativeChannel(String channel, String channelKind) {
        Ref sinkRef = ((org.apache.camel.v1.pipespec.sink.RefBuilder)((org.apache.camel.v1.pipespec.sink.RefBuilder)((org.apache.camel.v1.pipespec.sink.RefBuilder)((org.apache.camel.v1.pipespec.sink.RefBuilder)new org.apache.camel.v1.pipespec.sink.RefBuilder().withName(channel)).withApiVersion("messaging.knative.dev/" + KnativeSettings.getApiVersion())).withKind(channelKind)).withNamespace(KnativeSettings.getNamespace())).build();
        this.sink = (SinkBuilder)new SinkBuilder().withRef(sinkRef);
    }

    @Given(value="^Pipe event sink Knative broker ([^\\s]+)$")
    public void setEventSinkKnativeBroker(String broker) {
        Ref sinkRef = ((org.apache.camel.v1.pipespec.sink.RefBuilder)((org.apache.camel.v1.pipespec.sink.RefBuilder)((org.apache.camel.v1.pipespec.sink.RefBuilder)((org.apache.camel.v1.pipespec.sink.RefBuilder)new org.apache.camel.v1.pipespec.sink.RefBuilder().withName(broker)).withApiVersion("eventing.knative.dev/" + KnativeSettings.getApiVersion())).withKind("Broker")).withNamespace(KnativeSettings.getNamespace())).build();
        this.sink = (SinkBuilder)new SinkBuilder().withRef(sinkRef);
    }

    @Given(value="^bind Kamelet ([a-z0-9-]+) to uri ([^\\s]+)$")
    public void bindKameletToUri(String kameletName, String uri) {
        this.setKameletEventSource(kameletName);
        this.setEventSinkUri(uri);
    }

    @Given(value="^bind Kamelet ([a-z0-9-]+) to Kafka topic ([^\\s]+)$")
    public void bindKameletToKafka(String kameletName, String topic) {
        this.setKameletEventSource(kameletName);
        this.setEventSinkKafkaTopic(topic);
    }

    @Given(value="^bind Kamelet ([a-z0-9-]+) to Knative channel ([^\\s]+)$")
    public void bindKameletToKnativeChannel(String kameletName, String channel) {
        this.bindKameletToKnativeChannel(kameletName, channel, "InMemoryChannel");
    }

    @Given(value="^bind Kamelet ([a-z0-9-]+) to Knative channel ([^\\s]+) of kind ([^\\s]+)$")
    public void bindKameletToKnativeChannel(String kameletName, String channel, String channelKind) {
        this.setKameletEventSource(kameletName);
        this.setEventSinkKnativeChannel(channel, channelKind);
    }

    @Given(value="^bind Kamelet ([a-z0-9-]+) to Knative broker ([^\\s]+)$")
    public void bindKameletToKnativeBroker(String kameletName, String broker) {
        this.setKameletEventSource(kameletName);
        this.setEventSinkKnativeBroker(broker);
    }

    @Given(value="^load Pipe ([a-z0-9-]+).yaml$")
    public void loadPipeFromFile(String fileName) {
        Resource resource = ResourceUtils.resolve((String)(fileName + ".yaml"), (TestContext)this.context);
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).createPipe(fileName).resource(resource));
        if (this.isAutoRemoveResources()) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deletePipe(fileName)}));
        }
    }

    @Given(value="^(?:create|new) Pipe ([a-z0-9-]+)$")
    public void createNewPipe(String name) {
        PipeBuilder pipe = new PipeBuilder();
        ((PipeFluent.MetadataNested)pipe.withNewMetadata().withName(name)).endMetadata();
        this.source.editOrNewProperties().addToAdditionalProperties(this.sourceProperties);
        this.sink.editOrNewProperties().addToAdditionalProperties(this.sinkProperties);
        ((PipeFluent.SpecNested)((PipeFluent.SpecNested)pipe.withNewSpec().withSource(this.source.build())).withSink(this.sink.build())).endSpec();
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).createPipe(name).fromBuilder(pipe));
        this.initializePipeBuilder();
        if (this.isAutoRemoveResources()) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deletePipe(name)}));
        }
    }

    @Given(value="^delete Pipe ([a-z0-9-]+)$")
    public void deletePipe(String name) {
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).deletePipe(name));
    }

    @Given(value="^Pipe ([a-z0-9-]+) is available$")
    @Then(value="^Pipe ([a-z0-9-]+) should be available$")
    public void pipeShouldBeAvailable(String name) {
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).verifyPipe(name).isAvailable());
    }

    private void initializePipeBuilder() {
        this.source = null;
        this.sink = null;
        this.sourceProperties = new HashMap<String, Object>();
        this.sinkProperties = new HashMap<String, Object>();
    }

    private String getKameletApiVersion() {
        if (this.context.getVariables().containsKey(VariableNames.KAMELET_API_VERSION.value())) {
            return this.context.getVariable(VariableNames.KAMELET_API_VERSION.value());
        }
        return KameletSettings.getKameletApiVersion();
    }

    private String getNamespace() {
        if (this.context.getVariables().containsKey(VariableNames.KAMELET_NAMESPACE.value())) {
            return this.context.getVariable(VariableNames.KAMELET_NAMESPACE.value());
        }
        return KameletSettings.getNamespace();
    }

    private boolean isAutoRemoveResources() {
        if (this.context.getVariables().containsKey(VariableNames.AUTO_REMOVE_RESOURCES.value())) {
            return (Boolean)this.context.getVariable(VariableNames.AUTO_REMOVE_RESOURCES.value(), Boolean.class);
        }
        return CamelKSettings.isAutoRemoveResources();
    }
}

