/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.TestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.CamelKSettings;
import org.citrusframework.yaks.camelk.VariableNames;
import org.citrusframework.yaks.kubernetes.KubernetesSettings;

public interface CamelKAction
extends TestAction {
    public KubernetesClient getKubernetesClient();

    default public String namespace(TestContext context) {
        if (context.getVariables().containsKey(VariableNames.CAMELK_NAMESPACE.value())) {
            return context.getVariable(VariableNames.CAMELK_NAMESPACE.value());
        }
        return KubernetesSettings.getNamespace();
    }

    default public String operatorNamespace(TestContext context) {
        if (context.getVariables().containsKey(VariableNames.OPERATOR_NAMESPACE.value())) {
            return context.getVariable(VariableNames.OPERATOR_NAMESPACE.value());
        }
        return CamelKSettings.getOperatorNamespace();
    }

    default public YaksClusterType clusterType(TestContext context) {
        if (context.getVariables().containsKey(VariableNames.CLUSTER_TYPE.value())) {
            Object clusterType = context.getVariableObject(VariableNames.CLUSTER_TYPE.value());
            if (clusterType instanceof YaksClusterType) {
                return (YaksClusterType)clusterType;
            }
            return YaksClusterType.valueOf((String)clusterType.toString());
        }
        return YaksSettings.getClusterType();
    }
}

