/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.integration;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.v1.Integration;
import org.apache.camel.v1.IntegrationBuilder;
import org.apache.camel.v1.IntegrationFluent;
import org.apache.camel.v1.IntegrationSpec;
import org.apache.camel.v1.IntegrationSpecBuilder;
import org.apache.camel.v1.integrationspec.Sources;
import org.apache.camel.v1.integrationspec.SourcesBuilder;
import org.apache.camel.v1.integrationspec.Traits;
import org.apache.camel.v1.integrationspec.traits.AddonsBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.actions.AbstractCamelKAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.jbang.CamelJBangSettings;
import org.citrusframework.yaks.camelk.jbang.ProcessAndOutput;
import org.citrusframework.yaks.camelk.model.IntegrationList;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.citrusframework.yaks.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIntegrationAction
extends AbstractCamelKAction {
    private static final Logger LOG = LoggerFactory.getLogger(CreateIntegrationAction.class);
    private final String integrationName;
    private final String fileName;
    private final String source;
    private final List<String> dependencies;
    private final List<String> buildProperties;
    private final List<String> buildPropertyFiles;
    private final List<String> envVars;
    private final List<String> envVarFiles;
    private final List<String> properties;
    private final List<String> propertyFiles;
    private final List<String> traits;
    private final List<String> openApis;
    private final List<String> resources;
    private final List<String> volumes;
    private final List<String> configs;
    private final List<String> connects;
    private final boolean supportVariables;

    public CreateIntegrationAction(Builder builder) {
        super("create-integration", builder);
        this.integrationName = builder.integrationName;
        this.fileName = builder.fileName;
        this.source = builder.source;
        this.dependencies = builder.dependencies;
        this.buildProperties = builder.buildProperties;
        this.buildPropertyFiles = builder.buildPropertyFiles;
        this.envVars = builder.envVars;
        this.envVarFiles = builder.envVarFiles;
        this.properties = builder.properties;
        this.propertyFiles = builder.propertyFiles;
        this.traits = builder.traits;
        this.openApis = builder.openApis;
        this.resources = builder.resources;
        this.volumes = builder.volumes;
        this.configs = builder.configs;
        this.connects = builder.connects;
        this.supportVariables = builder.supportVariables;
    }

    public void doExecute(TestContext context) {
        String name = this.sanitizeIntegrationName(context.replaceDynamicContentInString(this.integrationName));
        LOG.info(String.format("Creating Camel K integration '%s'", name));
        String resolvedSource = this.supportVariables ? context.replaceDynamicContentInString(this.source) : this.source;
        IntegrationBuilder integrationBuilder = (IntegrationBuilder)((IntegrationFluent.MetadataNested)new IntegrationBuilder().withNewMetadata().withName(name)).endMetadata();
        IntegrationSpecBuilder specBuilder = new IntegrationSpecBuilder();
        specBuilder.addToSources(new Sources[]{((SourcesBuilder)((SourcesBuilder)new SourcesBuilder().withName(context.replaceDynamicContentInString(this.fileName))).withContent(resolvedSource)).build()});
        List<String> resolvedDependencies = CreateIntegrationAction.resolveDependencies(resolvedSource, context.resolveDynamicValuesInList(this.dependencies));
        if (!resolvedDependencies.isEmpty()) {
            specBuilder.addAllToDependencies(resolvedDependencies);
        }
        HashMap<String, Map<String, Object>> traitConfigMap = new HashMap<String, Map<String, Object>>();
        this.addPropertyConfigurationSpec(traitConfigMap, resolvedSource, context);
        this.addRuntimeConfigurationSpec(traitConfigMap, resolvedSource, context);
        this.addResourcesSpec(traitConfigMap, resolvedSource, context);
        this.addVolumesSpec(traitConfigMap, resolvedSource, context);
        this.addConnectsSpec(traitConfigMap, resolvedSource, context);
        this.addBuildPropertyConfigurationSpec(traitConfigMap, resolvedSource, context);
        this.addEnvVarConfigurationSpec(traitConfigMap, resolvedSource, context);
        this.addOpenApiSpec(traitConfigMap, resolvedSource, context);
        this.addTraitSpec(traitConfigMap, resolvedSource, context);
        Traits traitModel = (Traits)KubernetesSupport.json().convertValue(traitConfigMap, Traits.class);
        Set knownTraits = ((Map)KubernetesSupport.json().convertValue((Object)traitModel, Map.class)).keySet();
        if (knownTraits.size() < traitConfigMap.size()) {
            traitModel.setAddons(new HashMap());
            for (Map.Entry traitConfig : traitConfigMap.entrySet()) {
                if (knownTraits.contains(traitConfig.getKey())) continue;
                traitModel.getAddons().put((String)traitConfig.getKey(), ((AddonsBuilder)new AddonsBuilder().addToAdditionalProperties((Map)traitConfig.getValue())).build());
            }
        }
        specBuilder.withTraits(traitModel);
        Integration integration = ((IntegrationBuilder)integrationBuilder.withSpec(specBuilder.build())).build();
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            CreateIntegrationAction.createLocalIntegration(integration, integration.getMetadata().getName(), context);
        } else {
            CreateIntegrationAction.createIntegration(this.getKubernetesClient(), this.namespace(context), integration);
        }
        LOG.info(String.format("Successfully created Camel K integration '%s'", integration.getMetadata().getName()));
    }

    private void addResourcesSpec(Map<String, Map<String, Object>> traitConfigMap, String source, TestContext context) {
        String traitName = "mount.resources";
        Pattern pattern = CreateIntegrationAction.getModelinePattern("resource");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            String resource = matcher.group(1);
            this.addTraitSpec("%s=%s".formatted(traitName, context.replaceDynamicContentInString(resource)), traitConfigMap, true);
        }
        for (String resource : this.resources) {
            this.addTraitSpec("%s=%s".formatted(traitName, context.replaceDynamicContentInString(resource)), traitConfigMap, true);
        }
    }

    private void addVolumesSpec(Map<String, Map<String, Object>> traitConfigMap, String source, TestContext context) {
        String traitName = "mount.volumes";
        Pattern pattern = CreateIntegrationAction.getModelinePattern("volume");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            String volume = matcher.group(1);
            this.addTraitSpec("%s=%s".formatted(traitName, context.replaceDynamicContentInString(volume)), traitConfigMap, true);
        }
        for (String volume : this.volumes) {
            this.addTraitSpec("%s=%s".formatted(traitName, context.replaceDynamicContentInString(volume)), traitConfigMap, true);
        }
    }

    private void addConnectsSpec(Map<String, Map<String, Object>> traitConfigMap, String source, TestContext context) {
        String traitName = "service-binding.services";
        Pattern pattern = CreateIntegrationAction.getModelinePattern("connect");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            String connect = matcher.group(1);
            this.addTraitSpec("%s=%s".formatted(traitName, context.replaceDynamicContentInString(connect)), traitConfigMap, true);
        }
        for (String connect : this.connects) {
            this.addTraitSpec("%s=%s".formatted(traitName, context.replaceDynamicContentInString(connect)), traitConfigMap, true);
        }
    }

    private static void createIntegration(KubernetesClient k8sClient, String namespace, Integration integration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(KubernetesSupport.dumpYaml((Object)integration));
        }
        ((Resource)((NonNamespaceOperation)k8sClient.resources(Integration.class, IntegrationList.class).inNamespace(namespace)).resource((Object)integration)).createOr(Updatable::update);
    }

    private static void createLocalIntegration(Integration integration, String name, TestContext context) {
        try {
            Object integrationYaml = KubernetesSupport.dumpYaml((Object)integration);
            if (LOG.isDebugEnabled()) {
                LOG.debug((String)integrationYaml);
            }
            integrationYaml = (String)integrationYaml + "#KameletBinding";
            Path workDir = CamelJBangSettings.getWorkDir();
            Files.createDirectories(workDir, new FileAttribute[0]);
            Path file = workDir.resolve(String.format("i-%s.yaml", name));
            Files.writeString(file, (CharSequence)integrationYaml, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            ProcessAndOutput pao = CamelJBang.camel().run(name, file, CreateIntegrationAction.camelRunArgs(integration));
            if (!pao.getProcess().isAlive()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(pao.getOutput());
                }
                throw new CitrusRuntimeException(String.format("Failed to create Camel K integration - exit code %s", pao.getProcess().exitValue()));
            }
            Long pid = pao.getCamelProcessId();
            context.setVariable(name + ":pid", (Object)pid);
            context.setVariable(name + ":process:" + pid, (Object)pao);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create integration file", (Throwable)e);
        }
    }

    private static String[] camelRunArgs(Integration integration) {
        ArrayList<String> args = new ArrayList<String>();
        if (((IntegrationSpec)integration.getSpec()).getTraits().getOpenapi() != null) {
            for (String openApi : ((IntegrationSpec)integration.getSpec()).getTraits().getOpenapi().getConfigmaps()) {
                args.add("--open-api");
                if (openApi.startsWith("configmap:")) {
                    args.add(openApi.substring("configmap:".length()));
                    continue;
                }
                args.add(openApi);
            }
        }
        return (String[])args.toArray(String[]::new);
    }

    private void addOpenApiSpec(Map<String, Map<String, Object>> traitConfigMap, String source, TestContext context) {
        String traitName = "openapi.configmaps";
        Pattern pattern = CreateIntegrationAction.getModelinePattern("open-api");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            String openApiSpecFile = matcher.group(1);
            this.addTraitSpec("%s=%s".formatted(traitName, context.replaceDynamicContentInString(openApiSpecFile)), traitConfigMap, true);
        }
        for (String openApi : this.openApis) {
            this.addTraitSpec("%s=%s".formatted(traitName, context.replaceDynamicContentInString(openApi)), traitConfigMap, true);
        }
    }

    private void addTraitSpec(Map<String, Map<String, Object>> traitConfigMap, String source, TestContext context) {
        if (this.traits != null && !this.traits.isEmpty()) {
            for (String t : context.resolveDynamicValuesInList(this.traits)) {
                this.addTraitSpec(t, traitConfigMap, false);
            }
        }
        Pattern pattern = CreateIntegrationAction.getModelinePattern("trait");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            this.addTraitSpec(matcher.group(1), traitConfigMap, false);
        }
    }

    private void addTraitSpec(String traitExpression, Map<String, Map<String, Object>> traitConfigMap, boolean isListType) {
        String[] trait = traitExpression.split("\\.", 2);
        String[] traitConfig = trait[1].split("=", 2);
        String traitKey = traitConfig[0];
        Object traitValue = this.resolveTraitValue(traitKey, traitConfig[1].trim(), isListType);
        if (traitConfigMap.containsKey(trait[0])) {
            Map<String, Object> config = traitConfigMap.get(trait[0]);
            if (config.containsKey(traitKey)) {
                Object existingValue = config.get(traitKey);
                if (existingValue instanceof List) {
                    List values = (List)existingValue;
                    if (traitValue instanceof List) {
                        List traitValueList = (List)traitValue;
                        values.addAll(traitValueList);
                    } else {
                        values.add(traitValue.toString());
                    }
                } else if (traitValue instanceof List) {
                    List traitValueList = (List)traitValue;
                    traitValueList.add(0, existingValue.toString());
                    config.put(traitKey, traitValueList);
                } else {
                    config.put(traitKey, Arrays.asList(existingValue.toString(), traitValue));
                }
            } else {
                config.put(traitKey, traitValue);
            }
        } else {
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put(traitKey, traitValue);
            traitConfigMap.put(trait[0], config);
        }
    }

    private Object resolveTraitValue(String traitKey, String value, boolean isListType) {
        if (traitKey.equalsIgnoreCase("enabled") || traitKey.equalsIgnoreCase("verbose")) {
            return Boolean.valueOf(value);
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            String valueArrayExpression = value.substring(1, value.length() - 1);
            ArrayList<String> values = new ArrayList<String>();
            if (valueArrayExpression.contains(",")) {
                values.addAll(List.of(valueArrayExpression.split(",")));
            } else {
                values.add(valueArrayExpression);
            }
            return values;
        }
        if (value.contains(",")) {
            ArrayList<String> values = new ArrayList<String>();
            for (String entry : value.split(",")) {
                values.add(this.resolveTraitValue("", entry, false).toString());
            }
            return values;
        }
        String resolvedValue = value;
        if (value.startsWith("\"") && value.endsWith("\"")) {
            resolvedValue = value.substring(1, value.length() - 1);
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            resolvedValue = value.substring(1, value.length() - 1);
        }
        if (isListType) {
            return new ArrayList<String>(Collections.singletonList(resolvedValue));
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return resolvedValue;
        }
    }

    private void addPropertyConfigurationSpec(Map<String, Map<String, Object>> traitConfigMap, String source, TestContext context) {
        String traitName = "camel.properties";
        if (this.properties != null && !this.properties.isEmpty()) {
            for (String p : context.resolveDynamicValuesInList(this.properties)) {
                if (CreateIntegrationAction.isValidPropertyFormat(p)) {
                    String[] property = p.split("=", 2);
                    this.addTraitSpec(String.format("%s=%s", "camel.properties", this.createPropertySpec(property[0], property[1], context)), traitConfigMap, true);
                    continue;
                }
                throw new IllegalArgumentException("Property " + p + " does not match format key=value");
            }
        }
        if (this.propertyFiles != null && !this.propertyFiles.isEmpty()) {
            for (String pf : this.propertyFiles) {
                try {
                    Properties props = new Properties();
                    props.load(ResourceUtils.resolve((String)pf, (TestContext)context).getInputStream());
                    props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.addTraitSpec(String.format("%s=%s", "camel.properties", this.createPropertySpec(key.toString(), value.toString(), context)), traitConfigMap, true)));
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to load property file", (Throwable)e);
                }
            }
        }
        Pattern pattern = CreateIntegrationAction.getModelinePattern("property");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            this.addTraitSpec(String.format("%s=%s", "camel.properties", matcher.group(1)), traitConfigMap, true);
        }
    }

    private void addBuildPropertyConfigurationSpec(Map<String, Map<String, Object>> traitConfigMap, String source, TestContext context) {
        String traitName = "builder.properties";
        if (this.buildProperties != null && !this.buildProperties.isEmpty()) {
            for (String p : context.resolveDynamicValuesInList(this.buildProperties)) {
                if (CreateIntegrationAction.isValidPropertyFormat(p)) {
                    String[] property = p.split("=", 2);
                    this.addTraitSpec(String.format("%s=%s", "builder.properties", this.createPropertySpec(property[0], property[1], context)), traitConfigMap, true);
                    continue;
                }
                throw new IllegalArgumentException("Property " + p + " does not match format key=value");
            }
        }
        if (this.buildPropertyFiles != null && !this.buildPropertyFiles.isEmpty()) {
            for (String pf : this.buildPropertyFiles) {
                try {
                    Properties props = new Properties();
                    props.load(ResourceUtils.resolve((String)pf, (TestContext)context).getInputStream());
                    props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.addTraitSpec(String.format("%s=%s", "builder.properties", this.createPropertySpec(key.toString(), value.toString(), context)), traitConfigMap, true)));
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to load property file", (Throwable)e);
                }
            }
        }
        Pattern pattern = CreateIntegrationAction.getModelinePattern("build-property");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            this.addTraitSpec(String.format("%s=%s", "builder.properties", matcher.group(1)), traitConfigMap, true);
        }
    }

    private void addEnvVarConfigurationSpec(Map<String, Map<String, Object>> traitConfigMap, String source, TestContext context) {
        String traitName = "environment.vars";
        if (this.envVars != null && !this.envVars.isEmpty()) {
            for (String v : context.resolveDynamicValuesInList(this.envVars)) {
                if (CreateIntegrationAction.isValidPropertyFormat(v)) {
                    String[] property = v.split("=", 2);
                    this.addTraitSpec(String.format("%s=%s", "environment.vars", this.createPropertySpec(property[0], property[1], context)), traitConfigMap, true);
                    continue;
                }
                throw new IllegalArgumentException("EnvVar " + v + " does not match format key=value");
            }
        }
        if (this.envVarFiles != null && !this.envVarFiles.isEmpty()) {
            for (String vf : this.envVarFiles) {
                try {
                    Properties props = new Properties();
                    props.load(ResourceUtils.resolve((String)vf, (TestContext)context).getInputStream());
                    props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.addTraitSpec(String.format("%s=%s", "environment.vars", this.createPropertySpec(key.toString(), value.toString(), context)), traitConfigMap, true)));
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to load env var file", (Throwable)e);
                }
            }
        }
        Pattern pattern = CreateIntegrationAction.getModelinePattern("env");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            this.addTraitSpec(String.format("%s=%s", "environment.vars", matcher.group(1)), traitConfigMap, true);
        }
    }

    private void addRuntimeConfigurationSpec(Map<String, Map<String, Object>> traitConfigMap, String source, TestContext context) {
        String traitName = "mount.configs";
        Pattern pattern = CreateIntegrationAction.getModelinePattern("config");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            String resource = matcher.group(1);
            this.addTraitSpec("%s=%s".formatted(traitName, context.replaceDynamicContentInString(resource)), traitConfigMap, true);
        }
        for (String config : this.configs) {
            this.addTraitSpec("%s=%s".formatted(traitName, context.replaceDynamicContentInString(config)), traitConfigMap, true);
        }
    }

    private String createPropertySpec(String key, String value, TestContext context) {
        return this.escapePropertyItem(key) + "=" + this.escapePropertyItem(context.replaceDynamicContentInString(value));
    }

    private String escapePropertyItem(String item) {
        return item.replaceAll(":", "\\:").replaceAll("=", "\\=");
    }

    private static boolean isValidPropertyFormat(String property) {
        String patternString = "[^\\s]+=.*";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(property);
        return matcher.matches();
    }

    private static List<String> resolveDependencies(String source, List<String> dependencies) {
        ArrayList<String> resolved = new ArrayList<String>(dependencies);
        Pattern pattern = CreateIntegrationAction.getModelinePattern("dependency");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            Object dependency = matcher.group(1);
            if (((String)dependency).startsWith("camel-quarkus-")) {
                dependency = "camel:" + ((String)dependency).substring("camel-quarkus-".length());
            } else if (((String)dependency).startsWith("camel-quarkus:")) {
                dependency = "camel:" + ((String)dependency).substring("camel-quarkus:".length());
            } else if (((String)dependency).startsWith("camel-")) {
                dependency = "camel:" + ((String)dependency).substring("camel-".length());
            }
            resolved.add((String)dependency);
        }
        return resolved;
    }

    private static Pattern getModelinePattern(String name) {
        return Pattern.compile(String.format("^// camel-k: ?%s=(.+)$", name), 8);
    }

    private String sanitizeIntegrationName(String name) {
        String sanitized = name.contains(".") ? name.substring(0, name.indexOf(".")) : name;
        sanitized = sanitized.replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase();
        return sanitized.replaceAll("[^a-z0-9-]", "");
    }

    public static final class Builder
    extends AbstractCamelKAction.Builder<CreateIntegrationAction, Builder> {
        private String integrationName;
        private String fileName;
        private String source;
        private final List<String> dependencies = new ArrayList<String>();
        private final List<String> buildProperties = new ArrayList<String>();
        private final List<String> buildPropertyFiles = new ArrayList<String>();
        private final List<String> envVars = new ArrayList<String>();
        private final List<String> envVarFiles = new ArrayList<String>();
        private final List<String> properties = new ArrayList<String>();
        private final List<String> propertyFiles = new ArrayList<String>();
        private final List<String> traits = new ArrayList<String>();
        private final List<String> openApis = new ArrayList<String>();
        private final List<String> resources = new ArrayList<String>();
        private final List<String> volumes = new ArrayList<String>();
        private final List<String> configs = new ArrayList<String>();
        private final List<String> connects = new ArrayList<String>();
        private boolean supportVariables = true;

        public Builder integration(String integrationName) {
            this.integrationName = integrationName;
            if (this.fileName == null) {
                this.fileName = integrationName;
            }
            return this;
        }

        public Builder supportVariables(boolean supportVariables) {
            this.supportVariables = supportVariables;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder source(String fileName, String source) {
            this.fileName = fileName;
            this.source = source;
            return this;
        }

        public Builder openApi(String configMap) {
            this.openApis.add(configMap);
            return this;
        }

        public Builder resource(String resource) {
            this.resources.add(resource);
            return this;
        }

        public Builder volume(String volume) {
            this.volumes.add(volume);
            return this;
        }

        public Builder config(String config) {
            this.configs.add(config);
            return this;
        }

        public Builder connect(String connect) {
            this.connects.add(connect);
            return this;
        }

        public Builder dependencies(String dependencies) {
            if (dependencies != null && !dependencies.isEmpty()) {
                this.dependencies(Arrays.asList(dependencies.split(",")));
            }
            return this;
        }

        public Builder propertyFile(String propertyFile) {
            this.propertyFiles.add(propertyFile);
            return this;
        }

        public Builder propertyFiles(List<String> propertyFiles) {
            this.propertyFiles.addAll(propertyFiles);
            return this;
        }

        public Builder properties(String properties) {
            if (properties != null && !properties.isEmpty()) {
                this.properties(Arrays.asList(properties.split(",")));
            }
            return this;
        }

        public Builder properties(List<String> properties) {
            this.properties.addAll(properties);
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            properties.forEach(this::property);
            return this;
        }

        public Builder buildPropertyFile(String propertyFile) {
            this.buildPropertyFiles.add(propertyFile);
            return this;
        }

        public Builder buildPropertyFiles(List<String> propertyFiles) {
            this.buildPropertyFiles.addAll(propertyFiles);
            return this;
        }

        public Builder buildProperties(String properties) {
            if (properties != null && !properties.isEmpty()) {
                this.buildProperties(Arrays.asList(properties.split(",")));
            }
            return this;
        }

        public Builder buildProperties(List<String> properties) {
            this.buildProperties.addAll(properties);
            return this;
        }

        public Builder buildProperties(Map<String, String> properties) {
            properties.forEach(this::buildProperty);
            return this;
        }

        public Builder envVarFile(String envVarFile) {
            this.envVarFiles.add(envVarFile);
            return this;
        }

        public Builder envVarFiles(List<String> envVarFiles) {
            this.envVarFiles.addAll(envVarFiles);
            return this;
        }

        public Builder envVars(String vars) {
            if (vars != null && !vars.isEmpty()) {
                this.envVars(Arrays.asList(vars.split(",")));
            }
            return this;
        }

        public Builder envVars(List<String> vars) {
            this.envVars.addAll(vars);
            return this;
        }

        public Builder envVars(Map<String, String> vars) {
            vars.forEach(this::envVar);
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder dependency(String dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public Builder property(String name, String value) {
            this.properties.add(name + "=" + value);
            return this;
        }

        public Builder buildProperty(String name, String value) {
            this.buildProperties.add(name + "=" + value);
            return this;
        }

        public Builder envVar(String name, String value) {
            this.envVars.add(name + "=" + value);
            return this;
        }

        public Builder traits(String traits) {
            if (traits != null && !traits.isEmpty()) {
                this.traits(Arrays.asList(traits.split(",")));
            }
            return this;
        }

        public Builder traits(List<String> traits) {
            this.traits.addAll(traits);
            return this;
        }

        public Builder trait(String name, String key, Object value) {
            this.traits.add(String.format("%s.%s=%s", name, key, value));
            return this;
        }

        public CreateIntegrationAction build() {
            return new CreateIntegrationAction(this);
        }
    }
}

