/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.integration;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.apache.camel.v1.Integration;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.actions.AbstractCamelKAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.model.IntegrationList;

public class DeleteIntegrationAction
extends AbstractCamelKAction {
    private final String integrationName;

    public DeleteIntegrationAction(Builder builder) {
        super("delete-integration", builder);
        this.integrationName = builder.integrationName;
    }

    public void doExecute(TestContext context) {
        String name = context.replaceDynamicContentInString(this.integrationName);
        this.LOG.info(String.format("Deleting Camel K integration '%s'", name));
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            DeleteIntegrationAction.deleteLocalIntegration(name, context);
        } else {
            DeleteIntegrationAction.deleteIntegration(this.getKubernetesClient(), this.namespace(context), name);
        }
        this.LOG.info(String.format("Successfully deleted Camel K integration '%s'", name));
    }

    private static void deleteIntegration(KubernetesClient k8sClient, String namespace, String name) {
        ((Resource)((NonNamespaceOperation)k8sClient.resources(Integration.class, IntegrationList.class).inNamespace(namespace)).withName(name)).delete();
    }

    private static void deleteLocalIntegration(String name, TestContext context) {
        Long pid = context.getVariables().containsKey(name + ":pid") ? (Long)context.getVariable(name + ":pid", Long.class) : CamelJBang.camel().getAll().stream().filter(props -> name.equals(props.get("NAME")) && !props.getOrDefault("PID", "").isBlank()).map(props -> Long.valueOf((String)props.get("PID"))).findFirst().orElseThrow(() -> new CitrusRuntimeException(String.format("Unable to retrieve integration process id %s:pid", name)));
        CamelJBang.camel().stop(pid);
    }

    public static class Builder
    extends AbstractCamelKAction.Builder<DeleteIntegrationAction, Builder> {
        private String integrationName;

        public Builder integration(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public DeleteIntegrationAction build() {
            return new DeleteIntegrationAction(this);
        }
    }
}

