/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.kamelet;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.camel.v1alpha1.KameletBinding;
import org.apache.camel.v1alpha1.KameletBindingBuilder;
import org.apache.camel.v1alpha1.KameletBindingFluent;
import org.apache.camel.v1alpha1.KameletBindingSpec;
import org.apache.camel.v1alpha1.KameletBindingSpecBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.Integration;
import org.apache.camel.v1alpha1.kameletbindingspec.Sink;
import org.apache.camel.v1alpha1.kameletbindingspec.SinkBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.SinkFluent;
import org.apache.camel.v1alpha1.kameletbindingspec.Source;
import org.apache.camel.v1alpha1.kameletbindingspec.SourceBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.SourceFluent;
import org.apache.camel.v1alpha1.kameletbindingspec.source.Ref;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.IsJsonPredicate;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.actions.kamelet.AbstractKameletAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.jbang.CamelJBangSettings;
import org.citrusframework.yaks.camelk.jbang.ProcessAndOutput;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletBindingList;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateKameletBindingAction
extends AbstractKameletAction {
    private static final Logger LOG = LoggerFactory.getLogger(CreateKameletBindingAction.class);
    private final String bindingName;
    private final Integration integration;
    private final Source source;
    private final Sink sink;
    private final Resource resource;

    public CreateKameletBindingAction(Builder builder) {
        super("create-binding", builder);
        this.bindingName = builder.bindingName;
        this.integration = builder.integration;
        this.source = builder.source;
        this.sink = builder.sink;
        this.resource = builder.resource;
    }

    public void doExecute(TestContext context) {
        KameletBinding binding;
        String bindingName = context.replaceDynamicContentInString(this.bindingName);
        LOG.info(String.format("Creating Camel K binding '%s'", bindingName));
        if (this.resource != null) {
            try {
                String yamlOrJson = context.replaceDynamicContentInString(FileUtils.readToString((Resource)this.resource));
                if (IsJsonPredicate.getInstance().test(yamlOrJson)) {
                    binding = (KameletBinding)KubernetesSupport.json().readValue(yamlOrJson, KameletBinding.class);
                }
                Map raw = (Map)KubernetesSupport.yaml().load(yamlOrJson);
                binding = (KameletBinding)KubernetesSupport.json().convertValue((Object)raw, KameletBinding.class);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException(String.format("Failed to load binding from resource %s", bindingName + ".yaml"), (Throwable)e);
            }
        } else {
            KameletBindingBuilder builder = (KameletBindingBuilder)((KameletBindingFluent.MetadataNested)new KameletBindingBuilder().withNewMetadata().withName(bindingName)).endMetadata();
            KameletBindingSpecBuilder specBuilder = new KameletBindingSpecBuilder();
            if (this.integration != null) {
                specBuilder.withIntegration(this.integration);
            }
            if (this.source != null) {
                if (this.source.getProperties() != null && this.source.getProperties().getAdditionalProperties() != null) {
                    context.resolveDynamicValuesInMap(this.source.getProperties().getAdditionalProperties());
                }
                specBuilder.withSource(this.source);
            }
            if (this.sink != null) {
                if (this.sink.getUri() != null) {
                    this.sink.setUri(context.replaceDynamicContentInString(this.sink.getUri()));
                }
                if (this.sink.getProperties() != null && this.sink.getProperties().getAdditionalProperties() != null) {
                    context.resolveDynamicValuesInMap(this.sink.getProperties().getAdditionalProperties());
                }
                specBuilder.withSink(this.sink);
            }
            binding = ((KameletBindingBuilder)builder.withSpec(specBuilder.build())).build();
        }
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            this.createLocal(KubernetesSupport.dumpYaml((Object)binding), bindingName, context);
        } else {
            this.createKameletBinding(this.getKubernetesClient(), this.namespace(context), binding, context);
        }
        LOG.info(String.format("Successfully created binding '%s'", binding.getMetadata().getName()));
    }

    private void createKameletBinding(KubernetesClient k8sClient, String namespace, KameletBinding binding, TestContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(KubernetesSupport.dumpYaml((Object)binding));
        }
        ((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)k8sClient.resources(KameletBinding.class, KameletBindingList.class).inNamespace(namespace)).resource((Object)binding)).createOr(Updatable::update);
    }

    private void createLocal(String yaml, String name, TestContext context) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(yaml);
            }
            Path workDir = CamelJBangSettings.getWorkDir();
            Files.createDirectories(workDir, new FileAttribute[0]);
            Path file = workDir.resolve(String.format("i-%s.yaml", name));
            Files.writeString(file, (CharSequence)yaml, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            ProcessAndOutput pao = CamelJBang.camel().run(name, file, new String[0]);
            if (!pao.getProcess().isAlive()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(pao.getOutput());
                }
                throw new CitrusRuntimeException(String.format("Failed to create binding - exit code %s", pao.getProcess().exitValue()));
            }
            Long pid = pao.getCamelProcessId();
            context.setVariable(name + ":pid", (Object)pid);
            context.setVariable(name + ":process:" + pid, (Object)pao);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create binding file", (Throwable)e);
        }
    }

    public static final class Builder
    extends AbstractKameletAction.Builder<CreateKameletBindingAction, Builder> {
        private String bindingName;
        private Integration integration;
        private Source source;
        private Sink sink;
        private Resource resource;

        public Builder binding(String bindingName) {
            this.apiVersion("v1alpha1");
            this.bindingName = bindingName;
            return this;
        }

        public Builder integration(Integration integration) {
            this.integration = integration;
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            return this;
        }

        public Builder source(String uri) {
            return this.source(((SourceBuilder)new SourceBuilder().withUri(uri)).build());
        }

        public Builder source(Ref ref, String properties) {
            Map props = null;
            if (properties != null && !properties.isEmpty()) {
                props = (Map)KubernetesSupport.yaml().load(properties);
            }
            return this.source(((SourceBuilder)((SourceFluent.PropertiesNested)((SourceBuilder)new SourceBuilder().withRef(ref)).withNewProperties().addToAdditionalProperties(props)).endProperties()).build());
        }

        public Builder sink(Sink sink) {
            this.sink = sink;
            return this;
        }

        public Builder sink(String uri) {
            return this.sink(((SinkBuilder)new SinkBuilder().withUri(uri)).build());
        }

        public Builder sink(org.apache.camel.v1alpha1.kameletbindingspec.sink.Ref ref, String properties) {
            Map props = null;
            if (properties != null && !properties.isEmpty()) {
                props = (Map)KubernetesSupport.yaml().load(properties);
            }
            return this.sink(((SinkBuilder)((SinkFluent.PropertiesNested)((SinkBuilder)new SinkBuilder().withRef(ref)).withNewProperties().addToAdditionalProperties(props)).endProperties()).build());
        }

        public Builder fromBuilder(KameletBindingBuilder builder) {
            KameletBinding binding = builder.build();
            this.bindingName = binding.getMetadata().getName();
            this.integration = ((KameletBindingSpec)binding.getSpec()).getIntegration();
            this.source = ((KameletBindingSpec)binding.getSpec()).getSource();
            this.sink = ((KameletBindingSpec)binding.getSpec()).getSink();
            return this;
        }

        public Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public CreateKameletBindingAction build() {
            return new CreateKameletBindingAction(this);
        }
    }
}

