/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.kamelet;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.camel.v1.Pipe;
import org.apache.camel.v1.PipeBuilder;
import org.apache.camel.v1.PipeFluent;
import org.apache.camel.v1.PipeSpec;
import org.apache.camel.v1.PipeSpecBuilder;
import org.apache.camel.v1.pipespec.Integration;
import org.apache.camel.v1.pipespec.Sink;
import org.apache.camel.v1.pipespec.SinkBuilder;
import org.apache.camel.v1.pipespec.SinkFluent;
import org.apache.camel.v1.pipespec.Source;
import org.apache.camel.v1.pipespec.SourceBuilder;
import org.apache.camel.v1.pipespec.SourceFluent;
import org.apache.camel.v1.pipespec.sink.Ref;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.IsJsonPredicate;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.actions.kamelet.AbstractKameletAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.jbang.CamelJBangSettings;
import org.citrusframework.yaks.camelk.jbang.ProcessAndOutput;
import org.citrusframework.yaks.camelk.model.PipeList;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePipeAction
extends AbstractKameletAction {
    private static final Logger LOG = LoggerFactory.getLogger(CreatePipeAction.class);
    private final String pipeName;
    private final Integration integration;
    private final Source source;
    private final Sink sink;
    private final Resource resource;

    public CreatePipeAction(Builder builder) {
        super("create-pipe", builder);
        this.pipeName = builder.pipeName;
        this.integration = builder.integration;
        this.source = builder.source;
        this.sink = builder.sink;
        this.resource = builder.resource;
    }

    public void doExecute(TestContext context) {
        Pipe pipe;
        String pipeName = context.replaceDynamicContentInString(this.pipeName);
        LOG.info(String.format("Creating Camel K pipe '%s'", pipeName));
        if (this.resource != null) {
            try {
                String yamlOrJson = context.replaceDynamicContentInString(FileUtils.readToString((Resource)this.resource));
                if (IsJsonPredicate.getInstance().test(yamlOrJson)) {
                    pipe = (Pipe)KubernetesSupport.json().readValue(yamlOrJson, Pipe.class);
                }
                Map raw = (Map)KubernetesSupport.yaml().load(yamlOrJson);
                pipe = (Pipe)KubernetesSupport.json().convertValue((Object)raw, Pipe.class);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException(String.format("Failed to load pipe from resource %s", pipeName + ".yaml"), (Throwable)e);
            }
        } else {
            PipeBuilder builder = (PipeBuilder)((PipeFluent.MetadataNested)new PipeBuilder().withNewMetadata().withName(pipeName)).endMetadata();
            PipeSpecBuilder specBuilder = new PipeSpecBuilder();
            if (this.integration != null) {
                specBuilder.withIntegration(this.integration);
            }
            if (this.source != null) {
                if (this.source.getProperties() != null && this.source.getProperties().getAdditionalProperties() != null) {
                    context.resolveDynamicValuesInMap(this.source.getProperties().getAdditionalProperties());
                }
                specBuilder.withSource(this.source);
            }
            if (this.sink != null) {
                if (this.sink.getUri() != null) {
                    this.sink.setUri(context.replaceDynamicContentInString(this.sink.getUri()));
                }
                if (this.sink.getProperties() != null && this.sink.getProperties().getAdditionalProperties() != null) {
                    context.resolveDynamicValuesInMap(this.sink.getProperties().getAdditionalProperties());
                }
                specBuilder.withSink(this.sink);
            }
            pipe = ((PipeBuilder)builder.withSpec(specBuilder.build())).build();
        }
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            this.createLocal(KubernetesSupport.dumpYaml((Object)pipe), pipeName, context);
        } else {
            this.createPipe(this.getKubernetesClient(), this.namespace(context), pipe, context);
        }
        LOG.info(String.format("Successfully created pipe '%s'", pipe.getMetadata().getName()));
    }

    private void createPipe(KubernetesClient k8sClient, String namespace, Pipe pipe, TestContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(KubernetesSupport.dumpYaml((Object)pipe));
        }
        ((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)k8sClient.resources(Pipe.class, PipeList.class).inNamespace(namespace)).resource((Object)pipe)).createOr(Updatable::update);
    }

    private void createLocal(String yaml, String name, TestContext context) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(yaml);
            }
            Path workDir = CamelJBangSettings.getWorkDir();
            Files.createDirectories(workDir, new FileAttribute[0]);
            Path file = workDir.resolve(String.format("i-%s.yaml", name));
            Files.writeString(file, (CharSequence)yaml, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            ProcessAndOutput pao = CamelJBang.camel().run(name, file, new String[0]);
            if (!pao.getProcess().isAlive()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(pao.getOutput());
                }
                throw new CitrusRuntimeException(String.format("Failed to create pipe - exit code %s", pao.getProcess().exitValue()));
            }
            Long pid = pao.getCamelProcessId();
            context.setVariable(name + ":pid", (Object)pid);
            context.setVariable(name + ":process:" + pid, (Object)pao);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create pipe file", (Throwable)e);
        }
    }

    public static final class Builder
    extends AbstractKameletAction.Builder<CreatePipeAction, Builder> {
        private String pipeName;
        private Integration integration;
        private Source source;
        private Sink sink;
        private Resource resource;

        public Builder pipe(String pipeName) {
            this.pipeName = pipeName;
            return this;
        }

        public Builder integration(Integration integration) {
            this.integration = integration;
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            return this;
        }

        public Builder source(String uri) {
            return this.source(((SourceBuilder)new SourceBuilder().withUri(uri)).build());
        }

        public Builder source(org.apache.camel.v1.pipespec.source.Ref ref, String properties) {
            Map props = null;
            if (properties != null && !properties.isEmpty()) {
                props = (Map)KubernetesSupport.yaml().load(properties);
            }
            return this.source(((SourceBuilder)((SourceFluent.PropertiesNested)((SourceBuilder)new SourceBuilder().withRef(ref)).withNewProperties().addToAdditionalProperties(props)).endProperties()).build());
        }

        public Builder sink(Sink sink) {
            this.sink = sink;
            return this;
        }

        public Builder sink(String uri) {
            return this.sink(((SinkBuilder)new SinkBuilder().withUri(uri)).build());
        }

        public Builder sink(Ref ref, String properties) {
            Map props = null;
            if (properties != null && !properties.isEmpty()) {
                props = (Map)KubernetesSupport.yaml().load(properties);
            }
            return this.sink(((SinkBuilder)((SinkFluent.PropertiesNested)((SinkBuilder)new SinkBuilder().withRef(ref)).withNewProperties().addToAdditionalProperties(props)).endProperties()).build());
        }

        public Builder fromBuilder(PipeBuilder builder) {
            Pipe pipe = builder.build();
            this.pipeName = pipe.getMetadata().getName();
            this.integration = ((PipeSpec)pipe.getSpec()).getIntegration();
            this.source = ((PipeSpec)pipe.getSpec()).getSource();
            this.sink = ((PipeSpec)pipe.getSpec()).getSink();
            return this;
        }

        public Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public CreatePipeAction build() {
            return new CreatePipeAction(this);
        }
    }
}

