/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.kamelet;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.apache.camel.v1.Kamelet;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.camelk.actions.kamelet.AbstractKameletAction;
import org.citrusframework.yaks.camelk.model.KameletList;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletV1Alpha1;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletV1Alpha1List;

public class DeleteKameletAction
extends AbstractKameletAction {
    private final String kameletName;

    public DeleteKameletAction(Builder builder) {
        super("delete-kamelet", builder);
        this.kameletName = builder.kameletName;
    }

    public void doExecute(TestContext context) {
        String kameletName = context.replaceDynamicContentInString(this.kameletName);
        if (this.getApiVersion(context).equals("v1alpha1")) {
            ((Resource)((NonNamespaceOperation)this.getKubernetesClient().resources(KameletV1Alpha1.class, KameletV1Alpha1List.class).inNamespace(this.kameletNamespace(context))).withName(kameletName)).delete();
        } else {
            ((Resource)((NonNamespaceOperation)this.getKubernetesClient().resources(Kamelet.class, KameletList.class).inNamespace(this.kameletNamespace(context))).withName(kameletName)).delete();
        }
    }

    public static class Builder
    extends AbstractKameletAction.Builder<DeleteKameletAction, Builder> {
        private String kameletName;

        public Builder kamelet(String name) {
            this.kameletName = name;
            return this;
        }

        public DeleteKameletAction build() {
            return new DeleteKameletAction(this);
        }
    }
}

