/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.kamelet;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.apache.camel.v1alpha1.KameletBinding;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.actions.kamelet.AbstractKameletAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletBindingList;

public class DeleteKameletBindingAction
extends AbstractKameletAction {
    private final String bindingName;

    public DeleteKameletBindingAction(Builder builder) {
        super("delete-binding", builder);
        this.bindingName = builder.bindingName;
    }

    public void doExecute(TestContext context) {
        String binding = context.replaceDynamicContentInString(this.bindingName);
        this.LOG.info(String.format("Deleting binding '%s'", binding));
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            DeleteKameletBindingAction.deleteLocalBinding(binding, context);
        } else {
            this.deleteBinding(this.getKubernetesClient(), this.namespace(context), binding, context);
        }
        this.LOG.info(String.format("Successfully deleted binding '%s'", binding));
    }

    private void deleteBinding(KubernetesClient k8sClient, String namespace, String name, TestContext context) {
        ((Resource)((NonNamespaceOperation)k8sClient.resources(KameletBinding.class, KameletBindingList.class).inNamespace(namespace)).withName(name)).delete();
    }

    private static void deleteLocalBinding(String name, TestContext context) {
        Long pid = context.getVariables().containsKey(name + ":pid") ? (Long)context.getVariable(name + ":pid", Long.class) : CamelJBang.camel().getAll().stream().filter(props -> name.equals(props.get("NAME")) && !props.getOrDefault("PID", "").isBlank()).map(props -> Long.valueOf((String)props.get("PID"))).findFirst().orElseThrow(() -> new CitrusRuntimeException(String.format("Unable to retrieve binding process id %s:pid", name)));
        CamelJBang.camel().stop(pid);
    }

    public static class Builder
    extends AbstractKameletAction.Builder<DeleteKameletBindingAction, Builder> {
        private String bindingName;

        public Builder binding(String name) {
            this.apiVersion("v1alpha1");
            this.bindingName = name;
            return this;
        }

        public DeleteKameletBindingAction build() {
            return new DeleteKameletBindingAction(this);
        }
    }
}

