/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.kamelet;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.apache.camel.v1.Pipe;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.actions.kamelet.AbstractKameletAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.model.PipeList;

public class DeletePipeAction
extends AbstractKameletAction {
    private final String pipeName;

    public DeletePipeAction(Builder builder) {
        super("delete-pipe", builder);
        this.pipeName = builder.pipeName;
    }

    public void doExecute(TestContext context) {
        String pipe = context.replaceDynamicContentInString(this.pipeName);
        this.LOG.info(String.format("Deleting pipe '%s'", pipe));
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            DeletePipeAction.deleteLocalPipe(pipe, context);
        } else {
            this.deletePipe(this.getKubernetesClient(), this.namespace(context), pipe, context);
        }
        this.LOG.info(String.format("Successfully deleted pipe '%s'", pipe));
    }

    private void deletePipe(KubernetesClient k8sClient, String namespace, String name, TestContext context) {
        ((Resource)((NonNamespaceOperation)k8sClient.resources(Pipe.class, PipeList.class).inNamespace(namespace)).withName(name)).delete();
    }

    private static void deleteLocalPipe(String name, TestContext context) {
        Long pid = context.getVariables().containsKey(name + ":pid") ? (Long)context.getVariable(name + ":pid", Long.class) : CamelJBang.camel().getAll().stream().filter(props -> name.equals(props.get("NAME")) && !props.getOrDefault("PID", "").isBlank()).map(props -> Long.valueOf((String)props.get("PID"))).findFirst().orElseThrow(() -> new CitrusRuntimeException(String.format("Unable to retrieve pipe process id %s:pid", name)));
        CamelJBang.camel().stop(pid);
    }

    public static class Builder
    extends AbstractKameletAction.Builder<DeletePipeAction, Builder> {
        private String pipeName;

        public Builder pipe(String name) {
            this.pipeName = name;
            return this;
        }

        public DeletePipeAction build() {
            return new DeletePipeAction(this);
        }
    }
}

