/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.kamelet;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.v1alpha1.KameletBinding;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.CamelKSettings;
import org.citrusframework.yaks.camelk.actions.kamelet.AbstractKameletAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletBindingList;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;

public class VerifyKameletBindingAction
extends AbstractKameletAction {
    private final String bindingName;
    private final int maxAttempts;
    private final long delayBetweenAttempts;

    public VerifyKameletBindingAction(Builder builder) {
        super("verify-binding", builder);
        this.bindingName = builder.bindingName;
        this.maxAttempts = builder.maxAttempts;
        this.delayBetweenAttempts = builder.delayBetweenAttempts;
    }

    public void doExecute(TestContext context) {
        String name = context.replaceDynamicContentInString(this.bindingName);
        this.LOG.info(String.format("Verify binding '%s'", name));
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            this.verifyLocalKameletBinding(name, context);
        } else {
            this.verifyKameletBinding(this.namespace(context), name, context);
        }
        this.LOG.info(String.format("Successfully verified binding '%s' - All values OK!", name));
    }

    private void verifyLocalKameletBinding(String name, TestContext context) {
        Long pid = (Long)context.getVariable(name + ":pid", Long.class);
        for (int i = 0; i < this.maxAttempts; ++i) {
            Map<String, String> properties = CamelJBang.camel().get(pid);
            if (!properties.isEmpty() && properties.get("STATUS").equals("Running")) {
                this.LOG.info(String.format("Verified binding '%s' state 'Running' - All values OK!", name));
                return;
            }
            this.LOG.info(String.format("Waiting for binding '%s' to be in state 'Running'- retry in %s ms", name, this.delayBetweenAttempts));
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.LOG.warn("Interrupted while waiting for binding", (Throwable)e);
            }
        }
        throw new ValidationException(String.format("Failed to retrieve binding '%s' in state 'Running'", name));
    }

    private void verifyKameletBinding(String namespace, String name, TestContext context) {
        KameletBinding binding = null;
        for (int i = 0; i < this.maxAttempts && (binding = (KameletBinding)((Resource)((NonNamespaceOperation)this.getKubernetesClient().resources(KameletBinding.class, KameletBindingList.class).inNamespace(namespace)).withName(name)).get()) == null; ++i) {
            this.LOG.info(String.format("Waiting for binding '%s' - retry in %s ms", name, this.delayBetweenAttempts));
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.LOG.warn("Interrupted while waiting for binding", (Throwable)e);
            }
        }
        if (binding == null) {
            throw new ValidationException(String.format("Failed to retrieve binding '%s' in namespace '%s'", name, namespace));
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(KubernetesSupport.dumpYaml(binding));
        }
    }

    public static final class Builder
    extends AbstractKameletAction.Builder<VerifyKameletBindingAction, Builder> {
        private String bindingName;
        private int maxAttempts = CamelKSettings.getMaxAttempts();
        private long delayBetweenAttempts = CamelKSettings.getDelayBetweenAttempts();

        public Builder isAvailable() {
            return this;
        }

        public Builder isAvailable(String name) {
            this.bindingName = name;
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder delayBetweenAttempts(long delayBetweenAttempts) {
            this.delayBetweenAttempts = delayBetweenAttempts;
            return this;
        }

        public VerifyKameletBindingAction build() {
            return new VerifyKameletBindingAction(this);
        }
    }
}

