/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.kamelet;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.v1.Pipe;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.CamelKSettings;
import org.citrusframework.yaks.camelk.actions.kamelet.AbstractKameletAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.model.PipeList;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;

public class VerifyPipeAction
extends AbstractKameletAction {
    private final String pipeName;
    private final int maxAttempts;
    private final long delayBetweenAttempts;

    public VerifyPipeAction(Builder builder) {
        super("verify-pipe", builder);
        this.pipeName = builder.pipeName;
        this.maxAttempts = builder.maxAttempts;
        this.delayBetweenAttempts = builder.delayBetweenAttempts;
    }

    public void doExecute(TestContext context) {
        String name = context.replaceDynamicContentInString(this.pipeName);
        this.LOG.info(String.format("Verify pipe '%s'", name));
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            this.verifyLocalPipe(name, context);
        } else {
            this.verifyPipe(this.namespace(context), name, context);
        }
        this.LOG.info(String.format("Successfully verified pipe '%s' - All values OK!", name));
    }

    private void verifyLocalPipe(String name, TestContext context) {
        Long pid = (Long)context.getVariable(name + ":pid", Long.class);
        for (int i = 0; i < this.maxAttempts; ++i) {
            Map<String, String> properties = CamelJBang.camel().get(pid);
            if (!properties.isEmpty() && properties.get("STATUS").equals("Running")) {
                this.LOG.info(String.format("Verified pipe '%s' state 'Running' - All values OK!", name));
                return;
            }
            this.LOG.info(String.format("Waiting for pipe '%s' to be in state 'Running'- retry in %s ms", name, this.delayBetweenAttempts));
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.LOG.warn("Interrupted while waiting for pipe", (Throwable)e);
            }
        }
        throw new ValidationException(String.format("Failed to retrieve pipe '%s' in state 'Running'", name));
    }

    private void verifyPipe(String namespace, String name, TestContext context) {
        Pipe pipe = null;
        for (int i = 0; i < this.maxAttempts && (pipe = (Pipe)((Resource)((NonNamespaceOperation)this.getKubernetesClient().resources(Pipe.class, PipeList.class).inNamespace(namespace)).withName(name)).get()) == null; ++i) {
            this.LOG.info(String.format("Waiting for pipe '%s' - retry in %s ms", name, this.delayBetweenAttempts));
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.LOG.warn("Interrupted while waiting for pipe", (Throwable)e);
            }
        }
        if (pipe == null) {
            throw new ValidationException(String.format("Failed to retrieve pipe '%s' in namespace '%s'", name, namespace));
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(KubernetesSupport.dumpYaml(pipe));
        }
    }

    public static final class Builder
    extends AbstractKameletAction.Builder<VerifyPipeAction, Builder> {
        private String pipeName;
        private int maxAttempts = CamelKSettings.getMaxAttempts();
        private long delayBetweenAttempts = CamelKSettings.getDelayBetweenAttempts();

        public Builder isAvailable() {
            return this;
        }

        public Builder isAvailable(String name) {
            this.pipeName = name;
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder delayBetweenAttempts(long delayBetweenAttempts) {
            this.delayBetweenAttempts = delayBetweenAttempts;
            return this;
        }

        public VerifyPipeAction build() {
            return new VerifyPipeAction(this);
        }
    }
}

