/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.jbang;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public final class CamelJBangSettings {
    private static final String JBANG_PROPERTY_PREFIX = "yaks.jbang.";
    private static final String JBANG_ENV_PREFIX = "YAKS_JBANG_";
    private static final String CAMEL_APP_PROPERTY = "yaks.jbang.camel.app";
    private static final String CAMEL_APP_ENV = "YAKS_JBANG_CAMEL_APP";
    private static final String CAMEL_APP_DEFAULT = "camel@apache/camel";
    private static final String CAMEL_VERSION_PROPERTY = "yaks.jbang.camel.version";
    private static final String CAMEL_VERSION_ENV = "YAKS_JBANG_CAMEL_VERSION";
    private static final String CAMEL_VERSION_DEFAULT = "4.1.0";
    private static final String KAMELETS_VERSION_PROPERTY = "yaks.jbang.kamelets.version";
    private static final String KAMELETS_VERSION_ENV = "YAKS_JBANG_KAMELETS_VERSION";
    private static final String KAMELETS_VERSION_DEFAULT = "";
    private static final String KAMELETS_LOCAL_DIR_PROPERTY = "yaks.jbang.kamelets.local.dir";
    private static final String KAMELETS_LOCAL_DIR_ENV = "YAKS_JBANG_KAMELETS_LOCAL_DIR";
    private static final String TRUST_URL_PROPERTY = "yaks.jbang.trust.url";
    private static final String TRUST_URL_ENV = "YAKS_JBANG_TRUST_URL";
    private static final String TRUST_URL_DEFAULT = "https://github.com/apache/camel/";
    private static final String JBANG_DOWNLOAD_URL_PROPERTY = "yaks.jbang.download.url";
    private static final String JBANG_DOWNLOAD_URL_ENV = "YAKS_JBANG_DOWNLOAD_URL";
    private static final String JBANG_DOWNLOAD_URL_DEFAULT = "https://jbang.dev/releases/latest/download/jbang.zip";
    private static final String WORK_DIR_PROPERTY = "yaks.jbang.work.dir";
    private static final String WORK_DIR_ENV = "YAKS_JBANG_WORK_DIR";
    private static final String WORK_DIR_DEFAULT = ".yaks-jbang";
    private static final String DUMP_PROCESS_OUTPUT_PROPERTY = "yaks.jbang.dump.process.output";
    private static final String DUMP_PROCESS_OUTPUT_ENV = "YAKS_JBANG_DUMP_PROCESS_OUTPUT";
    private static final String DUMP_PROCESS_OUTPUT_DEFAULT = "false";
    private static final String CAMEL_DUMP_INTEGRATION_OUTPUT_PROPERTY = "yaks.jbang.camel.dump.integration.output";
    private static final String CAMEL_DUMP_INTEGRATION_OUTPUT_ENV = "YAKS_JBANG_CAMEL_DUMP_INTEGRATION_OUTPUT";
    private static final String CAMEL_DUMP_INTEGRATION_OUTPUT_DEFAULT = "false";

    private CamelJBangSettings() {
    }

    public static String getJBangDownloadUrl() {
        return System.getProperty(JBANG_DOWNLOAD_URL_PROPERTY, System.getenv(JBANG_DOWNLOAD_URL_ENV) != null ? System.getenv(JBANG_DOWNLOAD_URL_ENV) : JBANG_DOWNLOAD_URL_DEFAULT);
    }

    public static Path getWorkDir() {
        String workDir = Optional.ofNullable(System.getProperty(WORK_DIR_PROPERTY, System.getenv(WORK_DIR_ENV))).orElse(WORK_DIR_DEFAULT);
        Path path = Paths.get(workDir, new String[0]);
        if (path.isAbsolute()) {
            return path.toAbsolutePath();
        }
        return Paths.get(KAMELETS_VERSION_DEFAULT, new String[0]).toAbsolutePath().resolve(workDir).toAbsolutePath();
    }

    public static Path getKameletsLocalDir() {
        return Optional.ofNullable(System.getProperty(KAMELETS_LOCAL_DIR_PROPERTY, System.getenv(KAMELETS_LOCAL_DIR_ENV))).map(dir -> {
            Path path = Paths.get(dir, new String[0]);
            if (path.isAbsolute()) {
                return path.toAbsolutePath();
            }
            return CamelJBangSettings.getWorkDir().resolve((String)dir).toAbsolutePath();
        }).orElse(null);
    }

    public static String[] getTrustUrl() {
        return System.getProperty(TRUST_URL_PROPERTY, System.getenv(TRUST_URL_ENV) != null ? System.getenv(TRUST_URL_ENV) : TRUST_URL_DEFAULT).split(",");
    }

    public static boolean isCamelDumpIntegrationOutput() {
        return Boolean.parseBoolean(System.getProperty(CAMEL_DUMP_INTEGRATION_OUTPUT_PROPERTY, System.getenv(CAMEL_DUMP_INTEGRATION_OUTPUT_ENV) != null ? System.getenv(CAMEL_DUMP_INTEGRATION_OUTPUT_ENV) : "false"));
    }

    public static boolean isDumpProcessOutput() {
        return Boolean.parseBoolean(System.getProperty(DUMP_PROCESS_OUTPUT_PROPERTY, System.getenv(DUMP_PROCESS_OUTPUT_ENV) != null ? System.getenv(DUMP_PROCESS_OUTPUT_ENV) : "false"));
    }

    public static String getCamelApp() {
        return System.getProperty(CAMEL_APP_PROPERTY, System.getenv(CAMEL_APP_ENV) != null ? System.getenv(CAMEL_APP_ENV) : CAMEL_APP_DEFAULT);
    }

    public static String getCamelVersion() {
        return System.getProperty(CAMEL_VERSION_PROPERTY, System.getenv(CAMEL_VERSION_ENV) != null ? System.getenv(CAMEL_VERSION_ENV) : CAMEL_VERSION_DEFAULT);
    }

    public static String getKameletsVersion() {
        return System.getProperty(KAMELETS_VERSION_PROPERTY, System.getenv(KAMELETS_VERSION_ENV) != null ? System.getenv(KAMELETS_VERSION_ENV) : KAMELETS_VERSION_DEFAULT);
    }
}

