/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.jbang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.camelk.jbang.CamelJBangSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessAndOutput {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessAndOutput.class);
    private final Process process;
    private String output;
    private BufferedReader reader;

    ProcessAndOutput(Process process) {
        this(process, "");
    }

    ProcessAndOutput(Process process, String output) {
        this.process = process;
        this.output = output;
    }

    ProcessAndOutput(Process process, File outputFile) {
        this.process = process;
        try {
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(outputFile)));
        }
        catch (FileNotFoundException e) {
            throw new CitrusRuntimeException(String.format("Failed to access process output file %s", outputFile.getName()), (Throwable)e);
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public String getOutput() {
        if (this.process.isAlive()) {
            this.readChunk();
        } else if (this.reader != null) {
            this.readAllAndClose();
        }
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAllAndClose() {
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                builder.append(line).append(System.lineSeparator());
            }
            if (builder.isEmpty()) return;
            this.output = this.output + builder;
            return;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to get JBang process output", (Throwable)e);
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                LOG.debug("Failed to close JBang process output reader", (Throwable)e);
            }
            finally {
                this.reader = null;
            }
        }
    }

    private void readChunk() {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        }
        int maxRead = 100;
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            for (int read = 1; read <= maxRead && this.reader.ready() && (line = this.reader.readLine()) != null; ++read) {
                builder.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to get JBang process output", (Throwable)e);
        }
        if (!builder.isEmpty()) {
            this.output = this.output == null ? builder.toString() : this.output + builder.toString().stripTrailing();
        }
    }

    public Long getCamelProcessId() {
        try {
            if (ProcessAndOutput.isUnix()) {
                Awaitility.await().atMost(15000L, TimeUnit.MILLISECONDS).until(() -> this.process.descendants().findAny().isPresent());
                return this.process.descendants().filter(p -> p.info().commandLine().orElse("").contains(CamelJBangSettings.getCamelApp())).findFirst().map(ProcessHandle::pid).orElse(this.process.pid());
            }
            return this.process.pid();
        }
        catch (SecurityException | UnsupportedOperationException e) {
            return this.process.pid();
        }
    }

    private static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("nix") || os.contains("nux") || os.contains("aix");
    }
}

