/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camel;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.SimpleReferenceResolver;

public class CamelReferenceResolver
implements ReferenceResolver {
    private CamelContext camelContext;
    private ReferenceResolver fallback = new SimpleReferenceResolver();

    public CamelReferenceResolver() {
    }

    public CamelReferenceResolver(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public <T> T resolve(Class<T> type) {
        Set components = this.camelContext.getRegistry().findByType(type);
        if (components.isEmpty()) {
            throw new CitrusRuntimeException(String.format("Unable to find bean reference for type '%s'", type));
        }
        return (T)components.iterator().next();
    }

    public <T> T resolve(String name, Class<T> type) {
        Object component = this.camelContext.getRegistry().lookupByNameAndType(name, type);
        if (component != null) {
            return (T)component;
        }
        if (this.fallback.isResolvable(name)) {
            return (T)this.fallback.resolve(name, type);
        }
        throw new CitrusRuntimeException(String.format("Unable to find bean reference for name '%s'", name));
    }

    public Object resolve(String name) {
        Object component = this.camelContext.getRegistry().lookupByName(name);
        if (component != null) {
            return component;
        }
        if (this.fallback.isResolvable(name)) {
            return this.fallback.resolve(name);
        }
        throw new CitrusRuntimeException(String.format("Unable to find bean reference for name '%s'", name));
    }

    public <T> Map<String, T> resolveAll(Class<T> requiredType) {
        return this.camelContext.getRegistry().findByTypeWithName(requiredType);
    }

    public boolean isResolvable(String name) {
        return this.camelContext.getRegistry().lookupByName(name) != null || this.fallback.isResolvable(name);
    }

    public boolean isResolvable(Class<?> type) {
        return !this.camelContext.getRegistry().findByType(type).isEmpty() || this.fallback.isResolvable(type);
    }

    public boolean isResolvable(String name, Class<?> type) {
        return this.camelContext.getRegistry().lookupByNameAndType(name, type) != null || this.fallback.isResolvable(name, type);
    }

    public CamelReferenceResolver withFallback(ReferenceResolver fallback) {
        this.fallback = fallback;
        return this;
    }

    public void bind(String name, Object value) {
        this.camelContext.getRegistry().bind(name, value);
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setFallback(ReferenceResolver fallback) {
        this.fallback = fallback;
    }
}

