/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camel;

import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class CamelSettings {
    private static final String CAMEL_PROPERTY_PREFIX = "yaks.camel.";
    private static final String CAMEL_ENV_PREFIX = "YAKS_CAMEL_";
    static final String AUTO_REMOVE_RESOURCES_PROPERTY = "yaks.camel.auto.remove.resources";
    static final String AUTO_REMOVE_RESOURCES_ENV = "YAKS_CAMEL_AUTO_REMOVE_RESOURCES";
    static final String AUTO_REMOVE_RESOURCES_DEFAULT = "true";
    private static final String CONTEXT_NAME_PROPERTY = "yaks.camel.context.name";
    private static final String CONTEXT_NAME_ENV = "YAKS_CAMEL_CONTEXT_NAME";
    private static final String CONTEXT_NAME_DEFAULT = "yaks-camel-context";
    private static final String TIMEOUT_PROPERTY = "yaks.camel.timeout";
    private static final String TIMEOUT_ENV = "YAKS_CAMEL_TIMEOUT";

    private CamelSettings() {
    }

    public static boolean isAutoRemoveResources() {
        return Boolean.parseBoolean(System.getProperty(AUTO_REMOVE_RESOURCES_PROPERTY, System.getenv(AUTO_REMOVE_RESOURCES_ENV) != null ? System.getenv(AUTO_REMOVE_RESOURCES_ENV) : AUTO_REMOVE_RESOURCES_DEFAULT));
    }

    public static long getTimeout() {
        return Optional.ofNullable(System.getProperty(TIMEOUT_PROPERTY, System.getenv(TIMEOUT_ENV))).map(Long::parseLong).orElse(TimeUnit.SECONDS.toMillis(60L));
    }

    public static String getContextName() {
        return System.getProperty(CONTEXT_NAME_PROPERTY, System.getenv(CONTEXT_NAME_ENV) != null ? System.getenv(CONTEXT_NAME_ENV) : CONTEXT_NAME_DEFAULT);
    }
}

