/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camel;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.After;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.transform.Source;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.xml.CamelRouteContextFactoryBean;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusSettings;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.camel.actions.CamelRouteActionBuilder;
import org.citrusframework.camel.dsl.CamelSupport;
import org.citrusframework.camel.endpoint.CamelEndpoint;
import org.citrusframework.camel.endpoint.CamelEndpointConfiguration;
import org.citrusframework.camel.endpoint.CamelSyncEndpoint;
import org.citrusframework.camel.endpoint.CamelSyncEndpointConfiguration;
import org.citrusframework.camel.util.CamelUtils;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.xml.StringSource;
import org.citrusframework.yaks.camel.CamelReferenceResolver;
import org.citrusframework.yaks.camel.CamelSettings;
import org.citrusframework.yaks.groovy.GroovyShellUtils;
import org.citrusframework.yaks.util.ResourceUtils;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;

public class CamelSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestContext context;
    private CamelContext camelContext;
    private final String contextName = CamelSettings.getContextName();
    private final Map<String, CamelEndpoint> endpoints = new HashMap<String, CamelEndpoint>();
    private Map<String, Object> headers = new HashMap<String, Object>();
    private String body;
    private String messageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
    private long timeout = CamelSettings.getTimeout();
    private boolean globalCamelContext = false;
    private boolean autoRemoveResources = CamelSettings.isAutoRemoveResources();
    private ExchangePattern exchangePattern = ExchangePattern.InOnly;

    @Before
    public void before(Scenario scenario) {
        if (this.camelContext == null) {
            if ((long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(CamelContext.class).size() == 1L) {
                this.camelContext = (CamelContext)this.citrus.getCitrusContext().getReferenceResolver().resolve(CamelContext.class);
                this.globalCamelContext = true;
            } else if (this.citrus.getCitrusContext().getReferenceResolver().isResolvable(this.contextName)) {
                this.camelContext = (CamelContext)this.citrus.getCitrusContext().getReferenceResolver().resolve(this.contextName, CamelContext.class);
                this.globalCamelContext = true;
            }
        }
        if (this.camelContext != null && !(this.context.getReferenceResolver() instanceof CamelReferenceResolver)) {
            this.context.setReferenceResolver((ReferenceResolver)new CamelReferenceResolver(this.camelContext).withFallback(this.citrus.getCitrusContext().getReferenceResolver()));
        }
        this.headers = new HashMap<String, Object>();
        this.body = null;
    }

    @After
    public void after(Scenario scenario) {
        if (this.autoRemoveResources) {
            this.endpoints.clear();
            this.destroyCamelContext();
        }
    }

    @Given(value="^Disable auto removal of Camel resources$")
    public void disableAutoRemove() {
        this.autoRemoveResources = false;
    }

    @Given(value="^Enable auto removal of Camel resources$")
    public void enableAutoRemove() {
        this.autoRemoveResources = true;
    }

    @Given(value="^Camel exchange pattern (InOut|InOnly)$")
    public void setExchangePattern(String exchangePattern) {
        this.exchangePattern = ExchangePattern.valueOf((String)exchangePattern);
    }

    @Given(value="^(?:Default|New) Camel context$")
    public void defaultContext() {
        this.verifyNonGlobalContext();
        this.destroyCamelContext();
        this.camelContext();
    }

    @Given(value="^(?:Default|New) global Camel context$")
    public void defaultGlobalContext() {
        this.destroyCamelContext();
        this.citrus.getCitrusContext().bind(this.contextName, (Object)this.camelContext());
        this.globalCamelContext = true;
    }

    @Given(value="^(?:Default|New) Spring Camel context$")
    public void camelContext(String beans) {
        this.verifyNonGlobalContext();
        this.destroyCamelContext();
        this.springCamelContext(beans);
    }

    @Given(value="^(?:Default|New) global Spring Camel context$")
    public void defaultGlobalContext(String beans) {
        this.destroyCamelContext();
        this.citrus.getCitrusContext().bind(this.contextName, (Object)this.springCamelContext(beans));
        this.globalCamelContext = true;
    }

    @Given(value="^Camel consumer timeout is (\\d+)(?: ms| milliseconds)$")
    public void configureTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Given(value="^bind to Camel registry ([^\"\\s]+)\\.groovy$")
    public void bindComponent(String name, String configurationScript) {
        Object component = GroovyShellUtils.run((ImportCustomizer)new ImportCustomizer(), (String)this.context.replaceDynamicContentInString(configurationScript), (Citrus)this.citrus, (TestContext)this.context);
        if (component instanceof InitializingPhase) {
            ((InitializingPhase)component).initialize();
        }
        this.camelContext().getRegistry().bind(name, component);
        this.citrus.getCitrusContext().bind(name, component);
    }

    @Given(value="^load to Camel registry ([^\"\\s]+)\\.groovy$")
    public void loadComponent(String filePath) throws IOException {
        Resource scriptFile = ResourceUtils.resolve((String)(filePath + ".groovy"), (TestContext)this.context);
        String script = FileUtils.readToString((Resource)scriptFile);
        String fileName = FileUtils.getFileName((String)scriptFile.getLocation());
        String baseName = Optional.ofNullable(fileName).map(f -> f.lastIndexOf(".")).filter(index -> index >= 0).map(index -> fileName.substring(0, (int)index)).orElse(fileName);
        this.bindComponent(baseName, script);
    }

    @Given(value="^Camel route ([^\\s]+)\\.xml")
    public void camelRouteXml(String id, String routeSpec) throws Exception {
        List routesToUse;
        String routeContext = this.createRouteContext(id, routeSpec);
        final ModelCamelContext camelContext = (ModelCamelContext)this.camelContext();
        try {
            Object value = CamelUtils.getJaxbContext().createUnmarshaller().unmarshal((Source)new StringSource(this.context.replaceDynamicContentInString(routeContext)));
            if (!(value instanceof CamelRouteContextFactoryBean)) {
                throw new CitrusRuntimeException(String.format("Failed to parse routes from given route context - expected %s but found %s", CamelRouteContextFactoryBean.class, value.getClass()));
            }
            CamelRouteContextFactoryBean factoryBean = (CamelRouteContextFactoryBean)value;
            routesToUse = factoryBean.getRoutes();
        }
        catch (JAXBException e) {
            throw new CitrusRuntimeException("Failed to create the JAXB unmarshaller", (Throwable)e);
        }
        camelContext.addRoutes((RoutesBuilder)new RouteBuilder((CamelContext)camelContext){

            public void configure() throws Exception {
                for (RouteDefinition routeDefinition : routesToUse) {
                    try {
                        this.getRouteCollection().getRoutes().add(routeDefinition);
                    }
                    catch (Exception e) {
                        throw new CitrusRuntimeException(String.format("Failed to create route definition '%s' in context '%s'", routeDefinition.getId(), camelContext.getName()), (Throwable)e);
                    }
                }
            }
        });
    }

    private String createRouteContext(String routeId, String routeSpec) {
        String routeContextElement = "<routeContext xmlns=\"http://camel.apache.org/schema/spring\">%s</routeContext>";
        if (routeSpec.startsWith("<route>")) {
            return String.format("<routeContext xmlns=\"http://camel.apache.org/schema/spring\">%s</routeContext>", String.format("<route id=\"%s\">", routeId) + routeSpec.substring("<route>".length()));
        }
        if (routeSpec.startsWith("<routeContext>")) {
            return String.format("<routeContext xmlns=\"http://camel.apache.org/schema/spring\">%s</routeContext>", routeSpec.substring("<routeContext>".length(), routeSpec.length() - "</routeContext>".length()));
        }
        if (routeSpec.startsWith("<routeContext")) {
            return routeSpec;
        }
        return String.format("<routeContext xmlns=\"http://camel.apache.org/schema/spring\">%s</routeContext>", String.format("<route id=\"%s\">", routeId) + routeSpec + "</route>");
    }

    @Given(value="^Camel route ([^\\s]+)\\.groovy")
    public void camelRouteGroovy(final String id, final String route) throws Exception {
        RouteBuilder routeBuilder = new RouteBuilder(this.camelContext()){

            public void configure() throws Exception {
                ImportCustomizer ic = new ImportCustomizer();
                ic.addStarImports(new String[]{"org.apache.camel"});
                GroovyShellUtils.run((ImportCustomizer)ic, (Object)((Object)this), (String)CamelSteps.this.context.replaceDynamicContentInString(route), (Citrus)CamelSteps.this.citrus, (TestContext)CamelSteps.this.context);
            }

            protected void configureRoute(RouteDefinition route2) {
                route2.routeId(id);
            }
        };
        this.camelContext().addRoutes((RoutesBuilder)routeBuilder);
    }

    @Given(value="^load Camel route ([^\\s]+)\\.(groovy|xml)")
    public void loadCamelRoute(String fileName, String language) throws Exception {
        String route = FileUtils.readToString((Resource)ResourceUtils.resolve((String)"%s.%s".formatted(fileName, language), (TestContext)this.context));
        switch (language) {
            case "groovy": {
                this.camelRouteGroovy(fileName, route);
                break;
            }
            case "xml": {
                this.camelRouteXml(fileName, route);
            }
        }
    }

    @Given(value="^start Camel route ([^\\s]+)$")
    public void startRoute(String routeId) {
        this.runner.run((TestActionBuilder)CamelRouteActionBuilder.camel().context(this.camelContext()).start(new String[]{routeId}));
    }

    @Given(value="^stop Camel route ([^\\s]+)$")
    public void stopRoute(String routeId) {
        this.runner.run((TestActionBuilder)CamelRouteActionBuilder.camel().context(this.camelContext()).stop(new String[]{routeId}));
    }

    @Given(value="^remove Camel route ([^\\s]+)$")
    public void removeRoute(String routeId) {
        this.runner.run((TestActionBuilder)CamelRouteActionBuilder.camel().context(this.camelContext()).remove(new String[]{routeId}));
    }

    @Given(value="^Camel exchange message header ([^\\s]+)(?:=| is )\"(.+)\"$")
    @Then(value="^(?:expect|verify) Camel exchange message header ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addMessageHeader(String name, Object value) {
        this.headers.put(name, value);
    }

    @Given(value="^Camel exchange message headers$")
    public void addMessageHeaders(DataTable headers) {
        Map headerPairs = headers.asMap(String.class, Object.class);
        headerPairs.forEach(this::addMessageHeader);
    }

    @Given(value="^Camel exchange body type: (.+)$")
    @Then(value="^(?:expect|verify) Camel exchange body type: (.+)$")
    public void setExchangeBodyType(String messageType) {
        this.messageType = messageType;
    }

    @Given(value="^Camel exchange body$")
    @Then(value="^(?:expect|verify) Camel exchange body$")
    public void setExchangeBodyMultiline(String body) {
        this.setExchangeBody(body);
    }

    @Given(value="^Camel exchange body: (.+)$")
    @Then(value="^(?:expect|verify) Camel exchange body: (.+)$")
    public void setExchangeBody(String body) {
        this.body = body;
    }

    @Given(value="^load Camel exchange body ([^\\s]+)$")
    @Then(value="^(?:expect|verify) Camel exchange body loaded from ([^\\s]+)$")
    public void loadExchangeBody(String file) {
        try {
            this.body = FileUtils.readToString((Resource)ResourceUtils.resolve((String)file, (TestContext)this.context));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to load body from file resource %s", file));
        }
    }

    @When(value="^send Camel exchange to\\(\"(.+)\"\\)$")
    public void sendExchange(String endpointUri) {
        this.runner.run((TestActionBuilder)((SendMessageAction.SendMessageActionBuilderSupport)((SendMessageAction.SendMessageActionBuilderSupport)((SendMessageAction.SendMessageActionBuilderSupport)((SendMessageAction.Builder)SendMessageAction.Builder.send().endpoint((Endpoint)this.camelEndpoint(endpointUri))).message()).type(this.messageType)).body(this.body)).headers(this.headers));
        this.body = null;
        this.headers.clear();
    }

    @Then(value="^(?:receive|expect|verify) Camel exchange from\\(\"(.+)\"\\)$")
    public void receiveExchange(String endpointUri) {
        this.runner.run((TestActionBuilder)((ReceiveMessageAction.ReceiveMessageActionBuilderSupport)((ReceiveMessageAction.ReceiveMessageActionBuilderSupport)((ReceiveMessageAction.ReceiveMessageActionBuilderSupport)((ReceiveMessageAction.Builder)((ReceiveMessageAction.Builder)((ReceiveMessageAction.Builder)ReceiveMessageAction.Builder.receive().endpoint((Endpoint)this.camelEndpoint(endpointUri))).timeout(this.timeout)).transform((MessageProcessor.Builder)CamelSupport.camel((CamelContext)this.camelContext()).convertBodyTo(String.class))).message()).type(this.messageType)).body(this.body)).headers(this.headers));
        this.body = null;
        this.headers.clear();
    }

    @When(value="^send Camel exchange to\\(\"(.+)\"\\) with body$")
    public void sendExchangeMultilineBody(String endpointUri, String body) {
        this.setExchangeBody(body);
        this.sendExchange(endpointUri);
    }

    @When(value="^send Camel exchange to\\(\"(.+)\"\\) with body: (.+)$")
    public void sendExchangeBody(String endpointUri, String body) {
        this.setExchangeBody(body);
        this.sendExchange(endpointUri);
    }

    @When(value="^send Camel exchange to\\(\"(.+)\"\\) with body and headers: (.+)$")
    public void sendMessageBodyAndHeaders(String endpointUri, String body, DataTable headers) {
        this.setExchangeBody(body);
        this.addMessageHeaders(headers);
        this.sendExchange(endpointUri);
    }

    @Then(value="^(?:receive|expect|verify) Camel exchange from\\(\"(.+)\"\\) with body$")
    public void receiveExchangeBodyMultiline(String endpointUri, String body) {
        this.setExchangeBody(body);
        this.receiveExchange(endpointUri);
    }

    @Then(value="^(?:receive|expect|verify) Camel exchange from\\(\"(.+)\"\\) with body: (.+)$")
    public void receiveExchangeBody(String endpointUri, String body) {
        this.setExchangeBody(body);
        this.receiveExchange(endpointUri);
    }

    @Then(value="^(?:receive|expect|verify) Camel exchange from\\(\"(.+)\"\\) message with body and headers: (.+)$")
    public void receiveFromJms(String endpointUri, String body, DataTable headers) {
        this.setExchangeBody(body);
        this.addMessageHeaders(headers);
        this.receiveExchange(endpointUri);
    }

    private CamelEndpoint camelEndpoint(String endpointUri) {
        if (this.endpoints.containsKey(endpointUri)) {
            return this.endpoints.get(endpointUri);
        }
        if (this.exchangePattern.equals((Object)ExchangePattern.InOut)) {
            CamelSyncEndpointConfiguration endpointConfiguration = new CamelSyncEndpointConfiguration();
            endpointConfiguration.setCamelContext(this.camelContext());
            endpointConfiguration.setEndpointUri(endpointUri);
            endpointConfiguration.setTimeout(this.timeout);
            CamelSyncEndpoint endpoint = new CamelSyncEndpoint(endpointConfiguration);
            this.endpoints.put(endpointUri, (CamelEndpoint)endpoint);
            return endpoint;
        }
        CamelEndpointConfiguration endpointConfiguration = new CamelEndpointConfiguration();
        endpointConfiguration.setCamelContext(this.camelContext());
        endpointConfiguration.setEndpointUri(endpointUri);
        endpointConfiguration.setTimeout(this.timeout);
        CamelEndpoint endpoint = new CamelEndpoint(endpointConfiguration);
        this.endpoints.put(endpointUri, endpoint);
        return endpoint;
    }

    private CamelContext camelContext() {
        if (this.camelContext == null) {
            try {
                this.camelContext = new DefaultCamelContext();
                this.context.setReferenceResolver((ReferenceResolver)new CamelReferenceResolver(this.camelContext).withFallback(this.citrus.getCitrusContext().getReferenceResolver()));
                this.camelContext.start();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to start default Camel context", e);
            }
        }
        return this.camelContext;
    }

    private CamelContext springCamelContext(String beans) {
        if (this.camelContext == null) {
            try {
                GenericXmlApplicationContext ctx = new GenericXmlApplicationContext(new org.springframework.core.io.Resource[]{new ByteArrayResource(this.context.replaceDynamicContentInString(beans).getBytes(StandardCharsets.UTF_8))});
                this.camelContext = (CamelContext)ctx.getBean(SpringCamelContext.class);
                this.context.setReferenceResolver((ReferenceResolver)new CamelReferenceResolver(this.camelContext).withFallback(this.citrus.getCitrusContext().getReferenceResolver()));
                this.camelContext.start();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to start Spring Camel context", e);
            }
        }
        return this.camelContext;
    }

    private void destroyCamelContext() {
        if (this.globalCamelContext) {
            return;
        }
        try {
            if (this.camelContext != null) {
                this.camelContext.stop();
                this.camelContext = null;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to stop existing Camel context", e);
        }
    }

    private void verifyNonGlobalContext() {
        if (this.globalCamelContext) {
            throw new CitrusRuntimeException("Unable to create new Spring Camel context because of active global Camel context. You are not allowed to overwrite global Camel context");
        }
    }
}

