/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.citrusframework.Citrus;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.groovy.GroovyScript;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public final class GroovyShellUtils {
    private static final Pattern COMMENTS = Pattern.compile("^(?:\\s*//|/\\*|\\s+\\*).*$", 8);

    private GroovyShellUtils() {
    }

    public static <T> T run(ImportCustomizer ic, String scriptCode, Citrus citrus, TestContext context) {
        return GroovyShellUtils.run(ic, null, scriptCode, citrus, context);
    }

    public static <T> T run(ImportCustomizer ic, Object delegate, String scriptCode, Citrus citrus, TestContext context) {
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{ic});
        cc.setScriptBaseClass(GroovyScript.class.getName());
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        GroovyShell sh = new GroovyShell(cl, new Binding(), cc);
        Script script = sh.parse(scriptCode);
        if (script instanceof GroovyScript) {
            if (delegate != null) {
                ((GroovyScript)script).setDelegate(delegate);
            }
            ((GroovyScript)script).setCitrusFramework(citrus);
            ((GroovyScript)script).setContext(context);
        }
        return (T)script.run();
    }

    public static String removeComments(String script) {
        Matcher matcher = COMMENTS.matcher(script);
        if (matcher.find()) {
            return matcher.replaceAll("").trim();
        }
        return script.trim();
    }
}

