/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.groovy.dsl.endpoints;

import groovy.lang.MissingPropertyException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointBuilder;
import org.springframework.util.ReflectionUtils;

public class EndpointBuilderConfiguration<T extends Endpoint>
implements Supplier<T> {
    private final EndpointBuilder<T> builder;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE = new HashMap();

    public EndpointBuilderConfiguration(EndpointBuilder<T> builder) {
        this.builder = builder;
    }

    public void propertyMissing(String name, Object value) {
        Method m = ReflectionUtils.findMethod(this.builder.getClass(), (String)name, (Class[])new Class[]{value.getClass()});
        if (m == null) {
            if (EndpointBuilderConfiguration.isWrapperForPrimitive(value.getClass())) {
                m = ReflectionUtils.findMethod(this.builder.getClass(), (String)name, (Class[])new Class[]{WRAPPER_TO_PRIMITIVE.get(value.getClass())});
            }
            if (m == null) {
                throw new MissingPropertyException(name, this.builder.getClass());
            }
        }
        try {
            m.invoke(this.builder, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MissingPropertyException(name, this.builder.getClass(), (Throwable)e);
        }
    }

    private static boolean isWrapperForPrimitive(Class<?> type) {
        return WRAPPER_TO_PRIMITIVE.containsKey(type);
    }

    @Override
    public T get() {
        return (T)this.builder.build();
    }

    static {
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, Byte.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Character.class, Character.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Double.class, Double.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Float.class, Float.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Short.class, Short.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Void.class, Void.TYPE);
    }
}

