/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.groovy;

import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionRunner;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointBuilder;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.yaks.groovy.GroovyShellUtils;
import org.citrusframework.yaks.groovy.dsl.ConfigurationScript;
import org.citrusframework.yaks.groovy.dsl.actions.ActionScript;
import org.citrusframework.yaks.groovy.dsl.endpoints.EndpointConfigurationScript;
import org.citrusframework.yaks.util.ResourceUtils;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovyScriptSteps {
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestContext context;
    @CitrusResource
    private TestCaseRunner runner;
    private Map<String, ActionScript> scripts;

    @Before
    public void before(Scenario scenario) {
        this.scripts = new HashMap<String, ActionScript>();
    }

    @Given(value="^(?:create|new) configuration$")
    public void createConfiguration(String config) {
        GroovyShellUtils.run(new ImportCustomizer(), new ConfigurationScript(this.citrus), this.context.replaceDynamicContentInString(config), this.citrus, this.context);
    }

    @Given(value="^load configuration ([^\"\\s]+)\\.groovy$")
    public void loadConfiguration(String filePath) throws IOException {
        Resource scriptFile = ResourceUtils.resolve((String)(filePath + ".groovy"), (TestContext)this.context);
        String script = FileUtils.readToString((Resource)scriptFile);
        this.createConfiguration(script);
    }

    @Given(value="^(?:create|new) endpoint ([^\"\\s]+)\\.groovy$")
    public void createEndpoint(String name, String configurationScript) {
        EndpointBuilder builder = (EndpointBuilder)GroovyShellUtils.run(new ImportCustomizer(), new EndpointConfigurationScript(), this.context.replaceDynamicContentInString(configurationScript), this.citrus, this.context);
        Endpoint endpoint = builder.build();
        if (endpoint instanceof InitializingPhase) {
            ((InitializingPhase)endpoint).initialize();
        }
        endpoint.setName(name);
        this.citrus.getCitrusContext().bind(name, (Object)endpoint);
    }

    @Given(value="^load endpoint ([^\"\\s]+)\\.groovy$")
    public void loadEndpoint(String filePath) throws IOException {
        Resource scriptFile = ResourceUtils.resolve((String)(filePath + ".groovy"), (TestContext)this.context);
        String script = FileUtils.readToString((Resource)scriptFile);
        String fileName = FileUtils.getFileName((String)scriptFile.getLocation());
        String baseName = Optional.ofNullable(fileName).map(f -> f.lastIndexOf(".")).filter(index -> index >= 0).map(index -> fileName.substring(0, (int)index)).orElse(fileName);
        this.createEndpoint(baseName, script);
    }

    @Given(value="^(?:create|new|bind) component ([^\"\\s]+)\\.groovy$")
    public void createComponent(String name, String configurationScript) {
        Object component = GroovyShellUtils.run(new ImportCustomizer(), this.context.replaceDynamicContentInString(configurationScript), this.citrus, this.context);
        if (component instanceof InitializingPhase) {
            ((InitializingPhase)component).initialize();
        }
        this.citrus.getCitrusContext().bind(name, component);
    }

    @Given(value="^load component ([^\"\\s]+)\\.groovy$")
    public void loadComponent(String filePath) throws IOException {
        Resource scriptFile = ResourceUtils.resolve((String)(filePath + ".groovy"), (TestContext)this.context);
        String script = FileUtils.readToString((Resource)scriptFile);
        String fileName = FileUtils.getFileName((String)scriptFile.getLocation());
        String baseName = Optional.ofNullable(fileName).map(f -> f.lastIndexOf(".")).filter(index -> index >= 0).map(index -> fileName.substring(0, (int)index)).orElse(fileName);
        this.createComponent(baseName, script);
    }

    @Given(value="^(?:create|new) actions ([^\"\\s]+)\\.groovy$")
    public void createActionScript(String scriptName, String code) {
        this.scripts.put(scriptName, new ActionScript(code, this.citrus, this.context));
    }

    @Given(value="^load actions ([^\"\\s]+)\\.groovy$")
    public void loadActionScript(String filePath) throws IOException {
        Resource scriptFile = ResourceUtils.resolve((String)(filePath + ".groovy"), (TestContext)this.context);
        String script = FileUtils.readToString((Resource)scriptFile);
        String fileName = FileUtils.getFileName((String)scriptFile.getLocation());
        String baseName = Optional.ofNullable(fileName).map(f -> f.lastIndexOf(".")).filter(index -> index >= 0).map(index -> fileName.substring(0, (int)index)).orElse(fileName);
        this.createActionScript(baseName, script);
    }

    @Then(value="^(?:apply|verify) actions ([^\"\\s]+)\\.groovy$")
    public void runScript(String scriptName) {
        if (!this.scripts.containsKey(scriptName)) {
            try {
                this.loadActionScript(scriptName);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException(String.format("Failed to load/get action script for path/name %s.groovy", scriptName), (Throwable)e);
            }
        }
        Optional.ofNullable(this.scripts.get(scriptName)).orElseThrow(() -> new CitrusRuntimeException(String.format("Unable to find action script %s.groovy", scriptName))).execute((TestActionRunner)this.runner);
    }

    @Then(value="^\\$\\((.+)\\)$")
    public void runAction(String script) {
        new ActionScript(script, this.citrus, this.context).execute((TestActionRunner)this.runner);
    }

    @Then(value="^(?:apply|run) script: (.+)$")
    public void applyScript(String script) {
        if (ActionScript.isActionScript(script)) {
            new ActionScript(script, this.citrus, this.context).execute((TestActionRunner)this.runner);
        } else {
            GroovyShellUtils.run(new ImportCustomizer(), this.context.replaceDynamicContentInString(script), this.citrus, this.context);
        }
    }

    @Then(value="^(?:apply|run) script$")
    public void applyScriptMultiline(String script) {
        this.applyScript(script);
    }

    @Given(value="^(?:apply|run) script ([^\"\\s]+)\\.groovy$")
    public void applyScriptFile(String filePath) throws IOException {
        Resource scriptFile = ResourceUtils.resolve((String)(filePath + ".groovy"), (TestContext)this.context);
        this.applyScript(this.context.replaceDynamicContentInString(FileUtils.readToString((Resource)scriptFile)));
    }
}

