/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.groovy.dsl.actions;

import org.citrusframework.Citrus;
import org.citrusframework.TestActionRunner;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.groovy.GroovyShellUtils;
import org.citrusframework.yaks.groovy.dsl.actions.ActionsConfiguration;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class ActionScript {
    private final String script;
    private final Citrus citrus;
    private final TestContext context;

    public ActionScript(String script, Citrus citrus, TestContext context) {
        this.script = script;
        this.citrus = citrus;
        this.context = context;
    }

    public void execute(TestActionRunner runner) {
        ImportCustomizer ic = new ImportCustomizer();
        GroovyShellUtils.run(ic, new ActionsConfiguration(runner), this.normalize(this.script), this.citrus, this.context);
    }

    private String normalize(String script) {
        String normalized = GroovyShellUtils.removeComments(script);
        if (ActionScript.isActionScript(normalized = GroovyShellUtils.removePackageDeclaration(normalized))) {
            if (normalized.startsWith("$(")) {
                return String.format("$actions { %s }", normalized);
            }
            return normalized;
        }
        return String.format("$actions { $(%s) }", normalized);
    }

    public static boolean isActionScript(String script) {
        return script.startsWith("$actions {") || script.startsWith("$actions{") || script.startsWith("$finally {") || script.startsWith("$finally{") || script.startsWith("$(");
    }
}

