/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.http;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusSettings;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.http.actions.HttpActionBuilder;
import com.consol.citrus.http.actions.HttpServerActionBuilder;
import com.consol.citrus.http.actions.HttpServerRequestActionBuilder;
import com.consol.citrus.http.actions.HttpServerResponseActionBuilder;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.server.HttpServer;
import com.consol.citrus.http.server.HttpServerBuilder;
import com.consol.citrus.message.Message;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.PathExpressionValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.variable.dictionary.DataDictionary;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.yaks.http.HttpSettings;
import org.citrusframework.yaks.http.HttpSteps;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class HttpServerSteps
implements HttpSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestContext context;
    private HttpServer httpServer;
    private ServerConnector sslConnector;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private Map<String, String> requestParams = new HashMap<String, String>();
    private Map<String, Object> bodyValidationExpressions = new HashMap<String, Object>();
    private String requestMessageType;
    private String responseMessageType;
    private String requestBody;
    private String responseBody;
    private DataDictionary<?> outboundDictionary;
    private DataDictionary<?> inboundDictionary;
    private int securePort = HttpSettings.getSecurePort();
    private int serverPort = HttpSettings.getServerPort();
    private String serverName = HttpSettings.getServerName();
    private String sslKeyStorePath = HttpSettings.getSslKeyStorePath();
    private String sslKeyStorePassword = HttpSettings.getSslKeyStorePassword();
    private long timeout = HttpSettings.getTimeout();

    @Before
    public void before(Scenario scenario) {
        if (this.httpServer == null) {
            if (this.citrus.getCitrusContext().getReferenceResolver().isResolvable(this.serverName)) {
                this.httpServer = (HttpServer)this.citrus.getCitrusContext().getReferenceResolver().resolve(this.serverName, HttpServer.class);
                this.serverPort = this.httpServer.getPort();
                this.timeout = this.httpServer.getDefaultTimeout();
            } else if ((long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(HttpServer.class).size() == 1L) {
                this.httpServer = (HttpServer)this.citrus.getCitrusContext().getReferenceResolver().resolve(HttpServer.class);
                this.serverName = this.httpServer.getName();
                this.serverPort = this.httpServer.getPort();
                this.timeout = this.httpServer.getDefaultTimeout();
            }
        }
        this.requestHeaders = new HashMap<String, String>();
        this.responseHeaders = new HashMap<String, String>();
        this.requestParams = new HashMap<String, String>();
        this.requestMessageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
        this.responseMessageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
        this.requestBody = null;
        this.responseBody = null;
        this.bodyValidationExpressions = new HashMap<String, Object>();
        this.outboundDictionary = null;
        this.inboundDictionary = null;
        this.sslConnector = null;
    }

    @Given(value="^HTTP server \"([^\"\\s]+)\"$")
    public void setServer(String name) {
        this.serverName = name;
        if (this.citrus.getCitrusContext().getReferenceResolver().isResolvable(name)) {
            this.httpServer = (HttpServer)this.citrus.getCitrusContext().getReferenceResolver().resolve(name, HttpServer.class);
        }
    }

    @Given(value="^HTTP server \"([^\"\\s]+)\" with configuration$")
    public void setServerWithProperties(String name, DataTable properties) {
        this.configureServer(properties.asMap(String.class, String.class));
        this.setServer(name);
    }

    @Given(value="^(?:create|new) HTTP server \"([^\"\\s]+)\"$")
    public void newServer(String name) {
        this.serverName = name;
        this.httpServer = this.citrus.getCitrusContext().getReferenceResolver().isResolvable(name) ? (HttpServer)this.citrus.getCitrusContext().getReferenceResolver().resolve(name, HttpServer.class) : this.getOrCreateHttpServer();
    }

    @Given(value="^(?:create|new) HTTP server \"([^\"\\s]+)\" with configuration$")
    public void newServerWithProperties(String name, DataTable properties) {
        this.configureServer(properties.asMap(String.class, String.class));
        this.newServer(name);
    }

    @Given(value="^HTTP server listening on port (\\d+)$")
    public void setServerPort(int port) {
        this.serverPort = port;
    }

    @Given(value="^HTTP server secure port (\\d+)$")
    public void setSecureServerPort(int port) {
        this.securePort = port;
        this.enableSecureConnector();
    }

    @Given(value="^enable secure HTTP server$")
    public void enableSecureConnector() {
        this.sslConnector = this.sslConnector();
    }

    @Given(value="^HTTP server SSL keystore path ([^\\s]+)$")
    public void setSslKeyStorePath(String sslKeyStorePath) {
        this.sslKeyStorePath = sslKeyStorePath;
    }

    @Given(value="^HTTP server SSL keystore password ([^\\s]+)$")
    public void setSslKeyStorePassword(String sslKeyStorePassword) {
        this.sslKeyStorePassword = sslKeyStorePassword;
    }

    @Given(value="^start HTTP server$")
    public void startServer() {
        HttpServer httpServer = this.getOrCreateHttpServer();
        if (!httpServer.isRunning()) {
            httpServer.start();
        }
    }

    @Given(value="^stop HTTP server$")
    public void stopServer() {
        HttpServer httpServer = this.getOrCreateHttpServer();
        if (httpServer.isRunning()) {
            httpServer.stop();
        }
    }

    @Given(value="^HTTP server timeout is (\\d+)(?: ms| milliseconds)$")
    public void configureTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Then(value="^(?:expect|verify) HTTP request header: ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addRequestHeader(String name, String value) {
        if (name.equals("Content-Type")) {
            this.requestMessageType = this.getMessageType(value);
        }
        this.requestHeaders.put(name, value);
    }

    @Then(value="^(?:expect|verify) HTTP request headers$")
    public void addRequestHeaders(DataTable headers) {
        Map headerPairs = headers.asMap(String.class, String.class);
        headerPairs.forEach(this::addRequestHeader);
    }

    @Given(value="^(?:expect|verify) HTTP request query parameter ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addRequestQueryParam(String name, String value) {
        this.requestParams.put(name, value);
    }

    @Given(value="^HTTP response header: ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addResponseHeader(String name, String value) {
        if (name.equals("Content-Type")) {
            this.responseMessageType = this.getMessageType(value);
        }
        this.responseHeaders.put(name, value);
    }

    @Given(value="^HTTP response headers$")
    public void addResponseHeaders(DataTable headers) {
        Map headerPairs = headers.asMap(String.class, String.class);
        headerPairs.forEach(this::addResponseHeader);
    }

    @Then(value="^(?:expect|verify) HTTP request expression: ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addBodyValidationExpression(String name, String value) {
        this.bodyValidationExpressions.put(name, value);
    }

    @Then(value="^(?:expect|verify) HTTP request expressions$")
    public void addBodyValidationExpressions(DataTable validationExpressions) {
        Map expressions = validationExpressions.asMap(String.class, String.class);
        expressions.forEach(this::addBodyValidationExpression);
    }

    @Given(value="^HTTP response body$")
    public void setResponseBodyMultiline(String body) {
        this.setResponseBody(body);
    }

    @Given(value="^load HTTP response body ([^\\s]+)$")
    public void loadResponseBody(String file) {
        try {
            this.setResponseBody(FileUtils.readToString((Resource)FileUtils.getFileResource((String)file)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to load body from file resource %s", file));
        }
    }

    @Given(value="^HTTP response body: (.+)$")
    public void setResponseBody(String body) {
        this.responseBody = body;
    }

    @Then(value="^(?:expect|verify) HTTP request body$")
    public void setRequestBodyMultiline(String body) {
        this.setRequestBody(body);
    }

    @Then(value="^(?:expect|verify) HTTP request body loaded from ([^\\s]+)$")
    public void loadRequestBody(String file) {
        try {
            this.setRequestBody(FileUtils.readToString((Resource)FileUtils.getFileResource((String)file)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to load body from file resource %s", file));
        }
    }

    @Then(value="^(?:expect|verify) HTTP request body: (.+)$")
    public void setRequestBody(String body) {
        this.requestBody = body;
    }

    @When(value="^receive HTTP request$")
    public void receiveServerRequestFull(String requestData) {
        this.receiveServerRequest(HttpMessage.fromRequestData((String)requestData));
    }

    @Then(value="^send HTTP response$")
    public void sendServerResponseFull(String responseData) {
        this.sendServerResponse(HttpMessage.fromResponseData((String)responseData));
    }

    @When(value="^receive (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE)$")
    public void receiveServerRequestMultilineBody(String method) {
        this.receiveServerRequest(method, null);
    }

    @When(value="^receive (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE) ([^\"\\s]+)$")
    public void receiveServerRequest(String method, String path) {
        this.receiveServerRequest(this.createRequest(this.requestBody, this.requestHeaders, this.requestParams, method, path));
        this.requestBody = null;
        this.requestHeaders.clear();
        this.requestParams.clear();
    }

    @Then(value="^send HTTP (\\d+)(?: [^\\s]+)?$")
    public void sendServerResponse(Integer status) {
        this.sendServerResponse(this.createResponse(this.responseBody, this.responseHeaders, status));
        this.responseBody = null;
        this.responseHeaders.clear();
    }

    public void receiveServerRequest(HttpMessage request) {
        HttpServer httpServer = this.getOrCreateHttpServer();
        if (!httpServer.isRunning()) {
            httpServer.start();
        }
        HttpServerActionBuilder.HttpServerReceiveActionBuilder receiveBuilder = HttpActionBuilder.http().server((Endpoint)httpServer).receive();
        HttpServerRequestActionBuilder.HttpMessageBuilderSupport requestBuilder = request.getRequestMethod() == null || request.getRequestMethod().equals((Object)HttpMethod.POST) ? (HttpServerRequestActionBuilder.HttpMessageBuilderSupport)receiveBuilder.post().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.GET) ? (HttpServerRequestActionBuilder.HttpMessageBuilderSupport)receiveBuilder.get().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.PUT) ? (HttpServerRequestActionBuilder.HttpMessageBuilderSupport)receiveBuilder.put().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.DELETE) ? (HttpServerRequestActionBuilder.HttpMessageBuilderSupport)receiveBuilder.delete().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.HEAD) ? (HttpServerRequestActionBuilder.HttpMessageBuilderSupport)receiveBuilder.head().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.TRACE) ? (HttpServerRequestActionBuilder.HttpMessageBuilderSupport)receiveBuilder.trace().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.PATCH) ? (HttpServerRequestActionBuilder.HttpMessageBuilderSupport)receiveBuilder.patch().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.OPTIONS) ? (HttpServerRequestActionBuilder.HttpMessageBuilderSupport)receiveBuilder.options().message((Message)request) : (HttpServerRequestActionBuilder.HttpMessageBuilderSupport)receiveBuilder.post().message((Message)request))))))));
        if (!this.bodyValidationExpressions.isEmpty()) {
            requestBuilder.validate((ValidationContext.Builder)PathExpressionValidationContext.Builder.pathExpression().expressions(this.bodyValidationExpressions));
            this.bodyValidationExpressions.clear();
        }
        ((HttpServerRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.timeout(this.timeout)).type(this.requestMessageType);
        if (this.inboundDictionary != null) {
            requestBuilder.dictionary(this.inboundDictionary);
        }
        this.runner.run((TestActionBuilder)requestBuilder);
    }

    public HttpServer getOrCreateHttpServer() {
        if (this.httpServer != null && this.httpServer.getName().equals(this.serverName)) {
            return this.httpServer;
        }
        if (this.citrus.getCitrusContext().getReferenceResolver().isResolvable(this.serverName)) {
            this.httpServer = (HttpServer)this.citrus.getCitrusContext().getReferenceResolver().resolve(this.serverName, HttpServer.class);
            this.serverName = this.httpServer.getName();
            this.serverPort = this.httpServer.getPort();
            this.timeout = this.httpServer.getDefaultTimeout();
            return this.httpServer;
        }
        this.httpServer = (HttpServer)((HttpServerBuilder)((HttpServerBuilder)((HttpServerBuilder)new HttpServerBuilder().autoStart(true)).timeout(this.timeout)).port(this.serverPort)).name(this.serverName).build();
        if (this.sslConnector != null) {
            this.httpServer.setConnector((Connector)this.sslConnector);
        }
        this.citrus.getCitrusContext().getReferenceResolver().bind(this.serverName, (Object)this.httpServer);
        this.httpServer.initialize();
        return this.httpServer;
    }

    private void configureServer(Map<String, String> settings) {
        this.setServerPort(Optional.ofNullable(settings.get("port")).map(arg_0 -> ((TestContext)this.context).replaceDynamicContentInString(arg_0)).map(Integer::parseInt).orElse(this.serverPort));
        this.configureTimeout(Optional.ofNullable(settings.get("timeout")).map(arg_0 -> ((TestContext)this.context).replaceDynamicContentInString(arg_0)).map(Long::valueOf).orElse(this.timeout));
        this.setSslKeyStorePath(settings.getOrDefault("sslKeyStorePath", this.sslKeyStorePath));
        this.setSslKeyStorePassword(settings.getOrDefault("sslKeyStorePassword", this.sslKeyStorePassword));
        if (settings.containsKey("securePort")) {
            this.setSecureServerPort(Integer.parseInt(this.context.replaceDynamicContentInString(settings.get("securePort"))));
        } else if (Boolean.parseBoolean(this.context.replaceDynamicContentInString(settings.getOrDefault("secure", "false")))) {
            this.enableSecureConnector();
        }
    }

    public void sendServerResponse(HttpMessage response) {
        response.setType(this.responseMessageType);
        HttpServerResponseActionBuilder.HttpMessageBuilderSupport responseBuilder = (HttpServerResponseActionBuilder.HttpMessageBuilderSupport)HttpActionBuilder.http().server((Endpoint)this.httpServer).send().response(response.getStatusCode()).message((Message)response);
        if (this.outboundDictionary != null) {
            responseBuilder.dictionary(this.outboundDictionary);
        }
        this.runner.run((TestActionBuilder)responseBuilder);
    }

    public void sendServerResponse(HttpStatus status) {
        this.runner.run((TestActionBuilder)HttpActionBuilder.http().server((Endpoint)this.httpServer).send().response(status));
    }

    private ServerConnector sslConnector() {
        ServerConnector connector = new ServerConnector(new Server(), new ConnectionFactory[]{new SslConnectionFactory(this.sslContextFactory(), "http/1.1"), new HttpConnectionFactory(this.httpConfiguration())});
        connector.setPort(this.securePort);
        return connector;
    }

    private HttpConfiguration httpConfiguration() {
        HttpConfiguration parent = new HttpConfiguration();
        parent.setSecureScheme("https");
        parent.setSecurePort(this.securePort);
        HttpConfiguration configuration = new HttpConfiguration(parent);
        configuration.setCustomizers(Collections.singletonList(new SecureRequestCustomizer()));
        return configuration;
    }

    private SslContextFactory sslContextFactory() {
        try {
            SslContextFactory.Server contextFactory = new SslContextFactory.Server();
            contextFactory.setKeyStorePath(this.getKeyStorePathPath());
            contextFactory.setKeyStorePassword(this.context.replaceDynamicContentInString(this.sslKeyStorePassword));
            return contextFactory;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read keystore file in path: " + this.sslKeyStorePath);
        }
    }

    private String getKeyStorePathPath() throws IOException {
        if (this.sslKeyStorePath.equals("classpath:keystore/http-server.jks")) {
            File tmpKeyStore = File.createTempFile("http-server", ".jks");
            try (InputStream in = FileUtils.getFileResource((String)this.sslKeyStorePath).getInputStream();){
                Files.copy(in, tmpKeyStore.toPath(), StandardCopyOption.REPLACE_EXISTING);
                String string = tmpKeyStore.getPath();
                return string;
            }
        }
        return FileUtils.getFileResource((String)this.context.replaceDynamicContentInString(this.sslKeyStorePath)).getURL().getFile();
    }

    public void setInboundDictionary(DataDictionary<?> inboundDictionary) {
        this.inboundDictionary = inboundDictionary;
    }

    public void setOutboundDictionary(DataDictionary<?> outboundDictionary) {
        this.outboundDictionary = outboundDictionary;
    }

    public void setRequestMessageType(String requestType) {
        this.requestMessageType = requestType;
    }
}

