/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.http.function;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.functions.Function;
import com.consol.citrus.http.server.HttpServer;
import java.util.List;
import java.util.Locale;
import org.citrusframework.yaks.YaksSettings;

public class ResolveServiceUrlFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        if (parameterList.isEmpty()) {
            throw new CitrusRuntimeException("Missing service name for resolve function");
        }
        String serviceName = parameterList.get(0);
        boolean secure = false;
        if (parameterList.size() > 1) {
            secure = Boolean.parseBoolean(parameterList.get(1).toLowerCase(Locale.US));
        }
        String scheme = "http://";
        if (secure) {
            scheme = "https://";
        }
        if (YaksSettings.isLocal()) {
            int port = 0;
            if (context.getReferenceResolver().isResolvable(serviceName)) {
                HttpServer server = (HttpServer)context.getReferenceResolver().resolve(serviceName, HttpServer.class);
                port = server.getPort();
            }
            return String.format("%slocalhost%s", scheme, port > 0 ? ":" + port : "");
        }
        return String.format("%s%s.%s", scheme, serviceName, context.getVariable("YAKS_NAMESPACE"));
    }
}

