/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.http;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusSettings;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.Wait;
import org.citrusframework.container.WaitHttpConditionBuilder;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpActionBuilder;
import org.citrusframework.http.actions.HttpClientActionBuilder;
import org.citrusframework.http.actions.HttpClientRequestActionBuilder;
import org.citrusframework.http.actions.HttpClientResponseActionBuilder;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.http.client.HttpClientBuilder;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.Message;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.validation.PathExpressionValidationContext;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.variable.dictionary.DataDictionary;
import org.citrusframework.yaks.http.HttpSettings;
import org.citrusframework.yaks.http.HttpSteps;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.StringUtils;

public class HttpClientSteps
implements HttpSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    private HttpClient httpClient;
    private String requestUrl;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private Map<String, String> requestParams = new HashMap<String, String>();
    private boolean headerNameIgnoreCase = HttpSettings.isHeaderNameIgnoreCase();
    private Map<String, Object> bodyValidationExpressions = new HashMap<String, Object>();
    private String requestMessageType;
    private String responseMessageType;
    private String requestBody;
    private String responseBody;
    private DataDictionary<?> outboundDictionary;
    private DataDictionary<?> inboundDictionary;
    private long timeout;
    private boolean forkMode = HttpSettings.getForkMode();

    @Before
    public void before(Scenario scenario) {
        if (this.httpClient == null) {
            this.httpClient = (long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(HttpClient.class).size() == 1L ? (HttpClient)this.citrus.getCitrusContext().getReferenceResolver().resolve(HttpClient.class) : (HttpClient)new HttpClientBuilder().timeout(HttpSettings.getTimeout()).build();
        }
        this.timeout = this.httpClient.getEndpointConfiguration().getTimeout();
        this.requestHeaders = new HashMap<String, String>();
        this.responseHeaders = new HashMap<String, String>();
        this.requestParams = new HashMap<String, String>();
        this.requestMessageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
        this.responseMessageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
        this.requestBody = null;
        this.responseBody = null;
        this.bodyValidationExpressions = new HashMap<String, Object>();
        this.outboundDictionary = null;
        this.inboundDictionary = null;
    }

    @Given(value="^HTTP client \"([^\"\\s]+)\"$")
    public void setClient(String id) {
        if (!this.citrus.getCitrusContext().getReferenceResolver().isResolvable(id)) {
            throw new CitrusRuntimeException("Unable to find http client for id: " + id);
        }
        this.httpClient = (HttpClient)this.citrus.getCitrusContext().getReferenceResolver().resolve(id, HttpClient.class);
    }

    @Given(value="^(?:URL|url): ([^\\s]+)$")
    public void setUrl(String url) {
        if (url.startsWith("https")) {
            this.httpClient.getEndpointConfiguration().setRequestFactory((ClientHttpRequestFactory)this.sslRequestFactory());
        }
        this.requestUrl = url;
    }

    @Given(value="^HTTP request timeout is (\\d+)(?: ms| milliseconds)$")
    public void configureTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Given(value="^HTTP request fork mode is (enabled|disabled)$")
    public void configureForkMode(String mode) {
        this.forkMode = "enabled".equals(mode);
    }

    @Given(value="^HTTP header name ignore case is (enabled|disabled)$")
    public void configureHeaderNameIgnoreCase(String mode) {
        this.headerNameIgnoreCase = "enabled".equals(mode);
    }

    @Given(value="^(?:URL|url) is healthy$")
    public void healthCheck() {
        this.waitForHttpUrl(this.requestUrl);
    }

    @Given(value="^(?:URL|url|path) ([^\\s]+) is healthy$")
    public void healthCheck(String urlOrPath) {
        this.waitForHttpUrl(this.getRequestUrl(urlOrPath));
    }

    @Given(value="^wait for (?:URL|url|path) ([^\\s]+)$")
    public void waitForHttpUrl(String urlOrPath) {
        this.waitForHttpStatus(this.getRequestUrl(urlOrPath), 200);
    }

    @Given(value="^wait for (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE) on (?:URL|url|path) ([^\\s]+)$")
    public void waitForHttpUrlUsingMethod(String method, String urlOrPath) {
        this.waitForHttpStatusUsingMethod(method, this.getRequestUrl(urlOrPath), 200);
    }

    @Given(value="^wait for (?:URL|url|path) ([^\\s]+) to return (\\d+)(?: [^\\s]+)?$")
    public void waitForHttpStatus(String urlOrPath, Integer statusCode) {
        this.runner.given((TestActionBuilder)((WaitHttpConditionBuilder)((WaitHttpConditionBuilder)Wait.Builder.waitFor().http().milliseconds(this.timeout)).interval(Long.valueOf(this.timeout / 10L))).status(statusCode.intValue()).url(this.getRequestUrl(urlOrPath)));
    }

    @Given(value="^wait for (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE) on (?:URL|url|path) ([^\\s]+) to return (\\d+)(?: [^\\s]+)?$")
    public void waitForHttpStatusUsingMethod(String method, String urlOrPath, Integer statusCode) {
        this.runner.given((TestActionBuilder)((WaitHttpConditionBuilder)((WaitHttpConditionBuilder)Wait.Builder.waitFor().http().milliseconds(this.timeout)).method(method).interval(Long.valueOf(this.timeout / 10L))).status(statusCode.intValue()).url(this.getRequestUrl(urlOrPath)));
    }

    @Then(value="^(?:expect|verify) HTTP response header ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addResponseHeader(String name, String value) {
        if (name.equals("Content-Type")) {
            this.responseMessageType = this.getMessageType(value);
        }
        this.responseHeaders.put(name, value);
    }

    @Then(value="^(?:expect|verify) HTTP response headers$")
    public void addResponseHeaders(DataTable headers) {
        Map headerPairs = headers.asMap(String.class, String.class);
        headerPairs.forEach(this::addResponseHeader);
    }

    @Given(value="^HTTP request header ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addRequestHeader(String name, String value) {
        if (name.equals("Content-Type")) {
            this.requestMessageType = this.getMessageType(value);
        }
        this.requestHeaders.put(name, value);
    }

    @Given(value="^HTTP request query parameter ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addRequestQueryParam(String name, String value) {
        this.requestParams.put(name, value);
    }

    @Given(value="^HTTP request headers$")
    public void addRequestHeaders(DataTable headers) {
        Map headerPairs = headers.asMap(String.class, String.class);
        headerPairs.forEach(this::addRequestHeader);
    }

    @Then(value="^(?:expect|verify) HTTP response expression: ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addBodyValidationExpression(String name, String value) {
        this.bodyValidationExpressions.put(name, value);
    }

    @Then(value="^(?:expect|verify) HTTP response expressions$")
    public void addBodyValidationExpressions(DataTable validationExpressions) {
        Map expressions = validationExpressions.asMap(String.class, String.class);
        expressions.forEach(this::addBodyValidationExpression);
    }

    @Given(value="^HTTP request body$")
    public void setRequestBodyMultiline(String body) {
        this.setRequestBody(body);
    }

    @Given(value="^load HTTP request body ([^\\s]+)$")
    public void loadRequestBody(String file) {
        try {
            this.setRequestBody(FileUtils.readToString((Resource)FileUtils.getFileResource((String)file)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to load body from file resource %s", file));
        }
    }

    @Given(value="^HTTP request body: (.+)$")
    public void setRequestBody(String body) {
        this.requestBody = body;
    }

    @Then(value="^(?:expect|verify) HTTP response body$")
    public void setResponseBodyMultiline(String body) {
        this.setResponseBody(body);
    }

    @Given(value="^(?:expect|verify) HTTP response body loaded from ([^\\s]+)$")
    public void loadResponseBody(String file) {
        try {
            this.setResponseBody(FileUtils.readToString((Resource)FileUtils.getFileResource((String)file)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to load body from file resource %s", file));
        }
    }

    @Then(value="^(?:expect|verify) HTTP response body: (.+)$")
    public void setResponseBody(String body) {
        this.responseBody = body;
    }

    @When(value="^send HTTP request$")
    public void sendClientRequestFull(String requestData) {
        this.sendClientRequest(HttpMessage.fromRequestData((String)requestData));
    }

    @Then(value="^receive HTTP response$")
    public void receiveClientResponseFull(String responseData) {
        this.receiveClientResponse(HttpMessage.fromResponseData((String)responseData));
    }

    @When(value="^send (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE)$")
    public void sendClientRequestMultilineBody(String method) {
        this.sendClientRequest(method, null);
    }

    @When(value="^send (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE) ([^\"\\s]+)$")
    public void sendClientRequest(String method, String path) {
        this.sendClientRequest(this.createRequest(this.requestBody, this.requestHeaders, this.requestParams, method, path));
        this.requestBody = null;
        this.requestHeaders.clear();
        this.requestParams.clear();
    }

    @Then(value="^receive HTTP (\\d+)(?: [^\\s]+)?$")
    public void receiveClientResponse(Integer status) {
        this.receiveClientResponse(this.createResponse(this.responseBody, this.responseHeaders, status));
        this.responseBody = null;
        this.responseHeaders.clear();
    }

    private void sendClientRequest(HttpMessage request) {
        HttpClientActionBuilder.HttpClientSendActionBuilder sendBuilder = HttpActionBuilder.http().client(this.httpClient).send();
        HttpClientRequestActionBuilder.HttpMessageBuilderSupport requestBuilder = request.getRequestMethod() == null || request.getRequestMethod().equals((Object)HttpMethod.POST) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.post().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.GET) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.get().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.PUT) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.put().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.DELETE) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.delete().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.HEAD) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.head().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.TRACE) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.trace().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.PATCH) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.patch().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.OPTIONS) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.options().message((Message)request) : (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.post().message((Message)request))))))));
        requestBuilder.fork(this.forkMode);
        if (StringUtils.hasText((String)this.requestUrl)) {
            requestBuilder.uri(this.requestUrl);
        }
        requestBuilder.type(this.requestMessageType);
        if (this.outboundDictionary != null) {
            requestBuilder.dictionary(this.outboundDictionary);
        }
        this.runner.run((TestActionBuilder)requestBuilder);
    }

    private void receiveClientResponse(HttpMessage response) {
        HttpClientResponseActionBuilder.HttpMessageBuilderSupport responseBuilder = (HttpClientResponseActionBuilder.HttpMessageBuilderSupport)((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)HttpActionBuilder.http().client(this.httpClient).receive().response(HttpStatus.resolve((int)response.getStatusCode().value())).message((Message)response)).headerNameIgnoreCase(this.headerNameIgnoreCase);
        responseBuilder.validate((ValidationContext.Builder)PathExpressionValidationContext.Builder.pathExpression().expressions(this.bodyValidationExpressions));
        this.bodyValidationExpressions.clear();
        responseBuilder.timeout(this.timeout);
        responseBuilder.type(this.responseMessageType);
        if (this.inboundDictionary != null) {
            responseBuilder.dictionary(this.inboundDictionary);
        }
        this.runner.run((TestActionBuilder)responseBuilder);
    }

    private HttpComponentsClientHttpRequestFactory sslRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory(this.sslClient());
    }

    private org.apache.hc.client5.http.classic.HttpClient sslClient() {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE).build();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new CitrusRuntimeException("Failed to create http client for ssl connection", (Throwable)e);
        }
    }

    private String getRequestUrl(String urlOrPath) {
        if (StringUtils.hasText((String)urlOrPath) && urlOrPath.startsWith("http")) {
            return urlOrPath;
        }
        if (!StringUtils.hasText((String)this.requestUrl)) {
            throw new IllegalStateException("Must provide a base request URL first when using relative resource path: " + urlOrPath);
        }
        if (!StringUtils.hasText((String)urlOrPath) || urlOrPath.equals("/")) {
            return this.requestUrl;
        }
        return (String)(this.requestUrl.endsWith("/") ? this.requestUrl : this.requestUrl + "/") + (urlOrPath.startsWith("/") ? urlOrPath.substring(1) : urlOrPath);
    }

    public void setInboundDictionary(DataDictionary<?> inboundDictionary) {
        this.inboundDictionary = inboundDictionary;
    }

    public void setOutboundDictionary(DataDictionary<?> outboundDictionary) {
        this.outboundDictionary = outboundDictionary;
    }
}

