/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.jdbc;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.actions.ExecuteSQLAction;
import org.citrusframework.actions.ExecuteSQLQueryAction;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.RepeatOnErrorUntilTrue;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.jdbc.JdbcSettings;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class JdbcSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusResource
    private TestContext context;
    @CitrusFramework
    private Citrus citrus;
    private DataSource dataSource;
    private final List<String> sqlQueryStatements = new ArrayList<String>();
    private int maxRetryAttempts = JdbcSettings.getMaxAttempts();
    private long delayBetweenAttempts = JdbcSettings.getDelayBetweenAttempts();

    @Before
    public void before(Scenario scenario) {
        if (this.dataSource == null && (long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(DataSource.class).size() == 1L) {
            this.dataSource = (DataSource)this.citrus.getCitrusContext().getReferenceResolver().resolve(DataSource.class);
        }
    }

    @Given(value="^SQL query retry configuration$")
    public void configureRetryConfiguration(Map<String, Object> configuration) {
        this.maxRetryAttempts = Integer.parseInt(configuration.getOrDefault("maxRetryAttempts", this.maxRetryAttempts).toString());
        this.delayBetweenAttempts = Long.parseLong(configuration.getOrDefault("delayBetweenAttempts", this.delayBetweenAttempts).toString());
    }

    @Given(value="^SQL query max retry attempts: (\\d+)")
    public void configureMaxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
    }

    @Given(value="^SQL query retry delay: (\\d+)ms")
    public void configureDelayBetweenAttempts(long delayBetweenAttempts) {
        this.delayBetweenAttempts = delayBetweenAttempts;
    }

    @Given(value="^(?:D|d)ata source: ([^\"\\s]+)$")
    public void setDataSource(String id) {
        if (!this.citrus.getCitrusContext().getReferenceResolver().isResolvable(id)) {
            throw new CitrusRuntimeException("Unable to find data source for id: " + id);
        }
        this.dataSource = (DataSource)this.citrus.getCitrusContext().getReferenceResolver().resolve(id, DataSource.class);
    }

    @Given(value="^(?:D|d)atabase connection$")
    public void setConnection(DataTable properties) {
        Map connectionProps = properties.asMap(String.class, String.class);
        String driver = connectionProps.getOrDefault("driver", "org.postgresql.Driver");
        String url = connectionProps.getOrDefault("url", "jdbc:postgresql://localhost:5432/testdb");
        String username = connectionProps.getOrDefault("username", "test");
        String password = connectionProps.getOrDefault("password", "test");
        boolean suppressClose = Boolean.parseBoolean(connectionProps.getOrDefault("suppressClose", Boolean.TRUE.toString()));
        SingleConnectionDataSource singleConnectionDataSource = new SingleConnectionDataSource(this.context.replaceDynamicContentInString(url), this.context.replaceDynamicContentInString(username), this.context.replaceDynamicContentInString(password), suppressClose);
        singleConnectionDataSource.setDriverClassName(this.context.replaceDynamicContentInString(driver));
        this.dataSource = singleConnectionDataSource;
    }

    @Given(value="^SQL query: (.+)$")
    public void addQueryStatement(String statement) {
        if (!statement.trim().toUpperCase().startsWith("SELECT")) {
            throw new CitrusRuntimeException("Invalid SQL query - please use proper 'SELECT' statement");
        }
        this.sqlQueryStatements.add(statement);
    }

    @Given(value="^SQL query$")
    public void addQueryStatementMultiline(String statement) {
        this.addQueryStatement(statement);
    }

    @Given(value="^SQL query statements:$")
    public void addQueryStatements(DataTable statements) {
        statements.asList().forEach(this::addQueryStatement);
    }

    @Then(value="^verify column ([^\"\\s]+)=(.+)$")
    public void verifyColumn(String name, String value) {
        if (this.maxRetryAttempts > 0) {
            this.runner.run((TestActionBuilder)RepeatOnErrorUntilTrue.Builder.repeatOnError().until((index, context) -> index >= this.maxRetryAttempts).autoSleep(this.delayBetweenAttempts).actions(new TestActionBuilder[]{((ExecuteSQLQueryAction.Builder)ExecuteSQLQueryAction.Builder.query((DataSource)this.dataSource).statements(this.sqlQueryStatements)).validate(name, new String[]{value})}));
        } else {
            this.runner.run((TestActionBuilder)((ExecuteSQLQueryAction.Builder)ExecuteSQLQueryAction.Builder.query((DataSource)this.dataSource).statements(this.sqlQueryStatements)).validate(name, new String[]{value}));
        }
        this.sqlQueryStatements.clear();
    }

    @Then(value="^verify columns$")
    public void verifyResultSet(DataTable expectedResults) {
        ExecuteSQLQueryAction.Builder action = (ExecuteSQLQueryAction.Builder)ExecuteSQLQueryAction.Builder.query((DataSource)this.dataSource).statements(this.sqlQueryStatements);
        List rows = expectedResults.asLists(String.class);
        rows.forEach(row -> {
            if (!row.isEmpty()) {
                String columnName = (String)row.remove(0);
                action.validate(columnName, row.toArray(new String[0]));
            }
        });
        if (this.maxRetryAttempts > 0) {
            this.runner.run((TestActionBuilder)RepeatOnErrorUntilTrue.Builder.repeatOnError().until((index, context) -> index >= this.maxRetryAttempts).autoSleep(this.delayBetweenAttempts).actions(new TestActionBuilder[]{action}));
        } else {
            this.runner.run((TestActionBuilder)action);
        }
        this.sqlQueryStatements.clear();
    }

    @Then(value="^verify result set$")
    public void verifyResultSet(String verifyScript) {
        if (this.maxRetryAttempts > 0) {
            this.runner.run((TestActionBuilder)RepeatOnErrorUntilTrue.Builder.repeatOnError().until((index, context) -> index >= this.maxRetryAttempts).autoSleep(this.delayBetweenAttempts).actions(new TestActionBuilder[]{((ExecuteSQLQueryAction.Builder)ExecuteSQLQueryAction.Builder.query((DataSource)this.dataSource).statements(this.sqlQueryStatements)).groovy(verifyScript)}));
        } else {
            this.runner.run((TestActionBuilder)((ExecuteSQLQueryAction.Builder)ExecuteSQLQueryAction.Builder.query((DataSource)this.dataSource).statements(this.sqlQueryStatements)).groovy(verifyScript));
        }
        this.sqlQueryStatements.clear();
    }

    @When(value="^(?:execute |perform )?SQL update: (.+)$")
    public void executeUpdate(String statement) {
        if (statement.trim().toUpperCase().startsWith("SELECT")) {
            throw new CitrusRuntimeException("Invalid SQL update statement - please use SQL query for 'SELECT' statements");
        }
        this.runner.run((TestActionBuilder)ExecuteSQLAction.Builder.sql((DataSource)this.dataSource).statement(statement));
    }

    @When(value="^(?:execute |perform )?SQL update$")
    public void executeUpdateMultiline(String statement) {
        this.executeUpdate(statement);
    }

    @When(value="^(?:execute |perform )?SQL updates$")
    public void executeUpdates(DataTable statements) {
        statements.asList().forEach(this::executeUpdate);
    }
}

