/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.jms.connection;

import java.util.Map;
import java.util.ServiceLoader;
import javax.jms.ConnectionFactory;
import org.citrusframework.yaks.jms.connection.DefaultConnectionFactoryCreator;
import org.springframework.util.Assert;

public interface ConnectionFactoryCreator {
    public static final ServiceLoader<ConnectionFactoryCreator> SERVICE_LOADER = ServiceLoader.load(ConnectionFactoryCreator.class);

    public ConnectionFactory create(Map<String, String> var1);

    public boolean supports(Class<?> var1);

    public static ConnectionFactoryCreator lookup(String type) throws ClassNotFoundException {
        Assert.notNull((Object)type, (String)"Missing connection factory type information");
        Class<?> connectionFactoryType = Class.forName(type);
        for (ConnectionFactoryCreator connectionFactoryCreator : SERVICE_LOADER) {
            if (!connectionFactoryCreator.supports(connectionFactoryType)) continue;
            return connectionFactoryCreator;
        }
        return new DefaultConnectionFactoryCreator();
    }
}

