/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.jms.connection;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.jms.ConnectionFactory;
import org.citrusframework.yaks.jms.connection.ConnectionFactoryCreator;
import org.springframework.util.Assert;

public class DefaultConnectionFactoryCreator
implements ConnectionFactoryCreator {
    @Override
    public ConnectionFactory create(Map<String, String> properties) {
        String className = properties.remove("type");
        Assert.notNull((Object)className, (String)"Missing connection factory type information");
        try {
            Class<?> type = Class.forName(className);
            if (!ConnectionFactory.class.isAssignableFrom(type)) {
                throw new IllegalStateException(String.format("Unsupported type information %s - must be of type %s", type.getName(), ConnectionFactory.class.getName()));
            }
            Collection<String> constructorArgs = properties.values();
            Constructor constructor = Arrays.stream(type.getConstructors()).filter(c -> c.getParameterCount() == constructorArgs.size() && Arrays.stream(c.getParameterTypes()).allMatch(paramType -> paramType.equals(String.class))).map(c -> c).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find matching constructor on connection factory"));
            return (ConnectionFactory)constructor.newInstance(constructorArgs.toArray(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean supports(Class<?> type) {
        return ConnectionFactory.class.isAssignableFrom(type);
    }
}

