/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.jms.connection.activemq.artemis;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.citrusframework.yaks.jms.connection.ConnectionFactoryCreator;

public class ActiveMQArtemisConnectionFactoryCreator
implements ConnectionFactoryCreator {
    @Override
    public ConnectionFactory create(Map<String, String> properties) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        try {
            if (properties.containsKey("brokerUrl")) {
                connectionFactory.setBrokerURL(properties.get("brokerUrl"));
            }
            if (properties.containsKey("username")) {
                connectionFactory.setUser(properties.get("username"));
            }
            if (properties.containsKey("password")) {
                connectionFactory.setPassword(properties.get("password"));
            }
        }
        catch (JMSException e) {
            throw new IllegalStateException("Error in initialization ConnectionFactory", e);
        }
        return connectionFactory;
    }

    @Override
    public boolean supports(Class<?> type) {
        return "org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory".equals(type.getName());
    }
}

