/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.jms;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.jms.endpoint.JmsEndpoint;
import com.consol.citrus.jms.endpoint.JmsEndpointBuilder;
import com.consol.citrus.util.FileUtils;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionFactory;
import org.citrusframework.yaks.jms.JmsSettings;
import org.citrusframework.yaks.jms.connection.ConnectionFactoryCreator;
import org.springframework.core.io.Resource;

public class JmsSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusResource
    private TestContext context;
    @CitrusFramework
    private Citrus citrus;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private String body;
    private JmsEndpoint jmsEndpoint;
    private ConnectionFactory connectionFactory;
    private String selector = "";
    private String endpointName = JmsSettings.getEndpointName();
    private long timeout = JmsSettings.getTimeout();

    @Before
    public void before(Scenario scenario) {
        if (this.jmsEndpoint == null) {
            if ((long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(JmsEndpoint.class).size() == 1L) {
                this.jmsEndpoint = (JmsEndpoint)this.citrus.getCitrusContext().getReferenceResolver().resolve(JmsEndpoint.class);
            } else if (this.citrus.getCitrusContext().getReferenceResolver().isResolvable(this.endpointName)) {
                this.jmsEndpoint = (JmsEndpoint)this.citrus.getCitrusContext().getReferenceResolver().resolve(this.endpointName, JmsEndpoint.class);
            } else {
                this.jmsEndpoint = (JmsEndpoint)new JmsEndpointBuilder().timeout(this.timeout).build();
                this.citrus.getCitrusContext().getReferenceResolver().bind(this.endpointName, (Object)this.jmsEndpoint);
            }
        }
        if (this.connectionFactory == null && (long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(ConnectionFactory.class).size() == 1L) {
            this.connectionFactory = (ConnectionFactory)this.citrus.getCitrusContext().getReferenceResolver().resolve(ConnectionFactory.class);
            if (this.jmsEndpoint.getEndpointConfiguration().getConnectionFactory() == null) {
                this.jmsEndpoint.getEndpointConfiguration().setConnectionFactory(this.connectionFactory);
            }
        }
        this.headers = new HashMap<String, Object>();
        this.body = null;
    }

    @Given(value="^(?:JMS|jms) connection factory ([^\\s]+)$")
    public void setConnectionFactory(String name) {
        if (!this.citrus.getCitrusContext().getReferenceResolver().isResolvable(name)) {
            throw new CitrusRuntimeException(String.format("Unable to find connection factory '%s'", name));
        }
        this.connectionFactory = (ConnectionFactory)this.citrus.getCitrusContext().getReferenceResolver().resolve(name, ConnectionFactory.class);
        this.jmsEndpoint.getEndpointConfiguration().setConnectionFactory(this.connectionFactory);
    }

    @Given(value="^(?:JMS|jms) connection factory$")
    public void setConnection(DataTable properties) throws ClassNotFoundException {
        List cells = properties.cells();
        LinkedHashMap<String, String> connectionSettings = new LinkedHashMap<String, String>();
        cells.forEach(row -> connectionSettings.put((String)row.get(0), this.context.replaceDynamicContentInString((String)row.get(1))));
        this.connectionFactory = ConnectionFactoryCreator.lookup((String)connectionSettings.get("type")).create(connectionSettings);
        this.citrus.getCitrusContext().getReferenceResolver().bind("connectionFactory", (Object)this.connectionFactory);
        this.jmsEndpoint.getEndpointConfiguration().setConnectionFactory(this.connectionFactory);
    }

    @Given(value="^(?:JMS|jms) destination: ([^\\s]+)$")
    public void setDestination(String destination) {
        this.jmsEndpoint.getEndpointConfiguration().setDestinationName(destination);
    }

    @Given(value="^(?:JMS|jms) endpoint \"([^\"\\s]+)\"$")
    public void setEndpoint(String name) {
        this.endpointName = name;
        if (this.citrus.getCitrusContext().getReferenceResolver().isResolvable(name)) {
            this.jmsEndpoint = (JmsEndpoint)this.citrus.getCitrusContext().getReferenceResolver().resolve(name, JmsEndpoint.class);
        } else if (this.jmsEndpoint != null) {
            this.citrus.getCitrusContext().getReferenceResolver().bind(this.endpointName, (Object)this.jmsEndpoint);
            this.jmsEndpoint.setName(this.endpointName);
        }
    }

    @Given(value="^(?:JMS|jms) selector: (.+)$")
    public void selector(String selector) {
        this.selector = selector;
    }

    @Given(value="^(?:JMS|jms) consumer timeout is (\\d+)(?: ms| milliseconds)$")
    public void configureTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Given(value="^(?:JMS|jms) message header ([^\\s]+)(?:=| is )\"(.+)\"$")
    @Then(value="^(?:expect|verify) (?:JMS|jms) message header ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addMessageHeader(String name, Object value) {
        this.headers.put(name, value);
    }

    @Given(value="^(?:JMS|jms) message headers$")
    public void addMessageHeaders(DataTable headers) {
        Map headerPairs = headers.asMap(String.class, Object.class);
        headerPairs.forEach(this::addMessageHeader);
    }

    @Given(value="^(?:JMS|jms) message body$")
    @Then(value="^(?:expect|verify) (?:JMS|jms) message body$")
    public void setMessageBodyMultiline(String body) {
        this.setMessageBody(body);
    }

    @Given.Givens(value={@Given(value="^load (?:JMS|jms) message body ([^\\s]+)$"), @Given(value="^(?:expect|verify) (?:JMS|jms) message body loaded from ([^\\s]+)$")})
    public void loadMessageBody(String file) {
        try {
            this.setMessageBody(FileUtils.readToString((Resource)FileUtils.getFileResource((String)file)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to load body from file resource %s", file));
        }
    }

    @Given(value="^(?:JMS|jms) message body: (.+)$")
    @Then(value="^(?:expect|verify) (?:JMS|jms) message body: (.+)$")
    public void setMessageBody(String body) {
        this.body = body;
    }

    @When(value="^send (?:JMS|jms) message with body: (.+)$")
    @Given(value="^(?:JMS|jms) message with body: (.+)$")
    public void sendMessageBody(String body) {
        this.setMessageBody(body);
        this.sendMessage();
    }

    @When(value="^send (?:JMS|jms) message with body$")
    @Given(value="^(?:JMS|jms) message with body$")
    public void sendMessageBodyMultiline(String body) {
        this.sendMessageBody(body);
    }

    @When(value="^send (?:JMS|jms) message with body and headers: (.+)$")
    @Given(value="^(?:JMS|jms) message with body and headers: (.+)$")
    public void sendMessageBodyAndHeaders(String body, DataTable headers) {
        this.setMessageBody(body);
        this.addMessageHeaders(headers);
        this.sendMessage();
    }

    @Then(value="^(?:receive|expect|verify) (?:JMS|jms) message with body: (.+)$")
    public void receiveMessageBody(String body) {
        this.setMessageBody(body);
        this.receiveMessage();
    }

    @Then(value="^(?:receive|expect|verify) (?:JMS|jms) message with body$")
    public void receiveMessageBodyMultiline(String body) {
        this.receiveMessageBody(body);
    }

    @Then(value="^(?:receive|expect|verify) (?:JMS|jms) message with body and headers: (.+)$")
    public void receiveFromJms(String body, DataTable headers) {
        this.setMessageBody(body);
        this.addMessageHeaders(headers);
        this.receiveMessage();
    }

    @When(value="^send (?:JMS|jms) message$")
    public void sendMessage() {
        this.runner.run((TestActionBuilder)((SendMessageAction.SendMessageActionBuilderSupport)((SendMessageAction.SendMessageActionBuilderSupport)((SendMessageAction.Builder)SendMessageAction.Builder.send().endpoint((Endpoint)this.jmsEndpoint)).message()).body(this.body)).headers(this.headers));
        this.body = null;
        this.headers.clear();
    }

    @Then(value="^receive (?:JMS|jms) message$")
    public void receiveMessage() {
        this.runner.run((TestActionBuilder)((ReceiveMessageAction.ReceiveMessageActionBuilderSupport)((ReceiveMessageAction.ReceiveMessageActionBuilderSupport)((ReceiveMessageAction.Builder)((ReceiveMessageAction.Builder)((ReceiveMessageAction.Builder)ReceiveMessageAction.Builder.receive().endpoint((Endpoint)this.jmsEndpoint)).selector(this.selector)).timeout(this.timeout)).message()).body(this.body)).headers(this.headers));
        this.body = null;
        this.headers.clear();
    }

    @When(value="^send (?:JMS|jms) message to destination (.+)$")
    public void sendMessage(String destination) {
        this.setDestination(destination);
        this.sendMessage();
    }

    @Then(value="^receive (?:JMS|jms) message on destination (.+)")
    public void receiveMessage(String destination) {
        this.setDestination(destination);
        this.receiveMessage();
    }
}

