/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative.actions.eventing;

import io.fabric8.knative.eventing.v1.Broker;
import io.fabric8.knative.eventing.v1.BrokerBuilder;
import io.fabric8.knative.eventing.v1.BrokerFluent;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import org.citrusframework.context.TestContext;
import org.citrusframework.http.server.HttpServer;
import org.citrusframework.http.server.HttpServerBuilder;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.knative.KnativeSettings;
import org.citrusframework.yaks.knative.KnativeSupport;
import org.citrusframework.yaks.knative.KnativeVariableNames;
import org.citrusframework.yaks.knative.actions.AbstractKnativeAction;

public class CreateBrokerAction
extends AbstractKnativeAction {
    private final String brokerName;

    public CreateBrokerAction(Builder builder) {
        super("create-broker", builder);
        this.brokerName = builder.brokerName;
    }

    public void doExecute(TestContext context) {
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            this.createLocalBroker(context);
        } else {
            this.createBroker(context);
        }
    }

    private void createLocalBroker(TestContext context) {
        String resolvedBrokerName = context.replaceDynamicContentInString(this.brokerName);
        if (!context.getReferenceResolver().isResolvable(resolvedBrokerName, HttpServer.class)) {
            HttpServer brokerServer = (HttpServer)((HttpServerBuilder)((HttpServerBuilder)new HttpServerBuilder().autoStart(true)).port(Integer.parseInt(KnativeSettings.getServicePort()))).referenceResolver(context.getReferenceResolver()).build();
            brokerServer.initialize();
            context.getReferenceResolver().bind(resolvedBrokerName, (Object)brokerServer);
            context.setVariable(KnativeVariableNames.BROKER_PORT.value(), (Object)brokerServer.getPort());
        }
    }

    private void createBroker(TestContext context) {
        Broker broker = ((BrokerBuilder)((BrokerFluent.MetadataNested)((BrokerFluent.MetadataNested)((BrokerFluent.MetadataNested)((BrokerBuilder)new BrokerBuilder().withApiVersion(String.format("%s/%s", KnativeSupport.knativeEventingGroup(), KnativeSupport.knativeApiVersion()))).withNewMetadata().withNamespace(this.namespace(context))).withName(context.replaceDynamicContentInString(this.brokerName))).withLabels(KnativeSettings.getDefaultLabels())).endMetadata()).build();
        ((Resource)((NonNamespaceOperation)this.getKnativeClient().brokers().inNamespace(this.namespace(context))).resource((Object)broker)).createOr(Updatable::update);
    }

    public static class Builder
    extends AbstractKnativeAction.Builder<CreateBrokerAction, Builder> {
        private String brokerName;

        public Builder name(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public CreateBrokerAction build() {
            return new CreateBrokerAction(this);
        }
    }
}

