/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative.actions.eventing;

import io.fabric8.knative.eventing.v1.Broker;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.http.server.HttpServer;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.knative.actions.AbstractKnativeAction;

public class VerifyBrokerAction
extends AbstractKnativeAction {
    private final String brokerName;

    public VerifyBrokerAction(Builder builder) {
        super("verify-broker", builder);
        this.brokerName = builder.brokerName;
    }

    public void doExecute(TestContext context) {
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            this.verifyLocalBroker(context);
        } else {
            this.verifyBroker(context);
        }
    }

    private void verifyLocalBroker(TestContext context) {
        String resolvedBrokerName = context.replaceDynamicContentInString(this.brokerName);
        if (!context.getReferenceResolver().isResolvable(resolvedBrokerName, HttpServer.class)) {
            throw new ValidationException(String.format("Knative broker '%s' not found", this.brokerName));
        }
        HttpServer brokerServer = (HttpServer)context.getReferenceResolver().resolve(resolvedBrokerName, HttpServer.class);
        if (!brokerServer.isRunning()) {
            throw new ValidationException(String.format("Knative broker '%s' is not ready", this.brokerName));
        }
        this.LOG.info(String.format("Knative broker %s is ready", this.brokerName));
    }

    private void verifyBroker(TestContext context) {
        try {
            Broker broker = (Broker)((Resource)((NonNamespaceOperation)this.getKnativeClient().brokers().inNamespace(this.namespace(context))).withName(this.brokerName)).get();
            if (broker.getStatus() == null || broker.getStatus().getConditions() == null || !broker.getStatus().getConditions().stream().anyMatch(condition -> condition.getType().equals("Ready") && condition.getStatus().equalsIgnoreCase("True"))) {
                throw new ValidationException(String.format("Knative broker '%s' is not ready", this.brokerName));
            }
            this.LOG.info(String.format("Knative broker %s is ready", this.brokerName));
        }
        catch (KubernetesClientException e) {
            throw new ValidationException(String.format("Failed to validate Knative broker '%s' - not found in namespace '%s'", this.brokerName, this.namespace(context)), (Throwable)e);
        }
    }

    public static class Builder
    extends AbstractKnativeAction.Builder<VerifyBrokerAction, Builder> {
        private String brokerName;

        public Builder name(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public VerifyBrokerAction build() {
            return new VerifyBrokerAction(this);
        }
    }
}

