/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative.ce;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.MessageType;
import org.citrusframework.yaks.knative.ce.CloudEvent;
import org.citrusframework.yaks.knative.ce.CloudEventMessage;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;

public final class CloudEventSupport {
    private CloudEventSupport() {
    }

    public static CloudEventMessage createEventMessage(String eventData, Map<String, String> attributes) {
        CloudEventMessage request = CloudEventMessage.fromEvent(CloudEvent.v1_0());
        request.setType(MessageType.JSON);
        request.method(HttpMethod.POST);
        if (attributes.containsKey("data")) {
            request.setPayload(attributes.get("data"));
        } else if (StringUtils.hasText((String)eventData)) {
            request.setPayload(eventData);
        }
        attributes.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("data")).forEach(entry -> {
            Optional<CloudEvent.Attribute> attribute = CloudEvent.v1_0().attributes().stream().filter(a -> a.http().equalsIgnoreCase((String)entry.getKey()) || a.json().equals(entry.getKey())).findFirst();
            if (attribute.isPresent()) {
                request.setAttribute(attribute.get(), entry.getValue());
            } else {
                request.header((String)entry.getKey(), entry.getValue());
            }
        });
        return request;
    }

    public static Map<String, String> attributesFromJson(String json) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        try {
            JsonNode event = new ObjectMapper().reader().readTree(json);
            for (CloudEvent.Attribute attribute : CloudEvent.v1_0().attributes()) {
                Optional.ofNullable(event.findValue(attribute.json())).ifPresent(e -> attributes.put(attribute.json(), e.textValue()));
            }
            if (event.findValue("data") != null) {
                attributes.put("data", event.get("data").textValue());
            }
        }
        catch (JsonProcessingException e2) {
            throw new CitrusRuntimeException("Failed to read cloud event json", (Throwable)e2);
        }
        return attributes;
    }
}

