/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.When;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpActionBuilder;
import org.citrusframework.http.actions.HttpClientRequestActionBuilder;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.http.client.HttpClientBuilder;
import org.citrusframework.message.Message;
import org.citrusframework.yaks.knative.KnativeSettings;
import org.citrusframework.yaks.knative.ce.CloudEventMessage;
import org.citrusframework.yaks.knative.ce.CloudEventSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.StringUtils;

public class SendEventSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    private HttpClient httpClient;
    private String brokerUrl = KnativeSettings.getBrokerUrl();
    private long timeout = KnativeSettings.getEventProducerTimeout();
    private String eventData;

    @Before
    public void before(Scenario scenario) {
        if (this.httpClient == null) {
            if ((long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(HttpClient.class).size() == 1L) {
                this.httpClient = (HttpClient)this.citrus.getCitrusContext().getReferenceResolver().resolve(HttpClient.class);
                this.timeout = this.httpClient.getEndpointConfiguration().getTimeout();
            } else {
                this.httpClient = (HttpClient)new HttpClientBuilder().timeout(this.timeout).build();
            }
        }
        this.eventData = null;
    }

    @Given(value="^Knative broker (?:URL|url): ([^\\s]+)$")
    public void setUrl(String url) {
        if (url.startsWith("https")) {
            this.httpClient.getEndpointConfiguration().setRequestFactory((ClientHttpRequestFactory)this.sslRequestFactory());
        }
        this.brokerUrl = url;
    }

    @Given(value="^Knative client \"([^\"\\s]+)\"$")
    public void setClient(String id) {
        if (!this.citrus.getCitrusContext().getReferenceResolver().isResolvable(id)) {
            throw new CitrusRuntimeException("Unable to find Knative client for id: " + id);
        }
        this.httpClient = (HttpClient)this.citrus.getCitrusContext().getReferenceResolver().resolve(id, HttpClient.class);
    }

    @Given(value="^Knative event producer timeout is (\\d+)(?: ms| milliseconds)$")
    public void configureTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Given(value="^Knative event data$")
    public void setEventDataMultiline(String data) {
        this.setEventData(data);
    }

    @Given(value="^Knative event data: (.+)$")
    public void setEventData(String data) {
        this.eventData = data;
    }

    @When(value="^(?:create|send) Knative event$")
    public void createEvent(DataTable attributes) {
        this.sendEvent(CloudEventSupport.createEventMessage(this.eventData, attributes.asMap(String.class, String.class)));
    }

    @When(value="^(?:create|send) Knative event as json$")
    public void createEventJson(String json) {
        this.sendEvent(CloudEventSupport.createEventMessage(this.eventData, CloudEventSupport.attributesFromJson(json)));
    }

    private void sendEvent(CloudEventMessage request) {
        if (Objects.isNull(request.getContentType())) {
            request.contentType("application/json");
        }
        if (request.getEventId() == null) {
            request.eventId(UUID.randomUUID().toString());
        }
        if (request.getEventType() == null) {
            request.eventType("org.citrusframework.yaks.event.test");
        }
        if (request.getSource() == null) {
            request.source("yaks-test");
        }
        request.setHeader("Host", KnativeSettings.getBrokerHost());
        HttpClientRequestActionBuilder.HttpMessageBuilderSupport requestBuilder = (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)HttpActionBuilder.http().client(this.httpClient).send().post().message((Message)request);
        if (StringUtils.hasText((String)this.brokerUrl)) {
            requestBuilder.uri(this.brokerUrl);
        }
        this.runner.run((TestActionBuilder)requestBuilder);
        if (KnativeSettings.isVerifyBrokerResponse()) {
            this.runner.run((TestActionBuilder)HttpActionBuilder.http().client(this.httpClient).receive().response((HttpStatusCode)HttpStatus.valueOf((int)KnativeSettings.getBrokerResponseStatus())).timeout(this.timeout));
        }
    }

    private HttpComponentsClientHttpRequestFactory sslRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory(this.sslClient());
    }

    private org.apache.hc.client5.http.classic.HttpClient sslClient() {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE).build();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new CitrusRuntimeException("Failed to create http client for ssl connection", (Throwable)e);
        }
    }
}

