/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.kubernetes;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.yaks.YaksSettings;
import org.springframework.util.StringUtils;

public class KubernetesSettings {
    private static final String KUBERNETES_PROPERTY_PREFIX = "yaks.kubernetes.";
    private static final String KUBERNETES_ENV_PREFIX = "YAKS_KUBERNETES_";
    private static final String SERVICE_TIMEOUT_PROPERTY = "yaks.kubernetes.service.timeout";
    private static final String SERVICE_TIMEOUT_ENV = "YAKS_KUBERNETES_SERVICE_TIMEOUT";
    private static final String SERVICE_TIMEOUT_DEFAULT = "2000";
    private static final String NAMESPACE_PROPERTY = "yaks.kubernetes.namespace";
    private static final String NAMESPACE_ENV = "YAKS_KUBERNETES_NAMESPACE";
    private static final String API_VERSION_PROPERTY = "yaks.kubernetes.api.version";
    private static final String API_VERSION_ENV = "YAKS_KUBERNETES_API_VERSION";
    private static final String API_VERSION_DEFAULT = "v1";
    private static final String SERVICE_NAME_PROPERTY = "yaks.kubernetes.service.name";
    private static final String SERVICE_NAME_ENV = "YAKS_KUBERNETES_SERVICE_NAME";
    private static final String SERVICE_NAME_DEFAULT = "yaks-k8s-service";
    private static final String SERVICE_PORT_PROPERTY = "yaks.kubernetes.service.port";
    private static final String SERVICE_PORT_ENV = "YAKS_KUBERNETES_SERVICE_PORT";
    private static final String SERVICE_PORT_DEFAULT = "8080";
    private static final String AUTO_REMOVE_RESOURCES_PROPERTY = "yaks.kubernetes.auto.remove.resources";
    private static final String AUTO_REMOVE_RESOURCES_ENV = "YAKS_KUBERNETES_AUTO_REMOVE_RESOURCES";
    private static final String AUTO_REMOVE_RESOURCES_DEFAULT = "true";
    private static final String DEFAULT_LABELS_PROPERTY = "yaks.kubernetes.default.labels";
    private static final String DEFAULT_LABELS_ENV = "YAKS_KUBERNETES_DEFAULT_LABELS";
    private static final String DEFAULT_LABELS_DEFAULT = "app=yaks";
    private static final String MAX_ATTEMPTS_PROPERTY = "yaks.kubernetes.max.attempts";
    private static final String MAX_ATTEMPTS_ENV = "YAKS_KUBERNETES_MAX_ATTEMPTS";
    private static final String MAX_ATTEMPTS_DEFAULT = "150";
    private static final String DELAY_BETWEEN_ATTEMPTS_PROPERTY = "yaks.kubernetes.delay.between.attempts";
    private static final String DELAY_BETWEEN_ATTEMPTS_ENV = "YAKS_KUBERNETES_DELAY_BETWEEN_ATTEMPTS";
    private static final String DELAY_BETWEEN_ATTEMPTS_DEFAULT = "2000";
    private static final String PRINT_POD_LOGS_PROPERTY = "yaks.kubernetes.print.pod.logs";
    private static final String PRINT_POD_LOGS_ENV = "YAKS_KUBERNETES_PRINT_POD_LOGS";
    private static final String PRINT_POD_LOGS_DEFAULT = "true";
    private static final String WATCH_LOGS_TIMEOUT_PROPERTY = "yaks.kubernetes.watch.logs.timeout";
    private static final String WATCH_LOGS_TIMEOUT_ENV = "YAKS_KUBERNETES_WATCH_LOGS_TIMEOUT";
    private static final String WATCH_LOGS_TIMEOUT_DEFAULT = "60000";

    private KubernetesSettings() {
    }

    public static long getServiceTimeout() {
        return Long.parseLong(System.getProperty(SERVICE_TIMEOUT_PROPERTY, System.getenv(SERVICE_TIMEOUT_ENV) != null ? System.getenv(SERVICE_TIMEOUT_ENV) : "2000"));
    }

    public static String getNamespace() {
        return System.getProperty(NAMESPACE_PROPERTY, System.getenv(NAMESPACE_ENV) != null ? System.getenv(NAMESPACE_ENV) : YaksSettings.getDefaultNamespace());
    }

    public static String getApiVersion() {
        return System.getProperty(API_VERSION_PROPERTY, System.getenv(API_VERSION_ENV) != null ? System.getenv(API_VERSION_ENV) : API_VERSION_DEFAULT);
    }

    public static String getServiceName() {
        return System.getProperty(SERVICE_NAME_PROPERTY, System.getenv(SERVICE_NAME_ENV) != null ? System.getenv(SERVICE_NAME_ENV) : SERVICE_NAME_DEFAULT);
    }

    public static String getServicePort() {
        return System.getProperty(SERVICE_PORT_PROPERTY, System.getenv(SERVICE_PORT_ENV) != null ? System.getenv(SERVICE_PORT_ENV) : SERVICE_PORT_DEFAULT);
    }

    public static Map<String, String> getDefaultLabels() {
        String labelsConfig = System.getProperty(DEFAULT_LABELS_PROPERTY, System.getenv(DEFAULT_LABELS_ENV) != null ? System.getenv(DEFAULT_LABELS_ENV) : DEFAULT_LABELS_DEFAULT);
        return Stream.of(StringUtils.commaDelimitedListToStringArray((String)labelsConfig)).map(item -> StringUtils.delimitedListToStringArray((String)item, (String)"=")).filter(keyValue -> ((String[])keyValue).length == 2).collect(Collectors.toMap(item -> item[0], item -> item[1]));
    }

    public static boolean isAutoRemoveResources() {
        return Boolean.parseBoolean(System.getProperty(AUTO_REMOVE_RESOURCES_PROPERTY, System.getenv(AUTO_REMOVE_RESOURCES_ENV) != null ? System.getenv(AUTO_REMOVE_RESOURCES_ENV) : "true"));
    }

    public static boolean isPrintPodLogs() {
        return Boolean.parseBoolean(System.getProperty(PRINT_POD_LOGS_PROPERTY, System.getenv(PRINT_POD_LOGS_ENV) != null ? System.getenv(PRINT_POD_LOGS_ENV) : "true"));
    }

    public static int getMaxAttempts() {
        return Integer.parseInt(System.getProperty(MAX_ATTEMPTS_PROPERTY, System.getenv(MAX_ATTEMPTS_ENV) != null ? System.getenv(MAX_ATTEMPTS_ENV) : MAX_ATTEMPTS_DEFAULT));
    }

    public static long getDelayBetweenAttempts() {
        return Long.parseLong(System.getProperty(DELAY_BETWEEN_ATTEMPTS_PROPERTY, System.getenv(DELAY_BETWEEN_ATTEMPTS_ENV) != null ? System.getenv(DELAY_BETWEEN_ATTEMPTS_ENV) : "2000"));
    }

    public static long getWatchLogsTimeout() {
        return Long.parseLong(System.getProperty(WATCH_LOGS_TIMEOUT_PROPERTY, System.getenv(WATCH_LOGS_TIMEOUT_ENV) != null ? System.getenv(WATCH_LOGS_TIMEOUT_ENV) : WATCH_LOGS_TIMEOUT_DEFAULT));
    }
}

