/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.kubernetes;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.actions.CreateVariablesAction;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.Assert;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ActionTimeoutException;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.yaks.http.HttpServerSteps;
import org.citrusframework.yaks.kubernetes.KubernetesResource;
import org.citrusframework.yaks.kubernetes.KubernetesSettings;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.citrusframework.yaks.kubernetes.KubernetesVariableNames;
import org.citrusframework.yaks.kubernetes.actions.CreateServiceAction;
import org.citrusframework.yaks.kubernetes.actions.KubernetesActionBuilder;
import org.citrusframework.yaks.kubernetes.actions.VerifyPodAction;
import org.citrusframework.yaks.util.ResourceUtils;
import org.springframework.http.HttpStatus;

public class KubernetesSteps {
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusResource
    private TestContext context;
    private HttpServerSteps httpServerSteps;
    private String servicePort = KubernetesSettings.getServicePort();
    private String serviceName = KubernetesSettings.getServiceName();
    private KubernetesClient k8sClient;
    private boolean autoRemoveResources = KubernetesSettings.isAutoRemoveResources();
    private int maxAttempts = KubernetesSettings.getMaxAttempts();
    private long delayBetweenAttempts = KubernetesSettings.getDelayBetweenAttempts();
    private Duration watchLogsTimeout = Duration.ofMillis(KubernetesSettings.getWatchLogsTimeout());

    @Before
    public void before(Scenario scenario) {
        this.httpServerSteps = new HttpServerSteps();
        CitrusAnnotations.injectAll((Object)this.httpServerSteps, (Citrus)this.citrus, (TestContext)this.context);
        CitrusAnnotations.injectTestRunner((Object)this.httpServerSteps, (TestCaseRunner)this.runner);
        this.httpServerSteps.before(scenario);
        this.httpServerSteps.configureTimeout(KubernetesSettings.getServiceTimeout());
        this.httpServerSteps.setServerPort(Integer.parseInt(this.context.replaceDynamicContentInString(this.servicePort)));
        this.httpServerSteps.setServer(this.serviceName);
        if (this.k8sClient == null) {
            this.k8sClient = KubernetesSupport.getKubernetesClient(this.citrus);
        }
    }

    @Given(value="^Disable auto removal of Kubernetes resources$")
    public void disableAutoRemove() {
        this.autoRemoveResources = false;
    }

    @Given(value="^Kubernetes resource polling configuration$")
    public void configureResourcePolling(Map<String, Object> configuration) {
        this.maxAttempts = Integer.parseInt(configuration.getOrDefault("maxAttempts", this.maxAttempts).toString());
        this.delayBetweenAttempts = Long.parseLong(configuration.getOrDefault("delayBetweenAttempts", this.delayBetweenAttempts).toString());
    }

    @Given(value="^Kubernetes namespace ([^\\s]+)$")
    public void setNamespace(String namespace) {
        this.runner.run((TestActionBuilder)CreateVariablesAction.Builder.createVariable((String)KubernetesVariableNames.NAMESPACE.value(), (String)namespace));
    }

    @Given(value="^Kubernetes timeout is (\\d+)(?: ms| milliseconds)$")
    public void configureTimeout(long timeout) {
        this.httpServerSteps.configureTimeout(timeout);
    }

    @Given(value="^Kubernetes service \"([^\"\\s]+)\"$")
    public void setServiceName(String name) {
        this.serviceName = name;
        this.httpServerSteps.setServer(name);
    }

    @Given(value="^Kubernetes service port ([^\\s]+)$")
    public void setServicePort(String port) {
        this.servicePort = port;
        this.httpServerSteps.setServerPort(Integer.parseInt(this.context.replaceDynamicContentInString(port)));
    }

    @Given(value="^create Kubernetes custom resource in ([^\\s]+)$")
    public void createCustomResource(String resourceType, String yaml) {
        KubernetesResource resource = (KubernetesResource)KubernetesSupport.yaml().loadAs(yaml, KubernetesResource.class);
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).customResources().create().type(resourceType).kind(resource.getKind()).apiVersion(resource.getApiVersion()).content(yaml));
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KubernetesActionBuilder.kubernetes().client(this.k8sClient).customResources().delete(resource.getMetadata().getName()).type(resourceType).kind(resource.getKind()).apiVersion(resource.getApiVersion())}));
        }
    }

    @Given(value="^load Kubernetes custom resource ([^\\s]+) in ([^\\s]+)$")
    public void createCustomResourceFromFile(String fileName, String resourceType) {
        try {
            this.createCustomResource(resourceType, FileUtils.readToString((Resource)ResourceUtils.resolve((String)fileName, (TestContext)this.context)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read custom resource from file", (Throwable)e);
        }
    }

    @Given(value="^delete Kubernetes custom resource in ([^\\s]+)$")
    public void deleteCustomResource(String resourceType, String yaml) {
        KubernetesResource resource = (KubernetesResource)KubernetesSupport.yaml().loadAs(yaml, KubernetesResource.class);
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).customResources().delete(resource.getMetadata().getName()).type(resourceType).kind(resource.getKind()).apiVersion(resource.getApiVersion()));
    }

    @Given(value="^delete Kubernetes custom resource ([^\\s]+) in ([^\\s]+)$")
    public void deleteCustomResourceFromFile(String fileName, String resourceType) {
        try {
            this.deleteCustomResource(resourceType, FileUtils.readToString((Resource)ResourceUtils.resolve((String)fileName, (TestContext)this.context)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read custom resource from file", (Throwable)e);
        }
    }

    @Given(value="^create Kubernetes resource$")
    public void createResource(String content) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).resources().create().content(content));
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KubernetesActionBuilder.kubernetes().client(this.k8sClient).resources().delete(content)}));
        }
    }

    @Given(value="^load Kubernetes resource ([^\\s]+)$")
    public void createResourceFromFile(String fileName) {
        try {
            this.createResource(FileUtils.readToString((Resource)ResourceUtils.resolve((String)fileName, (TestContext)this.context)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read resource from file", (Throwable)e);
        }
    }

    @Given(value="^delete Kubernetes resource$")
    public void deleteResource(String yaml) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).resources().delete(yaml));
    }

    @Given(value="^delete Kubernetes resource ([^\\s]+)$")
    public void deleteResourceFromFile(String fileName) {
        try {
            this.deleteResource(FileUtils.readToString((Resource)ResourceUtils.resolve((String)fileName, (TestContext)this.context)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read resource from file", (Throwable)e);
        }
    }

    @Given(value="^create Kubernetes secret ([^\\s]+)$")
    public void createSecret(String name, Map<String, String> properties) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).secrets().create(name).properties(properties));
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KubernetesActionBuilder.kubernetes().client(this.k8sClient).secrets().delete(name)}));
        }
    }

    @Given(value="^load Kubernetes secret from file ([^\\s]+).properties$")
    public void createSecret(String fileName) {
        this.createSecret(fileName, fileName);
    }

    @Given(value="^create Kubernetes secret ([^\\s]+) from file ([^\\s]+).properties$")
    public void createSecret(String secretName, String fileName) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).secrets().create(secretName).fromFile(fileName + ".properties"));
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KubernetesActionBuilder.kubernetes().client(this.k8sClient).secrets().delete(secretName)}));
        }
    }

    @Given(value="^create Kubernetes service$")
    public void createService() {
        this.createService(this.serviceName, this.servicePort);
    }

    @Given(value="^create Kubernetes service ([^\\s]+)$")
    public void createService(String serviceName) {
        this.createService(serviceName, this.servicePort);
    }

    @Given(value="^create Kubernetes service ([^\\s]+) with target port ([^\\s]+)$")
    public void createService(String serviceName, String targetPort) {
        this.createService(serviceName, "80", targetPort);
    }

    @Given(value="^create Kubernetes service ([^\\s]+) with port mapping ([^\\s]+):([^\\s]+)$")
    public void createService(String serviceName, String port, String targetPort) {
        this.initializeService(serviceName, targetPort);
        this.runner.given((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).services().create(serviceName).port(port).targetPort(targetPort));
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KubernetesActionBuilder.kubernetes().client(this.k8sClient).services().delete(serviceName)}));
        }
    }

    @Given(value="^create Kubernetes service ([^\\s]+) with port mappings$")
    public void createServiceWithPortMappings(String serviceName, DataTable portMappings) {
        CreateServiceAction.Builder createServiceAction = KubernetesActionBuilder.kubernetes().client(this.k8sClient).services().create(serviceName);
        Map mappings = portMappings.asMap(String.class, String.class);
        this.initializeService(serviceName, (String)mappings.values().iterator().next());
        mappings.forEach(createServiceAction::portMapping);
        this.runner.run((TestActionBuilder)createServiceAction);
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KubernetesActionBuilder.kubernetes().client(this.k8sClient).services().delete(serviceName)}));
        }
    }

    @Given(value="^delete Kubernetes service ([^\\s]+)$")
    public void deleteService(String serviceName) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).services().delete(serviceName));
    }

    @Given(value="^delete Kubernetes secret ([^\\s]+)$")
    public void deleteSecret(String secretName) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).secrets().delete(secretName));
    }

    @Given(value="^wait for condition=([^\\s]+) on Kubernetes custom resource ([^\\s]+) in ([^\\s]+)$")
    public void resourceShouldMatchCondition(String condition, String name, String resourceType) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).customResources().verify(name).type(resourceType).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts).condition(condition));
    }

    @Given(value="^Kubernetes custom resource ([^\\s]+) in ([^\\s]+) is ready")
    @Then(value="^Kubernetes custom resource ([^\\s]+) in ([^\\s]+) should be ready")
    public void resourceShouldBeReady(String name, String resourceType) {
        this.resourceShouldMatchCondition("Ready", name, resourceType);
    }

    @Given(value="^Kubernetes custom resource ([^\\s]+) is ready")
    @Then(value="^Kubernetes custom resource ([^\\s]+) should be ready")
    public void resourceShouldBeReady(String name, DataTable table) {
        ArrayList<List<String>> cells = new ArrayList<List<String>>(table.cells());
        cells.add(Arrays.asList("name", name));
        this.resourceShouldMatchConditionWithConfiguration("Ready", DataTable.create(cells, (DataTable.TableConverter)table.getTableConverter()));
    }

    @Given(value="^wait for condition=([^\\s]+) on Kubernetes custom resource$")
    public void resourceShouldMatchConditionWithConfiguration(String condition, DataTable table) {
        Map configuration = table.asMap(String.class, String.class);
        if (!configuration.containsKey("kind")) {
            throw new CitrusRuntimeException("Invalid custom resource type configuration - must use proper \"kind\" setting");
        }
        String kind = (String)configuration.get("kind");
        String apiVersion = configuration.getOrDefault("apiVersion", "");
        String group = configuration.getOrDefault("group", apiVersion.length() > 0 ? apiVersion.substring(0, apiVersion.indexOf("/")) : "");
        String version = configuration.getOrDefault("version", apiVersion.length() > 0 ? apiVersion.substring(apiVersion.indexOf("/") + 1) : "");
        String resourceType = configuration.getOrDefault("type", String.format("%ss.%s/%s", kind.toLowerCase(Locale.ENGLISH), group, version));
        if (configuration.containsKey("name")) {
            Object name = (String)configuration.get("name");
            if (!((String)name).contains("/")) {
                name = kind + "/" + (String)name;
            }
            this.resourceShouldMatchCondition(condition, (String)name, resourceType);
        } else if (configuration.containsKey("label")) {
            String labelExpression = (String)configuration.get("label");
            String[] tokens = labelExpression.split("=");
            String labelKey = tokens[0];
            String labelValue = tokens.length > 1 ? tokens[1] : "";
            this.resourceLabeledShouldMatchCondition(condition, kind, resourceType, labelKey, labelValue);
        } else {
            throw new CitrusRuntimeException("Invalid custom resource type configuration - must identify resource via \"name\" or \"label\"");
        }
    }

    @Given(value="^Kubernetes custom resource is ready")
    @Then(value="^Kubernetes custom resource should be ready")
    public void resourceConfiguredShouldBeReady(DataTable table) {
        this.resourceShouldMatchConditionWithConfiguration("Ready", table);
    }

    @Given(value="^wait for condition=([^\\s]+) on Kubernetes custom resource ([^\\s]+) in ([^\\s]+) labeled with ([^\\s]+)=([^\\s]+)$")
    public void resourceLabeledShouldMatchCondition(String condition, String kind, String resourceType, String label, String value) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).customResources().verify(label, value).kind(kind).type(resourceType).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts).condition(condition));
    }

    @Given(value="^Kubernetes custom resource ([^\\s]+) in ([^\\s]+) labeled with ([^\\s]+)=([^\\s]+) is ready")
    @Then(value="^Kubernetes custom resource ([^\\s]+) in ([^\\s]+) labeled with ([^\\s]+)=([^\\s]+) should be ready")
    public void resourceLabeledShouldBeReady(String kind, String resourceType, String label, String value) {
        this.resourceLabeledShouldMatchCondition("Ready", kind, resourceType, label, value);
    }

    @Given(value="^wait for Kubernetes pod ([a-z\\.0-9-]+)$")
    public void waitForRunningPod(String name) {
        this.podShouldBeInPhase(name, "running");
    }

    @Given(value="^Kubernetes pod ([a-z\\.0-9-]+) is (running|stopped)$")
    @Then(value="^Kubernetes pod ([a-z\\.0-9-]+) should be (running|stopped)$")
    public void podShouldBeInPhase(String name, String status) {
        VerifyPodAction.Builder action = KubernetesActionBuilder.kubernetes().client(this.k8sClient).pods().verify(name).printLogs(KubernetesSettings.isPrintPodLogs()).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts);
        if (status.equals("running")) {
            action.isRunning();
        } else {
            action.isStopped();
        }
        this.runner.run((TestActionBuilder)action);
    }

    @Given(value="^wait for Kubernetes pod labeled with ([^\\s]+)=([^\\s]+)$")
    public void waitForRunningPod(String label, String value) {
        this.podByLabelShouldBeInPhase(label, value, "running");
    }

    @Given(value="^Kubernetes pod labeled with ([^\\s]+)=([^\\s]+) is (running|stopped)$")
    @Then(value="^Kubernetes pod labeled with ([^\\s]+)=([^\\s]+) should be (running|stopped)$")
    public void podByLabelShouldBeInPhase(String label, String value, String status) {
        VerifyPodAction.Builder action = KubernetesActionBuilder.kubernetes().client(this.k8sClient).pods().verify(label, value).printLogs(KubernetesSettings.isPrintPodLogs()).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts);
        if (status.equals("running")) {
            action.isRunning();
        } else {
            action.isStopped();
        }
        this.runner.run((TestActionBuilder)action);
    }

    @Then(value="^Kubernetes pod ([a-z\\.0-9-]+) should print (.*)$")
    public void podShouldPrint(String name, String message) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).pods().verify(name).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts).waitForLogMessage(message));
    }

    @Then(value="^Kubernetes pod ([a-z\\.0-9-]+) should not print (.*)$")
    public void podShouldNotPrint(String name, String message) {
        this.runner.run((TestActionBuilder)Assert.Builder.assertException().exception(ActionTimeoutException.class).when(new TestActionBuilder[]{KubernetesActionBuilder.kubernetes().client(this.k8sClient).pods().verify(name).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts).waitForLogMessage(message)}));
    }

    @Then(value="^Kubernetes pod labeled with ([^\\s]+)=([^\\s]+) should print (.*)$")
    public void podByLabelShouldPrint(String label, String value, String message) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).pods().verify(label, value).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts).waitForLogMessage(message));
    }

    @Then(value="^Kubernetes pod labeled with ([^\\s]+)=([^\\s]+) should not print (.*)$")
    public void podByLabelShouldNotPrint(String label, String value, String message) {
        this.runner.run((TestActionBuilder)Assert.Builder.assertException().exception(ActionTimeoutException.class).when(new TestActionBuilder[]{KubernetesActionBuilder.kubernetes().client(this.k8sClient).pods().verify(label, value).maxAttempts(this.maxAttempts).delayBetweenAttempts(this.delayBetweenAttempts).waitForLogMessage(message)}));
    }

    @Given(value="^watch logs timeout is ([\\d]+)(ms|s|min)$")
    public void watchPodLogs(Long time, String timeUnit) {
        switch (timeUnit) {
            case "ms": {
                this.watchLogsTimeout = Duration.ofMillis(time);
                break;
            }
            case "s": {
                this.watchLogsTimeout = Duration.ofSeconds(time);
                break;
            }
            case "min": {
                this.watchLogsTimeout = Duration.ofMinutes(time);
            }
        }
    }

    @Given(value="^watch logs for Kubernetes pod ([a-z\\.0-9-]+)$")
    public void watchPodLogs(String name) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).pods().watchLogs(name).timeout(this.watchLogsTimeout));
    }

    @Given(value="^watch logs for Kubernetes pod labeled with ([^\\s]+)=([^\\s]+)$")
    public void watchPodLogs(String label, String value) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).pods().watchLogs(label, value).timeout(this.watchLogsTimeout));
    }

    @Then(value="^create annotation ([^\\s]+)=([^\\s]+) on Kubernetes (pod|secret|service|deployment) ([a-z\\.0-9-]+)$")
    public void createAnnotationOnResource(String annotation, String value, String resourceType, String resourceName) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).resources().addAnnotation(resourceName, resourceType.toUpperCase(Locale.US)).annotation(annotation, value));
    }

    @Then(value="^create annotations on Kubernetes (pod|secret|service|deployment) ([a-z\\.0-9-]+)$")
    public void createAnnotationOnResource(String resourceType, String resourceName, DataTable table) {
        Map annotations = table.asMap(String.class, String.class);
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).resources().addAnnotation(resourceName, resourceType.toUpperCase(Locale.US)).annotations(annotations));
    }

    @Then(value="^create label ([^\\s]+)=([^\\s]+) on Kubernetes (pod|secret|service|deployment) ([a-z\\.0-9-]+)$")
    public void createLabelOnResource(String label, String value, String resourceType, String resourceName) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).resources().addLabel(resourceName, resourceType.toUpperCase(Locale.US)).label(label, value));
    }

    @Then(value="^create labels on Kubernetes (pod|secret|service|deployment) ([a-z\\.0-9-]+)$")
    public void createLabelOnResource(String resourceType, String resourceName, DataTable table) {
        this.createLabelsOnResource(resourceType, resourceName, table.asMap(String.class, String.class));
    }

    public void createLabelsOnResource(String resourceType, String resourceName, Map<String, String> labels) {
        this.runner.run((TestActionBuilder)KubernetesActionBuilder.kubernetes().client(this.k8sClient).resources().addLabel(resourceName, resourceType.toUpperCase(Locale.US)).labels(labels));
    }

    public void receiveServiceRequest(HttpMessage request) {
        this.httpServerSteps.setRequestMessageType(request.getType());
        this.httpServerSteps.receiveServerRequest(request);
    }

    public void sendServiceResponse(HttpStatus status) {
        this.httpServerSteps.sendServerResponse(status);
    }

    private void initializeService(String serviceName, String targetPort) {
        this.setServiceName(serviceName);
        this.setServicePort(targetPort);
        this.httpServerSteps.startServer();
    }
}

