/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.kubernetes.actions;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.citrusframework.yaks.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.yaks.kubernetes.actions.KubernetesAction;

public class CreateCustomResourceAction
extends AbstractKubernetesAction
implements KubernetesAction {
    private final String type;
    private final String version;
    private final String kind;
    private final String group;
    private final String content;

    public CreateCustomResourceAction(Builder builder) {
        super("create-custom-resource", builder);
        this.type = builder.type;
        this.group = builder.group;
        this.version = builder.version;
        this.kind = builder.kind;
        this.content = builder.content;
    }

    public void doExecute(TestContext context) {
        GenericKubernetesResource resource = (GenericKubernetesResource)((Resource)((NonNamespaceOperation)this.getKubernetesClient().genericKubernetesResources(KubernetesSupport.crdContext(context.replaceDynamicContentInString(this.type), context.replaceDynamicContentInString(this.group), context.replaceDynamicContentInString(this.kind), context.replaceDynamicContentInString(this.version))).inNamespace(this.namespace(context))).load((InputStream)new ByteArrayInputStream(context.replaceDynamicContentInString(this.content).getBytes(StandardCharsets.UTF_8)))).createOrReplace();
        if (resource.get(new Object[]{"messages"}) != null) {
            throw new CitrusRuntimeException(String.format("Failed to create custom resource - %s", (Object[])resource.get(new Object[]{"messages"})));
        }
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<CreateCustomResourceAction, Builder> {
        private String type;
        private String version;
        private String kind;
        private String group;
        private String content;

        public Builder type(String resourceType) {
            this.type = resourceType;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            String[] groupAndVersion = apiVersion.split("/");
            this.group(groupAndVersion[0]);
            this.version(groupAndVersion[1]);
            return this;
        }

        public CreateCustomResourceAction build() {
            return new CreateCustomResourceAction(this);
        }
    }
}

