/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.kubernetes.actions;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.kubernetes.KubernetesSettings;
import org.citrusframework.yaks.kubernetes.actions.AbstractKubernetesAction;

public class CreateServiceAction
extends AbstractKubernetesAction {
    private final String serviceName;
    private final List<String> ports;
    private final List<String> targetPorts;
    private final String protocol;

    public CreateServiceAction(Builder builder) {
        super("create-service", builder);
        this.serviceName = builder.serviceName;
        this.ports = builder.ports;
        this.targetPorts = builder.targetPorts;
        this.protocol = builder.protocol;
    }

    public void doExecute(TestContext context) {
        ArrayList<ServicePort> servicePorts = new ArrayList<ServicePort>();
        for (int i = 0; i < this.ports.size(); ++i) {
            String targetPort = i < this.targetPorts.size() ? this.targetPorts.get(i) : this.ports.get(i);
            servicePorts.add(((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("port-mapping-" + i)).withProtocol(context.replaceDynamicContentInString(this.protocol))).withPort(Integer.valueOf(Integer.parseInt(context.replaceDynamicContentInString(this.ports.get(i)))))).withTargetPort(new IntOrString((Object)Integer.parseInt(context.replaceDynamicContentInString(targetPort))))).build());
        }
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withNamespace(this.namespace(context))).withName(context.replaceDynamicContentInString(this.serviceName))).withLabels(KubernetesSettings.getDefaultLabels())).endMetadata()).withNewSpec().withSelector(Collections.singletonMap("yaks.citrusframework.org/test-id", YaksSettings.getTestId()))).withPorts(servicePorts)).endSpec()).build();
        Service created = (Service)((ServiceResource)((NonNamespaceOperation)this.getKubernetesClient().services().inNamespace(this.namespace(context))).resource((Object)service)).createOr(Updatable::update);
        if (created.getSpec().getClusterIP() != null) {
            context.setVariable("YAKS_KUBERNETES_SERVICE_CLUSTER_IP", (Object)created.getSpec().getClusterIP());
        }
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<CreateServiceAction, Builder> {
        private String serviceName;
        private final List<String> ports = new ArrayList<String>();
        private final List<String> targetPorts = new ArrayList<String>();
        private String protocol = "TCP";

        public Builder name(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder ports(String ... ports) {
            Arrays.stream(ports).forEach(this::port);
            return this;
        }

        public Builder ports(int ... ports) {
            Arrays.stream(ports).forEach(this::port);
            return this;
        }

        public Builder port(String port) {
            this.ports.add(port);
            return this;
        }

        public Builder port(int port) {
            this.ports.add(String.valueOf(port));
            return this;
        }

        public Builder portMapping(String port, String targetPort) {
            this.port(port);
            this.targetPort(targetPort);
            return this;
        }

        public Builder portMapping(int port, int targetPort) {
            this.port(port);
            this.targetPort(targetPort);
            return this;
        }

        public Builder targetPorts(String ... targetPorts) {
            Arrays.stream(targetPorts).forEach(this::targetPort);
            return this;
        }

        public Builder targetPorts(int ... targetPorts) {
            Arrays.stream(targetPorts).forEach(this::targetPort);
            return this;
        }

        public Builder targetPort(String targetPort) {
            this.targetPorts.add(targetPort);
            return this;
        }

        public Builder targetPort(int targetPort) {
            this.targetPorts.add(String.valueOf(targetPort));
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public CreateServiceAction build() {
            if (this.ports.isEmpty()) {
                this.ports.add("80");
            }
            if (this.targetPorts.isEmpty()) {
                this.targetPorts.add("8080");
            }
            return new CreateServiceAction(this);
        }
    }
}

