/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.kubernetes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.Citrus;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.kubernetes.KubernetesSettings;
import org.citrusframework.yaks.kubernetes.KubernetesVariableNames;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public final class KubernetesSupport {
    private static final ObjectMapper OBJECT_MAPPER = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new DeserializationFeature[]{DeserializationFeature.READ_ENUMS_USING_TO_STRING})).enable(new SerializationFeature[]{SerializationFeature.WRITE_ENUMS_USING_TO_STRING})).disable(new JsonParser.Feature[]{JsonParser.Feature.AUTO_CLOSE_SOURCE})).enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES})).build()).setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_EMPTY, (JsonInclude.Include)JsonInclude.Include.NON_EMPTY));

    private KubernetesSupport() {
    }

    public static String dumpYaml(Object model) {
        return KubernetesSupport.yaml().dumpAsMap(KubernetesSupport.json().convertValue(model, Map.class));
    }

    public static KubernetesClient getKubernetesClient(Citrus citrus) {
        if (YaksSettings.isLocal()) {
            return null;
        }
        if ((long)citrus.getCitrusContext().getReferenceResolver().resolveAll(KubernetesClient.class).size() == 1L) {
            return (KubernetesClient)citrus.getCitrusContext().getReferenceResolver().resolve(KubernetesClient.class);
        }
        return new KubernetesClientBuilder().build();
    }

    public static KubernetesClient getKubernetesClient(TestContext context) {
        if ((long)context.getReferenceResolver().resolveAll(KubernetesClient.class).size() == 1L) {
            return (KubernetesClient)context.getReferenceResolver().resolve(KubernetesClient.class);
        }
        return new KubernetesClientBuilder().build();
    }

    public static String getNamespace(TestContext context) {
        if (context.getVariables().containsKey(KubernetesVariableNames.NAMESPACE.value())) {
            return context.getVariable(KubernetesVariableNames.NAMESPACE.value());
        }
        return KubernetesSettings.getNamespace();
    }

    public static Yaml yaml() {
        Representer representer = new Representer(new DumperOptions()){

            protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                if (propertyValue == null || propertyValue instanceof Collection && ((Collection)propertyValue).isEmpty() || propertyValue instanceof Map && ((Map)propertyValue).isEmpty()) {
                    return null;
                }
                return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            }
        };
        representer.getPropertyUtils().setSkipMissingProperties(true);
        return new Yaml(representer);
    }

    public static ObjectMapper json() {
        return OBJECT_MAPPER;
    }

    public static GenericKubernetesResource getResource(KubernetesClient k8sClient, String namespace, ResourceDefinitionContext context, String resourceName) {
        return (GenericKubernetesResource)((Resource)((NonNamespaceOperation)k8sClient.genericKubernetesResources(context).inNamespace(namespace)).withName(resourceName)).get();
    }

    public static GenericKubernetesResourceList getResources(KubernetesClient k8sClient, String namespace, ResourceDefinitionContext context) {
        return (GenericKubernetesResourceList)((NonNamespaceOperation)k8sClient.genericKubernetesResources(context).inNamespace(namespace)).list();
    }

    public static GenericKubernetesResourceList getResources(KubernetesClient k8sClient, String namespace, ResourceDefinitionContext context, String labelKey, String labelValue) {
        return (GenericKubernetesResourceList)((FilterWatchListDeletable)((NonNamespaceOperation)k8sClient.genericKubernetesResources(context).inNamespace(namespace)).withLabel(labelKey, labelValue)).list();
    }

    public static <T> void createResource(KubernetesClient k8sClient, String namespace, ResourceDefinitionContext context, T resource) {
        KubernetesSupport.createResource(k8sClient, namespace, context, KubernetesSupport.yaml().dumpAsMap(resource));
    }

    public static void createResource(KubernetesClient k8sClient, String namespace, ResourceDefinitionContext context, String yaml) {
        ((Resource)((NonNamespaceOperation)k8sClient.genericKubernetesResources(context).inNamespace(namespace)).load((InputStream)new ByteArrayInputStream(yaml.getBytes(StandardCharsets.UTF_8)))).createOr(Updatable::update);
    }

    public static void deleteResource(KubernetesClient k8sClient, String namespace, ResourceDefinitionContext context, String resourceName) {
        ((Resource)((NonNamespaceOperation)k8sClient.genericKubernetesResources(context).inNamespace(namespace)).withName(resourceName)).delete();
    }

    public static ResourceDefinitionContext crdContext(String resourceType, String group, String kind, String version) {
        return new ResourceDefinitionContext.Builder().withGroup(group).withKind(kind).withVersion(version).withPlural(resourceType.contains(".") ? resourceType.substring(0, resourceType.indexOf(".")) : resourceType).withNamespaced(true).build();
    }

    public static boolean verifyPodStatus(Pod pod, String status) {
        if (pod == null || pod.getStatus() == null || !status.equals(pod.getStatus().getPhase())) {
            return false;
        }
        return !status.equals("Running") || pod.getStatus().getContainerStatuses().stream().allMatch(ContainerStatus::getReady);
    }

    public static Optional<String> getServiceClusterIp(Citrus citrus, String serviceName, String namespace) {
        try {
            Service service = (Service)((ServiceResource)((NonNamespaceOperation)KubernetesSupport.getKubernetesClient(citrus).services().inNamespace(namespace)).withName(serviceName)).get();
            if (service != null) {
                return Optional.ofNullable(service.getSpec().getClusterIP());
            }
        }
        catch (KubernetesClientException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }
}

