/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.kubernetes.actions;

import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.HashMap;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.yaks.kubernetes.actions.KubernetesAction;

public class CreateLabelsAction
extends AbstractKubernetesAction
implements KubernetesAction {
    private final String resourceName;
    private final ResourceType resourceType;
    private final Map<String, String> labels;

    public CreateLabelsAction(Builder builder) {
        super("create-label", builder);
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.labels = builder.labels;
    }

    public void doExecute(TestContext context) {
        Map resolvedLabels = context.resolveDynamicValuesInMap(this.labels);
        switch (this.resourceType) {
            case DEPLOYMENT: {
                ((RollableScalableResource)((NonNamespaceOperation)this.getKubernetesClient().apps().deployments().inNamespace(this.namespace(context))).withName(this.resourceName)).edit(d -> ((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder(d).editMetadata().addToLabels(resolvedLabels)).endMetadata()).build());
                break;
            }
            case POD: {
                ((PodResource)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(this.namespace(context))).withName(this.resourceName)).edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editMetadata().addToLabels(resolvedLabels)).endMetadata()).build());
                break;
            }
            case SERVICE: {
                ((ServiceResource)((NonNamespaceOperation)this.getKubernetesClient().services().inNamespace(this.namespace(context))).withName(this.resourceName)).edit(s -> ((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder(s).editMetadata().addToLabels(resolvedLabels)).endMetadata()).build());
                break;
            }
            case SECRET: {
                ((Resource)((NonNamespaceOperation)this.getKubernetesClient().secrets().inNamespace(this.namespace(context))).withName(this.resourceName)).edit(s -> ((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder(s).editMetadata().addToLabels(resolvedLabels)).endMetadata()).build());
                break;
            }
            default: {
                throw new CitrusRuntimeException(String.format("Unable to add label to resource type '%s'", this.resourceType.name()));
            }
        }
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<CreateLabelsAction, Builder> {
        private String resourceName;
        private ResourceType resourceType = ResourceType.POD;
        private final Map<String, String> labels = new HashMap<String, String>();

        public Builder name(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public Builder deployment(String name) {
            this.resourceName = name;
            return this.type(ResourceType.DEPLOYMENT);
        }

        public Builder pod(String name) {
            this.resourceName = name;
            return this.type(ResourceType.POD);
        }

        public Builder secret(String name) {
            this.resourceName = name;
            return this.type(ResourceType.SECRET);
        }

        public Builder service(String name) {
            this.resourceName = name;
            return this.type(ResourceType.SERVICE);
        }

        private Builder type(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder type(String resourceType) {
            return this.type(ResourceType.valueOf(resourceType));
        }

        public Builder labels(Map<String, String> labels) {
            this.labels.putAll(labels);
            return this;
        }

        public Builder label(String label, String value) {
            this.labels.put(label, value);
            return this;
        }

        public CreateLabelsAction build() {
            return new CreateLabelsAction(this);
        }
    }

    public static enum ResourceType {
        DEPLOYMENT,
        POD,
        SECRET,
        SERVICE;

    }
}

